<%--
    Document   : optInReport
    Created on : Dec 1, 2014
    Author     : Irakli Kakushadze
--%>
<%@page import="gov.va.nvap.svc.facility.data.Facility"%>
<%@page import="java.util.HashMap"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp"%>
<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>

<%
    HashMap tips = (HashMap) session.getAttribute("descriptors");
    String facilityFilterTooltip = (String) tips.get("authenticatingFacilityField");
    Facility defaultUserFacility = (Facility) session.getAttribute("defaultUserFacility");
    String defaultUserFacilityName = defaultUserFacility == null ? "" : defaultUserFacility.getFacilityName();
    String defaultUserFacilityStation = defaultUserFacility == null ? "" : defaultUserFacility.getFacilityStation();
    pageContext.setAttribute("facilityFilterTooltip", facilityFilterTooltip);
    pageContext.setAttribute("defaultUserFacility", defaultUserFacility);
    pageContext.setAttribute("defaultUserFacilityName", defaultUserFacilityName);
    pageContext.setAttribute("defaultUserFacilityStation", defaultUserFacilityStation);
%>

<f:mainTemplate headerText="Opt-In Patients Report">
    <script type="text/javascript">
        $(document).ready(function () {

            setProcessingForDataTable('reportTable');

            reportTable = $('#reportTable').DataTable({
                deferLoading: 0,
                destroy: true,
                ajax:{
                    url: constructUrl('doSearch'),
                    dataSrc: function(json){
                        return json.data;
                    }
                },
                dom: 'liptipr',
                serverSide: true,
                processing: true,
                searching: false,
                language: {
                    emptyTable: "No records found",
                    loadingRecords: ""
                },
                lengthMenu: [ 10, 25, 50, 100, 250, 500 ],
                columnDefs: [
                    {
                        targets: 0,
                        data: null,
                        render: function(data,type,full,meta){
                            return '<a href="#/" onclick="linkToPatient(\''+data[9]+'\', \''+data[1]+'\', \''+data[2]+'\');">'+data[0]+'</a>';
                        }
                    },
                    {className: "vap-col-min-80 dt-head-center", targets: 0},
                    {className: "vap-col-min-200 dt-head-center", targets: [6,8]},
                    {className: "dt-head-center", targets: [1,2,3,4,5,7]}
                ],
                pageLength: 25,
                scrollX:true,
                initComplete: function(){
                    // Enable THEAD scroll bars
                    $('.dataTables_scrollHead').css('overflow', 'auto');

                    // Sync THEAD scrolling with TBODY
                    $('.dataTables_scrollHead').on('scroll', function () {
                        $('.dataTables_scrollBody').scrollLeft($(this).scrollLeft());
                    });
                },
                order: [[4, "desc"]]
             });

            // DataTable overrides
            $.fn.dataTable.ext.errMode = 'none';

            reportTable.on('draw', function () {
                addAriaToDataTable('reportTable', reportTable);
            });

            $('#searchButton').on('click', function () {
                $('#results').show();
                reportTable.ajax.url(constructUrl('doSearch')).load();
            });

            $('#results').hide();
        });

        constructUrl = function(methodName){
            var url = 'OptInReport.do_sec?' + methodName +'=true' +
                '&optInReport=true' +
                '&enteredBy=' + $('#enteredBy').val() +
                '&patientTypes=' + $('#patientTypes').val() +
                '&stationNumbers=' + facilitiesDialog.getSelectedStationNumbers() +
                '&consentTypeName=' + $('#consentTypeName').val() +
                '&includeUnknownVisn=' + facilitiesDialog.getIncludeUnknownVisn() +
                '&sortBy=' + $('#reportTable').dataTable().fnSettings().aaSorting[0][0] +
                '&sortOrder=' + $('#reportTable').dataTable().fnSettings().aaSorting[0][1];

            if (methodName === 'exportToCsv' || methodName === 'exportToExcel') {
                url = url + '&totalRows=' + reportTable.page.info().recordsTotal;
            }

            return url;
        };
    </script>

    <div class="well">
        Fill in the fields below to narrow your search.
    </div>

    <cpp:errors/>

    <div class="form-container">
        <form name="optInReportForm" action="OptInReport.do_sec" method="POST" onsubmit="return doSubmit(this)">
            <fieldset>
                <legend>Search Details</legend>
                <jsp:include page="reporting/common/facilitiesFilter.jsp">
                    <jsp:param name="defaultUserFacility" value="${defaultUserFacility}" />
                    <jsp:param name="defaultUserFacilityName" value="${defaultUserFacilityName}" />
                    <jsp:param name="defaultUserFacilityStation" value="${defaultUserFacilityStation}" />
                    <jsp:param name="facilityFilterTooltip" value="${facilityFilterTooltip}" />
                    <jsp:param name="optInReport" value="true" />
                </jsp:include>
                <div>
                    <label for="consentTypeName">Consent Type<span style="display:none;">"Query based on consent type from the dropdown list"</span></label>
                    <select id="consentTypeName" name="consentTypeName" data-tooltip="<c:out value="${descriptors['consentTypeField']}" />">
                        <option value="" selected>ALL Authorizations</option>
                        <option value="NwHIN Authorization"><c:out value="${organizationName}"/> Authorizations</option>
                        <option value="SSA Authorization">SSA Authorizations</option>
                    </select>
                </div>
                <div>
                    <label for="enteredBy">Entered By<span style="display:none;">"Query based on whom entered information from the dropdown list"</span></label>
                    <select id="enteredBy" name="enteredBy" data-tooltip="<c:out value="${descriptors['enteredByField']}" />">
                        <option value="" selected>ALL</option>
                        <option value="eBenefits">eBenefits</option>
                        <option value="employee">Employee</option>
                    </select>
                </div>
                <div>
                    <label for="patientTypes">Patient Types<span style="display:none;">"Choose whether you would like to filter by real patients only, test patients only, or both."</span></label>
                    <select id="patientTypes" name="patientTypes" data-tooltip="<c:out value="${descriptors['patientTypesField']}" />">
                        <option value="3">ALL</option>
                        <option value="1" selected>Real Patients</option>
                        <option value="2">Test Patients</option>
                    </select>
                </div>
            </fieldset>
        </form>
        <div>
            <input id="searchButton" name="search" title="Search" class="button" type="submit" value="Search"/>
        </div>
    </div>
    <div id="results">
    <div align="right" class="pad-top-5">
        <input id="excelButton" name="excelButton" class="button" type="submit" value="Export To Excel" />
        &nbsp;&nbsp;
        <input id="csvButton" name="csvButton" class="button" type="submit" value="Export To CSV" />
    </div>
    <div id="divReportContent">
        <%@include file="patientLinkForm.jsp"%>
        <table id="reportTable" class="display" width="100%" cellspacing="0" role="presentation">
            <thead>
                <tr role="row">
                    <th role="columnheader"><span id="ssnHeader" data-tooltip="<c:out value="${descriptors['ssnColumn']}" />">SSN</span></th>
                    <th role="columnheader"><span id="lastNameHeader" data-tooltip="<c:out value="${descriptors['lastNameColumn']}" />">Patient Last Name</span></th>
                    <th role="columnheader"><span id="firstNameHeader" data-tooltip="<c:out value="${descriptors['firstNameColumn']}" />">Patient First Name</span></th>
                    <th role="columnheader"><span id="middleNameHeader" data-tooltip="<c:out value="${descriptors['middleNameColumn']}" />">Patient Middle Name</span></th>
                    <th role="columnheader"><span id="optInDateHeader" data-tooltip="<c:out value="${descriptors['optInPatientsReportOptInDateColumn']}" />">Opt In Date</span></th>
                    <th role="columnheader"><span id="expDateHeader" data-tooltip="<c:out value="${descriptors['optInPatientsReportExpirationDateColumn']}" />">Expiration Date</span></th>
                    <th role="columnheader"><span id="consentTypeHeader" data-tooltip="<c:out value="${descriptors['consentTypeColumn']}" />">Consent Type</span></th>
                    <th role="columnheader"><span id="enteredByHeader" data-tooltip="<c:out value="${descriptors['enteredByManualOrSystemColumn']}" />">Entered By</span></th>
                    <th role="columnheader"><span id="authFacilityHeader" data-tooltip="<c:out value="${descriptors['optInPatientsReportAuthenticatingFacilityColumn']}" />" data-tooltip-position="left">Authenticating Facility</span></th>
                </tr>
            </thead>
        </table>
    </div>
    </div>
</f:mainTemplate>