<%@page import="gov.va.nvap.web.user.UserHelper"%>
﻿<%--
    Document   : Opt-in/Opt-out Summary Report
    Created By : David Vasquez / Robert Snelling
    Modified By: Asha Amritraj
--%>
<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@taglib tagdir="/WEB-INF/tags/paginator" prefix="pg"%>

<%
    String userName = UserHelper.getUserName(request);
%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
    "http://www.w3.org/TR/html4/loose.dtd">

<html lang="en">
        <head>
        <title>Veterans Authorization & Preferences Consent Directive Report Results</title>
        <%@include file="metaCommon.jsp" %>
        </head>
<body>
<jsp:include page="header.jsp">
    <jsp:param name="userName" value="<%=userName%>" />
</jsp:include>
<table border="0" cellpadding="0" cellspacing="0" width="100%" summary="table is used for layout purposes" id="main-content-table">
	<tbody>
    	<tr>
			<jsp:include page="leftMenu.jsp">
                <jsp:param name="userName" value="<%=userName%>" />
            </jsp:include>
            <th scope="row" style="float: left; font-size: 0; height: 0;">VA Content</th>
            <td id="content-va">
                <a name="content-area"></a>
                <!-- START: SITE NAME BAR -->
                <p class="title-bar"><!-- START: SITE NAME -->Consent Directive Summary Report<!-- END: SITE NAME --></p>
                <cpp:errors />
                <!-- END: SITE NAME BAR -->
                <table border="0" cellpadding="0" cellspacing="0" width="100%" summary="table is used for layout purposes">
                    <tbody>
                        <tr>
                            <th scope="row" style="float: left; font-size: 0; height: 0;">Main Content</th>
                            <td id="content-main">
                            	<table width="100%" summary="This table is used for layout purposes">
                                  <!-- START: PAGE TITLE AREA -->
                                  <!-- END: PAGE TITLE AREA -->
    	                          <tr>
                                      <th scope="row" style="float: left; font-size: 0; height: 0;">Page Content</th>
	    		                      <td>
                			            <!-- START: PAGE CONTENT -->
                                        <table SUMMARY="This table is for formatting purposes only.">
                                            <tbody>
                                                <tr>
                                                    <th scope="row" style="float: left; font-size: 0; height: 0;">Button Row</th>
                                                    <td>
                                                        <form>
                                                            <input name="exportToExcel" alt="Export to Excel" class="button" type="submit" value="Export to Excel" />
                                                        </form>
                                                        <table class="ver-minimalist">
                                                            <tbody>
                                                                <tr class="dateFilters">
                                                                    <th scope="row" style="border-bottom: none; float: left; font-size: 0; height: 0;">Filters</th>
                                                                    <td class="datePadding" style="float: left;">Start Date</td>
                                                                    <td><c:choose>
                                                                            <c:when test="${!empty optInOptOutSummaryQueryStartDate}">
                                                                                <fmt:formatDate pattern="MM/dd/yyyy"
                                                                                    value="${optInOptOutSummaryQueryStartDate}" />
                                                                            </c:when>
                                                                            <c:otherwise>
                                                                                    N/A
                                                                                </c:otherwise>
                                                                        </c:choose>
                                                                    </td>
                                                                    <td class="datePadding">End Date</td>
                                                                    <td><c:choose>
                                                                            <c:when test="${!empty optInOptOutSummaryQueryEndDate}">
                                                                                <fmt:formatDate pattern="MM/dd/yyyy"
                                                                                    value="${optInOptOutSummaryQueryEndDate}" />
                                                                            </c:when>
                                                                            <c:otherwise>
                                                                                    N/A
                                                                                </c:otherwise>
                                                                        </c:choose>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <c:choose>
                                                            <c:when test="${!empty optInOptOutSummaryResults}">
                                                                <br/>
                                                                <table>
                                                                    <thead>
                                                                        <tr class="hor-minimalist-c">
                                                                            <th scope="col"><span id="authFacilityHeader" data-tooltip="<c:out value="${descriptors['authenticatingFacilityColumn']}" />">Authenticating Facility</span></td>
                                                                            <th scope="col"><span id="consentTypeHeader" data-tooltip="<c:out value="${descriptors['consentTypeColumn']}" />">Consent Type</span></td>
                                                                            <th scope="col"><span id="totalHeader" data-tooltip="<c:out value="${descriptors['consentDirectiveSummaryReportTotalColumn']}" />" data-tooltip-position="left">Total</span></td>
                                                                        </tr>
                                                                        <tr class="hor-minimalist-c">
                                                                            <td><a href="OptInOptOutSummaryReportResults.do_sec?optInOptOutSummaryReportSortValue=facilityName&optInOptOutSummaryReportSortDirection=ASC"><br><img alt="sort this column in ascending order" src="res/sort-ascending.jpg" border="0"/></a><a> - </a><a href="OptInOptOutSummaryReportResults.do_sec?optInOptOutSummaryReportSortValue=facilityName&optInOptOutSummaryReportSortDirection=DESC"><img alt="sort this column in descending order" src="res/sort-descending.jpg" border="0"/></a></th>
                                                                        	<td><a href="OptInOptOutSummaryReportResults.do_sec?optInOptOutSummaryReportSortValue=consentType&optInOptOutSummaryReportSortDirection=ASC"><br><img alt="sort this column in ascending order" src="res/sort-ascending.jpg" border="0"/></a><a> - </a><a href="OptInOptOutSummaryReportResults.do_sec?optInOptOutSummaryReportSortValue=consentType&optInOptOutSummaryReportSortDirection=DESC"><img alt="sort this column in descending order" src="res/sort-descending.jpg" border="0"/></a></td>
                                                                        	<td><a href="OptInOptOutSummaryReportResults.do_sec?optInOptOutSummaryReportSortValue=total&optInOptOutSummaryReportSortDirection=ASC"><br><img alt="sort this column in ascending order" src="res/sort-ascending.jpg" border="0"/></a><a> - </a><a href="OptInOptOutSummaryReportResults.do_sec?optInOptOutSummaryReportSortValue=total&optInOptOutSummaryReportSortDirection=DESC"><img alt="sort this column in descending order" src="res/sort-descending.jpg" border="0"/></a></td>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        <pg:forEach var="r" items="${optInOptOutSummaryResults}" varStatus="i"
                                                                            paginator="${paginator}">
                                                                            <tr class="hor-minimalist-b">
																				<c:choose>
																					<c:when test="${r.facilityName==''}">
																						<td>UNKNOWN</td>
																					</c:when>
																					<c:when test="${r.facilityName eq empty facilityName}">
																						<td>UNKNOWN</td>
																					</c:when>
																					<c:otherwise>
																						<td><c:out value="${r.facilityName}"/></td>
																					</c:otherwise>
																				</c:choose>
																				<td>
                                                                                	<c:choose>
                                                                                		<c:when test="${r.consentType ne null and not empty r.consentType}">
                                                                                			<c:out value="${r.consentType}"/>
                                                                                		</c:when>
                                                                                		<c:otherwise> <!--  there is a non-deliminated space there to make sure lines look appropriate when the jsp is rendered -->
                                                                                		</c:otherwise>
                                                                                	</c:choose>
                                                                                </td>
																				<td><c:out value="${r.count}"/></td>
                                                                            </tr>
                                                                        </pg:forEach>
                                                                    </tbody>
                                                                </table>
                                                            </c:when>
                                                            <c:otherwise>
                                                                    No records were found.
                                                                </c:otherwise>
                                                        </c:choose>
                                                        <br/>
                                                        <table>
                                                            <tr>
                                                                <th scope="row">
                                                                    <b>Total <c:out value="${organizationName}"/> Authorizations:</b>
                                                                </th>
                                                                <td>
                                                                    <c:out value="${nwhinAuthorizationTotal}"/>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <th scope="row">
                                                                    <b>Total <c:out value="${organizationName}"/> Revocations:</b>
                                                                </th>
                                                                <td>
                                                                    <c:out value="${nwhinRevocationTotal}"/>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <th scope="row">
                                                                    <b>Total <c:out value="${organizationName}"/> Restrictions:</b>
                                                                </th>
                                                                <td>
                                                                    <c:out value="${nwhinRestrictionTotal}"/>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <th scope="row">
                                                                    <b>Total <c:out value="${organizationName}"/> Restriction Revocations:</b>
                                                                </th>
                                                                <td>
                                                                    <c:out value="${nwhinRestrictionRevocationTotal}"/>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <th scope="row">
                                                                    <b>Total SSA Authorizations:</b>
                                                                </th>
                                                                <td>
                                                                    <c:out value="${ssaAuthorizationTotal}"/>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <th scope="row">
                                                                    <b>Total SSA Revocations:</b>
                                                                </th>
                                                                <td>
                                                                    <c:out value="${ssaRevocationTotal}"/>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <!-- THE BODY CONTENT END -->
                                       </td>
                                 	</tr>
								</table>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <!-- START: PAGE FOOTER -->
                <%@include file="footer.jsp" %>
                <!-- END: PAGE FOOTER -->
                <!-- END: PAGE CONTENT -->
            </td>
        </tr>
    </tbody>
</table>
</body>
</html>