<%--
    Document   : Opt-in/Opt-out Summary Report
    Created By : David Vasquez / Robert Snelling
    Modified By: Asha Amritraj
--%>
<%@page import="gov.va.nvap.svc.facility.data.Facility"%>
<%@page import="java.util.HashMap"%>
<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp" %>
<%@taglib tagdir="/WEB-INF/tags/date" prefix="date" %>
<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>

<%
    HashMap tips = (HashMap) session.getAttribute("descriptors");
    String facilityFilterTooltip = (String) tips.get("authenticatingFacilityField");
    Facility defaultUserFacility = (Facility) session.getAttribute("defaultUserFacility");
    String defaultUserFacilityName = defaultUserFacility == null ? "" : defaultUserFacility.getFacilityName();
    String defaultUserFacilityStation = defaultUserFacility == null ? "" : defaultUserFacility.getFacilityStation();
    pageContext.setAttribute("facilityFilterTooltip", facilityFilterTooltip);
    pageContext.setAttribute("defaultUserFacility", defaultUserFacility);
    pageContext.setAttribute("defaultUserFacilityName", defaultUserFacilityName);
    pageContext.setAttribute("defaultUserFacilityStation", defaultUserFacilityStation);
%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
    "http://www.w3.org/TR/html4/loose.dtd">

<f:mainTemplate headerText="Consent Directive Summary Report">
    <script language="JavaScript">
        $(document).ready(function () {
            $("#startDate").datepicker({
                maxDate: 0,
                dateFormat: 'mm/dd/yy',
                onClose: function (selectedDate) {
                    $("#endDate").datepicker("option", "minDate", selectedDate);
                }
            });

            $("#endDate").datepicker({
                maxDate: 0,
                dateFormat: 'mm/dd/yy',
                onClose: function (selectedDate) {
                    $("#startDate").datepicker("option", "maxDate", selectedDate);
                }
            });

            setProcessingForDataTable('reportTable', -14);

            var reportTable = $('#reportTable').DataTable({
                deferLoading: 0,
                destroy: true,
                ajax: constructUrl("doSearch"),
                info: false,
                language: {
                    emptyTable: "No records found",
                    loadingRecords: ""
                },
                ordering: true,
                paging: false,
                processing: true,
                searching: false,
                serverSide: true,
                columnDefs: [
                    {className: "width-350 dt-head-center", targets: [0]},
                    {className: "dt-head-center dt-body-right", targets: [1,2,3,4,5,6]}
                ],
                scrollX:true,
                initComplete: function(){
                    // Enable THEAD scroll bars
                    $('.dataTables_scrollHead').css('overflow', 'auto');

                    // Sync THEAD scrolling with TBODY
                    $('.dataTables_scrollHead').on('scroll', function () {
                        $('.dataTables_scrollBody').scrollLeft($(this).scrollLeft());
                    });
                },
                "footerCallback": function ( row, data, start, end, display ) {
                    var api = this.api(), data;

                    // Update footers
                    $(api.column(1).footer() ).html(
                        api.column(1, {page:'current'}).data().sum()
                    );

                    $(api.column(2).footer() ).html(
                        api.column(2, {page:'current'}).data().sum()
                    );

                    $(api.column(3).footer() ).html(
                        api.column(3, {page:'current'}).data().sum()
                    );

                    $(api.column(4).footer() ).html(
                        api.column(4, {page:'current'}).data().sum()
                    );

                    $(api.column(5).footer() ).html(
                        api.column(5, {page:'current'}).data().sum()
                    );

                    $(api.column(6).footer() ).html(
                        api.column(6, {page:'current'}).data().sum()
                    );
                }
            });

            //datatable overrides
            $.fn.dataTable.ext.errMode = 'none';

            reportTable.on('draw', function () {
                addAriaToDataTable('reportTable', reportTable);
            });

            $('#searchButton').on('click', function () {
                var startDate = $('#startDate').val();
                var endDate = $('#endDate').val();

                var errorMessage = validateStartAndEndDate(startDate, endDate);

                if (errorMessage != '')
                {
                    //we have an error so show the error, and then don't send the ajax request
                    $('#errorMessage').html(errorMessage);
                    $('#errorMessage').show();

                    return false;
                } else {
                    //no error, let's make the call to populate the report
                    $('#results').show();
                    reportTable.ajax.url(constructUrl('doSearch')).load();
                }
            });

            $('.exportButton').on('click', function () {
                window.location.href = constructUrl($(this).data('method'));
                return false;
            });

            function constructUrl(methodName) {
                var url = 'OptInOptOutSummaryReport.do_sec' +
                    '?' + methodName + '=true' +
                    '&startDate=' + $('#startDate').val() +
                    '&endDate=' + $('#endDate').val() +
                    '&actionType=' + $('#actionType').val() +
                    '&stationNumbers=' + facilitiesDialog.getSelectedStationNumbers() +
                    '&patientTypes=' + $('#patientTypes').val() +
                    '&enteredBy=' + $('#enteredBy').val() +
                    '&includeUnknownVisn=' + facilitiesDialog.getIncludeUnknownVisn() +
                    '&aggregateAtFacilityLevel=' + facilitiesDialog.getAggregateAtFacilityLevel()+
                    '&sortBy=' + $('#reportTable').dataTable().fnSettings().aaSorting[0][0] +
                    '&sortOrder=' + $('#reportTable').dataTable().fnSettings().aaSorting[0][1];
                return url;
            }

            $('#startDate,#endDate').on('change', function () {
                //if either date changes, hide the error message if its not already hidden
                $('#errorMessage').hide();
            });

            $('#results').hide();
        });
    </script>

    <div class="well">
        Fill in the fields below to narrow your search. All dates will be included if Start Date and End Date are left blank.
    </div>
    <div class="form-container">
        <form name="optInOptOutSummaryReportForm">
            <fieldset>
                <input type="hidden" id="consentTypeName" name="consentTypeName" />
                <legend>Search Details</legend>
                <div id="errorMessage" class="bg-warning pad-15" style="display: none;"></div>
                <div class="width-450 pad-top-10" id="dateTip" data-tooltip="<c:out value="${descriptors['startDateEndDateField']}"/>">
                    <div>
                        <label for="startDate">Start Date</label>
                        <date:date id="startDate" name="startDate" value="${startDateDefault}"/> <i>mm/dd/yyyy</i>
                    </div>
                    <div>
                        <label for="endDate">End Date</label>
                        <date:date id="endDate" name="endDate"  value="${endDateDefault}" /> <i>mm/dd/yyyy</i>
                    </div>
                </div>
                <jsp:include page="reporting/common/facilitiesFilter.jsp">
                    <jsp:param name="defaultUserFacility" value="${defaultUserFacility}" />
                    <jsp:param name="defaultUserFacilityName" value="${defaultUserFacilityName}" />
                    <jsp:param name="defaultUserFacilityStation" value="${defaultUserFacilityStation}" />
                    <jsp:param name="facilityFilterTooltip" value="${facilityFilterTooltip}" />
                </jsp:include>
                <div>
                    <label for="enteredBy">Entered By<span style="display:none;">"Partial or full ID of the user that entered or submitted the consent"</span></label>
                    <input title="Entered By" id="enteredBy" name="enteredBy" type="text" maxlength="255" size="30" data-tooltip="<c:out value="${descriptors['enteredByField']}" />"/>
                </div>
                <div>
                    <label for="patientTypes">Patient Types<span style="display:none;">"Choose whether you would like to filter by real patients only, test patients only, or both."</span></label>
                    <select id="patientTypes" name="patientTypes" data-tooltip="<c:out value="${descriptors['patientTypesField']}" />">
                        <option value="3">ALL</option>
                        <option value="1" selected>Real Patients</option>
                        <option value="2">Test Patients</option>
                    </select>
                </div>
            </fieldset>
        </form>
        <div>
            <input name="search" title="Search" class="button" type="submit" value="Search" id="searchButton"/>
        </div>
    </div>
    <div id="results">
    <div align="right" class="pad-top-5 pad-bottom-15">
        <a href="#"><button class="exportButton" data-method="exportToExcel" title="Export to Excel">Export to Excel</button></a>
    </div>
    <div id="divReportContent">
        <table id="reportTable" class="display" width="100%" cellspacing="0" role="presentation">
            <thead>
                <tr role="row">
                    <th role="columnheader"><span id="authFacilityHeader" data-tooltip="<c:out value="${descriptors['authenticatingFacilityColumn']}" />">Authenticating Facility</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['consentDirectiveSummaryAuthorizations']}" />">${organizationName} Authorizations</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['consentDirectiveSummaryRevocations']}" />">${organizationName} Revocations</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['consentDirectiveSummaryRestrictions']}" />">${organizationName} Restrictions</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['consentDirectiveSummaryRestrictionRevocations']}" />">${organizationName} Restriction Revocations</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['consentDirectiveSummarySSAAuthorizations']}" />">SSA Authorizations</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['consentDirectiveSummarySSARevocations']}" />" data-tooltip-position="left" >SSA Revocations</span></th>
                </tr>
            </thead>
            <tfoot>
                <tr role="row">
                    <td role="gridcell" class="footer-bold-pad-left-8 text-left">Total:</td>
                    <td role="gridcell" class="footer-bold-pad-right-9 text-right"></td>
                    <td role="gridcell" class="footer-bold-pad-right-9 text-right"></td>
                    <td role="gridcell" class="footer-bold-pad-right-9 text-right"></td>
                    <td role="gridcell" class="footer-bold-pad-right-9 text-right"></td>
                    <td role="gridcell" class="footer-bold-pad-right-9 text-right"></td>
                    <td role="gridcell" class="footer-bold-pad-right-9 text-right"></td>
                </tr>
            </tfoot>
        </table>
        <div aria-live="polite" role="status" id="reportTable_info" class="dataTables_info hidden">Shows consent directive summary data</div><%-- because we don't have the "Showing x of x" turned on for this table, we need this here to support aria --%>
    </div>
    </div>
</f:mainTemplate>