<%--
    Document   : Opt-in/Opt-out Report
    Created By : David Vasquez / Robert Snelling
    Modified By: Asha Amritraj
--%>
<%@page import="gov.va.nvap.web.user.UserHelper"%>
<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp" %>

<%
    String userName = UserHelper.getUserName(request);
%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
    "http://www.w3.org/TR/html4/loose.dtd">

<html lang="en">
        <head>
        <title>Veterans Authorization & Preferences Patient Search Results</title>
        <%@include file="metaCommon.jsp" %>
        </head>
<body>
<jsp:include page="header.jsp">
    <jsp:param name="userName" value="<%=userName%>" />
</jsp:include>
<table border="0" cellpadding="0" cellspacing="0" width="100%" summary="table is used for layout purposes" id="main-content-table">
	<tbody>
    	<tr>
			<jsp:include page="leftMenu.jsp">
                <jsp:param name="userName" value="<%=userName%>" />
            </jsp:include>
            <td id="content-va">
                <a name="content-area"></a>
                <!-- START: SITE NAME BAR -->
                <p class="title-bar"><!-- START: SITE NAME -->Patient Search Results<!-- END: SITE NAME --></p>
                <cpp:errors />
                <!-- END: SITE NAME BAR -->
                <table border="0" cellpadding="0" cellspacing="0" width="100%" summary="table is used for layout purposes">
                    <tbody>
                        <tr>
                            <td id="content-main">
                              <table SUMMARY="This table is for formatting purposes only.">
                              <tbody>
                               <c:choose>
	                               <c:when test="${!empty patients}">
	                                <tr>
	                                  <td class="content-page-content-title" width="100%"><font class="content-page-title-font">The search for patient returned multiple results. Please select a patient from the results.</font></td>
	                                </tr>
	                                </c:when>
	                                <c:otherwise>
	                                <tr>
	                                  <td class="content-page-content-title" width="100%"><font class="content-page-title-font">The search for patient returned no results.</font></td>
	                                </tr>
	                                </c:otherwise>
                               </c:choose>

                                <tr>
                                    <td>
                                        <!-- START: PAGE TITLE AREA -->
                                        <!-- END: PAGE TITLE AREA -->
                                        <div class="form-container">
                                            <c:choose>
                                                <c:when test="${!empty patients}">
                                                    <form action="OptInOptOutReportPatientSearchResults.do_sec" method="POST"
                                                        onsubmit="return doSubmit(this)">
                                                        <fieldset>
                                                            <legend>Patient Search Results</legend>
                                                            <table class="ver-minimalist">
                                                                <thead>
                                                                    <tr>
                                                                        <th scope="col">Select Patient</th>
                                                                        <th scope="col">Last Name</th>
                                                                        <th scope="col">First Name</th>
                                                                        <th scope="col">Middle Name</th>
                                                                        <th scope="col">SSN</th>
                                                                        <th scope="col">Date of Birth</th>
                                                                        <th scope="col">Gender</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <c:choose>
                                                                        <c:when test="${i.index % 2 == 0}">
                                                                            <c:set var="className" value="even" />
                                                                        </c:when>
                                                                        <c:otherwise>
                                                                            <c:set var="className" value="odd" />
                                                                        </c:otherwise>
                                                                    </c:choose>
                                                                    <c:forEach var="r" items="${patients}" varStatus="i">
                                                                        <tr class="<c:out value="${className}"/>">
                                                                            <td><input alt="Choose to select patient" name="icn" value="<c:out value="${r.icn}"/>" type="radio" />
                                                                            </td>
                                                                            <td><c:out value="${r.lastName}"/></td>
                                                                            <td><c:out value="${r.firstName}"/></td>
                                                                            <td><c:out value="${r.middleInitial}"/></td>
                                                                            <td><c:out value="${r.ssnMasked}"/></td>
                                                                            <td><fmt:formatDate pattern="MM/dd/yyyy" value="${r.dob}" />
                                                                            </td>
                                                                            <td><c:out value="${r.gender}"/></td>
                                                                        </tr>
                                                                    </c:forEach>
                                                                </tbody>
                                                            </table>
                                                        </fieldset>
                                                        <div class="buttonrow">
                                                            <input name="select" alt=" Submit" class="button" type="submit"
                                                                value="View Details" />
                                                        </div>
                                                    </form>
                                                </c:when>
                                                <c:otherwise>
                                                    <p>No patients were found.</p>
                                                </c:otherwise>
                                            </c:choose>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                            </table>
                            <!-- START: PAGE CONTENT -->
                            <!-- THE BODY CONTENT END -->
                            </td>
                        </tr>
                    </tbody>
                </table>
                <!-- START: PAGE FOOTER -->
                <%@include file="footer.jsp" %>
                <!-- END: PAGE FOOTER -->
                <!-- END: PAGE CONTENT -->
            </td>
        </tr>
    </tbody>
</table>
</body>
</html>