<%--
    Document   : Opt-in/Opt-out Report
    Created By : David Vasquez / Robert Snelling
    Modified By: Asha Amritraj, Stephen Miller, Darren Henderson
--%>
<%@page import="gov.va.nvap.svc.facility.data.Facility"%>
<%@page import="java.util.HashMap"%>
<%@page trimDirectiveWhitespaces="true" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp" %>
<%@taglib tagdir="/WEB-INF/tags/date" prefix="date" %>
<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>

<%
    HashMap tips = (HashMap) session.getAttribute("descriptors");
    String facilityFilterTooltip = (String) tips.get("authenticatingFacilityField");
    Facility defaultUserFacility = (Facility) session.getAttribute("defaultUserFacility");
    String defaultUserFacilityName = defaultUserFacility == null ? "" : defaultUserFacility.getFacilityName();
    String defaultUserFacilityStation = defaultUserFacility == null ? "" : defaultUserFacility.getFacilityStation();
    pageContext.setAttribute("facilityFilterTooltip", facilityFilterTooltip);
    pageContext.setAttribute("defaultUserFacility", defaultUserFacility);
    pageContext.setAttribute("defaultUserFacilityName", defaultUserFacilityName);
    pageContext.setAttribute("defaultUserFacilityStation", defaultUserFacilityStation);
%>

<f:mainTemplate headerText="Consent Directive Report">
    <script language="JavaScript">
        //Used by 'view' button in exchange final table column
        function documentView(documentUniqueID){
            $('#documentUniqueId').val(documentUniqueID);
            document.getElementById('documentViewForm').submit();
        }

        $(document).ready(function () {
            $("#startDate").datepicker({
                maxDate: 0,
                dateFormat: 'mm/dd/yy',
                onClose: function (selectedDate) {
                    $("#endDate").datepicker("option", "minDate", selectedDate);
                }
            });

            $("#endDate").datepicker({
                maxDate: 0,
                dateFormat: 'mm/dd/yy',
                onClose: function (selectedDate) {
                    $("#startDate").datepicker("option", "maxDate", selectedDate);
                }
            });

            $('#ssn').focus();

            $('#consentType').on('change', function (e) {
                if ($(this).val().toLowerCase().indexOf('revocations') > -1) {
                    $('#inactivationReasonDiv').show();
                } else {
                    $('#inactivationReasonDiv').hide();
                    $('#inactivationReason').val('');
                }
            });

            setProcessingForDataTable('reportTable');

            reportTable = $('#reportTable').DataTable({
                deferLoading: 0,
                destroy: true,
                ajax:{
                    url: constructUrl('doSearch')
                },
                dom: 'liptipr',
                serverSide: true,
                processing: true,
                searching: false,
                language: {
                    emptyTable: "No records found",
                    loadingRecords: ""
                },
                lengthMenu: [ 10, 25, 50, 100, 250, 500 ],
                columnDefs: [
                    {orderable: false, targets: [12]},
                    {
                        targets: 0,
                        data: null,
                        render: function(data,type,full,meta){
                            return '<a href="#/" onclick="linkToPatient(\''+data[13]+'\', \''+data[1]+'\', \''+data[2]+'\');">'+data[0]+'</a>';
                        }
                    },
                    {
                        targets: 12,
                        data: null,
                        render: function(data,type,full,meta){
                            //Not all rows have attachments so display nothing if thats the case
                            if(data[14] && "true" === data[14]){
                                return '<a href="#/" onclick="documentView(\''+data[12]+'\');">view</a>';
                            } else {
                                return "";
                            }
                        }
                    },
                    {className: "vap-col-min-80 dt-head-center", targets: [0,7]},
                    {className: "vap-col-min-100 dt-head-center", targets: 6},
                    {className: "vap-col-min-130 dt-head-center", targets: [3,9]},
                    {className: "vap-col-min-150 dt-head-center", targets: 11},
                    {className: "dt-head-center", targets: [1,2,4,5,8,10,12]}
                ],
                pageLength: 25,
                scrollX:true,
                initComplete: function(){
                    // Enable THEAD scroll bars
                    $('.dataTables_scrollHead').css('overflow', 'auto');

                    // Sync THEAD scrolling with TBODY
                    $('.dataTables_scrollHead').on('scroll', function () {
                        $('.dataTables_scrollBody').scrollLeft($(this).scrollLeft());
                    });
                },
                order: [[3, "desc"]]
             });

            // DataTable overrides
            $.fn.dataTable.ext.errMode = 'none';

            reportTable.on('draw', function () {
                addAriaToDataTable('reportTable', reportTable);
            });

            $('#searchButton').on('click', function () {
                var startDate = $('#startDate').val();
                var endDate = $('#endDate').val();

                var errorMessage = validateStartAndEndDate(startDate, endDate);

                if (errorMessage != '')
                {
                    //we have an error so show the error, and then don't send the ajax request
                    $('#errorMessage').html(errorMessage);
                    $('#errorMessage').show();

                    return false;
                } else {
                    //no error, let's make the call to populate the report
                    $('#results').show();
                    reportTable.ajax.url(constructUrl('doSearch')).load();
                }
            });

            $('#startDate,#endDate').on('change', function () {
                //if either date changes, hide the error message if its not already hidden
                $('#errorMessage').hide();
            });

            $('#results').hide();
        });

        constructUrl = function(methodName){
            var url = 'OptInOptOutReport.do_sec?' + methodName +'=true' +
                    '&ssn=' + $('#ssn').val() +
                    '&lastName=' + $('#lastName').val() +
                    '&firstName=' + $('#firstName').val() +
                    '&userId=' + $('#enteredBy').val() +
                    '&startDate=' + $('#startDate').val() +
                    '&endDate=' + $('#endDate').val() +
                    '&patientTypes=' + $('#patientTypes').val() +
                    '&consentType=' + $('#consentType').val() +
                    '&stationNumbers=' + facilitiesDialog.getSelectedStationNumbers() +
                    '&inactivationReason=' + $('#inactivationReason').val() +
                    '&consentTypeName=' + $('#consentTypeName').val()+
                    '&includeUnknownVisn=' + facilitiesDialog.getIncludeUnknownVisn() +
                    '&sortBy=' + $('#reportTable').dataTable().fnSettings().aaSorting[0][0] +
                    '&sortOrder=' + $('#reportTable').dataTable().fnSettings().aaSorting[0][1] +
                    '&enteredBy=' + $('#enteredBy').val();

            if (methodName === 'exportToCsv' || methodName === 'exportToExcel') {
                url = url + '&totalRows=' + reportTable.page.info().recordsTotal;
            }
            return url;
        };
    </script>

    <div class="well">
        Fill in the fields below to narrow your search. All dates will be included if Start Date and End Date are left blank.
    </div>

    <cpp:errors />

    <div class="form-container">
        <form name="optInOptOutReportForm" action="OptInOptOutReport.do_sec" method="POST" onsubmit="return doSubmit(this)">
            <fieldset>
                <input type="hidden" id="consentTypeName" name="consentTypeName">
                <legend>Search Details</legend>
                <div id="errorMessage" class="bg-warning pad-15" style="display: none;"></div>
                <div class="pad-top-10">
                    <label for="ssn">SSN <i><span style="font-weight:normal;">(#########)</span></i></label>
                    <input title="Enter SSN. Enter numbers only no hyphens" id="ssn" name="ssn" type="text" maxlength="9" size="9" data-tooltip="<c:out value="${descriptors['ssnField']}" />"/> <i><span style="font-weight:normal;"> (Enter numbers only, no hyphens.)</span></i> &nbsp;
                </div>
                <div>
                    <label for="lastName">Last Name</label>
                    <input title="Enter Last Name" id="lastName" name="lastName" type="text" maxlength="255" size="30" data-tooltip="<c:out value="${descriptors['lastNameField']}" />"/>
                </div>
                <div>
                    <label for="firstName">First Name</label>
                    <input title="Enter First Name" id="firstName" name="firstName" type="text" maxlength="255" size="30" data-tooltip="<c:out value="${descriptors['firstNameField']}" />"/>
                </div>
                <div class="width-450" id="dateTip" data-tooltip="<c:out value="${descriptors['startDateEndDateField']}"/>">
                    <div>
                        <label for="startDate">Start Date</label>
                        <date:date id="startDate" name="startDate" value="${startDateDefault}"/> <i>mm/dd/yyyy</i>
                    </div>
                    <div>
                        <label for="endDate">End Date</label>
                        <date:date id="endDate" name="endDate" value="${endDateDefault}"/> <i>mm/dd/yyyy</i>
                    </div>
                </div>
                <jsp:include page="reporting/common/facilitiesFilter.jsp">
                    <jsp:param name="defaultUserFacility" value="${defaultUserFacility}" />
                    <jsp:param name="defaultUserFacilityName" value="${defaultUserFacilityName}" />
                    <jsp:param name="defaultUserFacilityStation" value="${defaultUserFacilityStation}" />
                    <jsp:param name="facilityFilterTooltip" value="${facilityFilterTooltip}" />
                </jsp:include>
                <div>
                    <label for="consentType">Consent Type <span style="display:none;">"Query based on consent type from the dropdown list"</span></label>
                    <select id="consentType" name="consentType"
                            document.getElementById('consentTypeName').value = this.options[this.selectedIndex].text;" data-tooltip="<c:out value="${descriptors['consentTypeField']}" />">
                        <option value="" selected>ALL</option>
                        <option value="allAuthorizations">ALL Authorizations</option>
                        <option value="allRevocations" >ALL Revocations</option>
                        <option value="NwHINAuthorizations" ><c:out value="${organizationName}"/> Authorizations</option>
                        <option value="SSAAuthorizations" >SSA Authorizations</option>
                        <option value="NwHINRevocations" ><c:out value="${organizationName}"/> Revocations</option>
                        <option value="SSARevocations" >SSA Revocations</option>
                        <option value="NwHINRestrictions" ><c:out value="${organizationName}"/> Restrictions</option>
                        <option value="NwHINRestrictionRevocations" ><c:out value="${organizationName}"/> Restriction Revocations</option>
                    </select>
                </div>
                <div id="inactivationReasonDiv" style="display: none;">
                    <label for="inactivationReason">Inactivation Reason<span style="display:none;">"Query based on Authorization or Revocation from the dropdown list"</span></label>
                    <select id="inactivationReason" name="inactivationReason">
                        <option value="" selected>ALL</option>
                        <option value="New Authorization">New Authorization</option>
                        <option value="Patient Deceased" >Patient Deceased</option>
                        <option value="Entered in Error" >Entered in Error</option>
                        <option value="Authorization Expired" >Authorization Expired</option>
                        <option value="Revoked" >Revoked</option>
                    </select>
                </div>
                <div>
                    <label for="enteredBy">Entered By<span style="display:none;">"Partial or full ID of the user that entered or submitted the consent"</span></label>
                    <input title="Entered By" id="enteredBy" name="enteredBy" type="text" maxlength="255" size="30" data-tooltip="<c:out value="${descriptors['enteredByField']}" />"/>
                </div>
                <div>
                    <label for="patientTypes">Patient Types<span style="display:none;">"Choose whether you would like to filter by real patients only, test patients only, or both."</span></label>
                    <select id="patientTypes" name="patientTypes" data-tooltip="<c:out value="${descriptors['patientTypesField']}" />">
                        <option value="3">ALL</option>
                        <option value="1" selected>Real Patients</option>
                        <option value="2">Test Patients</option>
                    </select>
                </div>
            </fieldset>
        </form>
        <div>
            <input name="search" title="Search" class="button" type="submit" value="Search" id="searchButton"/>
        </div>
    </div>
    <div id="results">
    <div align="right" class="pad-top-5">
        <input id="excelButton" name="excelButton" class="button" type="submit" value="Export To Excel" />
        &nbsp;&nbsp;
        <input id="csvButton" name="csvButton" class="button" type="submit" value="Export To CSV" />
    </div>
    <div id="divReportContent">
        <%@include file="patientLinkForm.jsp"%>
        <form action="OptInOptOutReport.do_sec" method="POST" target="_blank" onsubmit="return doSubmit(this)" id="documentViewForm">
            <input type="hidden" name="view" value="true">
            <input type="hidden" name="documentUniqueId" value="" id="documentUniqueId">
        </form>
        <table id="reportTable" class="display" width="100%" cellspacing="0" role="presentation">
            <thead>
                <tr role="row">
                    <th role="columnheader"><span id="ssnHeader" data-tooltip="<c:out value="${descriptors['ssnColumn']}" />">SSN</span></th>
                    <th role="columnheader"><span id="lastNameHeader" data-tooltip="<c:out value="${descriptors['lastNameColumn']}" />">Patient Last Name</span></th>
                    <th role="columnheader"><span id="firstNameHeader" data-tooltip="<c:out value="${descriptors['firstNameColumn']}" />">Patient First Name</span></th>
                    <th role="columnheader"><span id="timeOfEventHeader" data-tooltip="<c:out value="${descriptors['eventOccurredColumn']}" />">Time of Event (CT)</span></th>
                    <th role="columnheader"><span id="patientSignatureHeader" data-tooltip="<c:out value="${descriptors['consentDirectiveDetailedReportPatientSignatureDateColumn']}" />">Patient Signature/<br />Patient Deceased Date</span></th>
                    <th role="columnheader"><span id="pouHeader" data-tooltip="<c:out value="${descriptors['purposeOfUseColumn']}" />">Purpose of Use</span></th>
                    <th role="columnheader"><span id="consentTypeHeader" data-tooltip="<c:out value="${descriptors['consentTypeSansAllColumn']}" />">Consent Type</span></th>
                    <th role="columnheader"><span id="inactivationReasonHeader" data-tooltip="<c:out value="${descriptors['consentDirectiveDetailedReportInactivationReasonColumn']}" />">Inactivation Reason</span></th>
                    <th role="columnheader"><span id="enteredByHeader" data-tooltip="<c:out value="${descriptors['enteredByManualOrSystemColumn']}" />">Entered By</span></th>
                    <th role="columnheader"><span id="facilityHeader" data-tooltip="<c:out value="${descriptors['consentDirectiveDetailedReportAuthenticatingFacilityColumn']}" />">Authenticating Facility</span></th>
                    <th role="columnheader"><span id="facilityIdHeader" data-tooltip="<c:out value="${descriptors['consentDirectiveDetailedReportAuthenticatingFacilityStationIdColumn']}" />">Authenticating Facility Station ID</span></th>
                    <th role="columnheader"><span id="visnHeader" data-tooltip="<c:out value="${descriptors['visnForAuthenticatingFacilityColumn']}" />" data-tooltip-position="left">VISN</span></th>
                    <th role="columnheader"><span id="viewHeader" data-tooltip="<c:out value="${descriptors['genericViewColumn']}" />" data-tooltip-position="left">View</span></th>
                </tr>
            </thead>
        </table>
    </div>
    </div>
</f:mainTemplate>