<%--
    Document   : monthlyReceivedDocumentsReport
    Created on : Nov 4, 2016, 8:18:47 AM
    Author     : Johann Sonnenberg
--%>

<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>
<%@taglib tagdir="/WEB-INF/tags/date" prefix="d" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>

<f:mainTemplate headerText="Monthly Received Documents Report">
    <script language="JavaScript">
        $(document).ready(function () {
            //initial data table setup and call for the first recordset
            $.fn.dataTable.ext.errMode = 'none';

            setProcessingForDataTable('tblReport', 7);

            var reportTable = $('#tblReport').DataTable({
                deferLoading: 0,
                destroy: true,
                searching: false,
                processing: true,
                serverSide: true,
                paging: false,
                info: false,
                order: [[0, 'desc']],
                columnDefs: [
                    {className: "dt-head-center", targets: [0,1]},
                    {className: "dt-head-center dt-body-right", targets: [2]}
                ],
                "footerCallback": function ( row, data, start, end, display ) {
                    var api = this.api(), data;

                    // Update footer
                    $(api.column(2).footer() ).html(
                        api.column(2, {page:'current'}).data().sum()
                    );
                },
                ajax: {
                    url: "MonthlyReceivedDocumentsReport.do_sec?doSearch=true&startYearMonth=" + $('#startYearMonth').val(),
                    dataSrc: function(json){
                        $('.dataTables_empty').remove();
                        return json.data;
                    },
                    error: function(o){
                        handleErrorsInDataTable('tblReport', o, 3);
                    }
                },
                language: {
                    emptyTable: "No records found",
                    loadingRecords: ""
                },
                lengthMenu: [ 10, 25, 50, 100, 250, 500 ],
                pageLength: 25,
                scrollX:true,
                initComplete: function(){
                    // Enable THEAD scroll bars
                    $('.dataTables_scrollHead').css('overflow', 'auto');

                    // Sync THEAD scrolling with TBODY
                    $('.dataTables_scrollHead').on('scroll', function () {
                        $('.dataTables_scrollBody').scrollLeft($(this).scrollLeft());
                    });
                },
                dom: 'lipt<"pad-bottom-20">ipr'
            });

            reportTable.on('draw', function () {
                addAriaToDataTable('tblReport', reportTable);
            });

            $('#btnSearch').on('click', function () {
                $('#results').show();
                reportTable.ajax.url("MonthlyReceivedDocumentsReport.do_sec?doSearch=true&startYearMonth=" + $('#startYearMonth').val()).load();
            });

            $('#results').hide();
        });
    </script>

    <div class="form-container pad-bottom-20">
        <form name="searchForm">
            <fieldset>
                <legend>Search Details</legend>
                <div id="errorMessage" class="errors" style="display: none;"></div>
                <div>
                    <label for="startDate" class="width-120" title="Start Month and Year">Start Month/Year</label>
                    <d:monthAndYearDropdown fieldId="startYearMonth" fieldName="startYearMonth" enableMultiple="false" startYear="2010" startMonth="January" descriptor="${descriptors['monthlyReceivedDocumentReportStartMonthYearField']}" fieldTitle="Start Month and Year" />
                </div>
            </fieldset>
            <div>
                <input name="btnSearch" id="btnSearch" title="Search" class="button" type="button" value="Search" />
            </div>
        </form>
    </div>

    <div id="results">
    <div id="divReportContent">
        <table id="tblReport" class="display" width="100%" cellspacing="0" role="presentation">
            <thead>
                <tr role="row">
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['monthlyReceivedDocumentReportRemoteOrganizationColumn']}" />">Remote Organization</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['monthlyReceivedDocumentReportUserColumn']}" />">User</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['monthlyReceivedDocumentReportCountColumn']}" />" data-tooltip-position="left">Count</span></th>
                </tr>
            </thead>
            <tfoot>
                <tr role="row">
                    <%--Filled in by datatables, total--%>
                    <td role="gridcell" class="text-left footer-bold-pad-left-8">Total:</td>
                    <td role="gridcell"></td>
                    <td role="gridcell" class="text-right footer-bold-pad-right-9"></td>
                </tr>
            </tfoot>
        </table>
        <div aria-live="polite" role="status" id="tblReport_info" class="dataTables_info hidden">Shows monthly received documents summary data</div><%-- because we don't have the "Showing x of x" turned on for this table, we need this here to support aria --%>
    </div>
    </div>
</f:mainTemplate>