<%@ page pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>

<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta name="keywords" content="VAP, CPP, <c:out value="${organizationName}"/>, authorization, preferences, revocation">
<meta name="description" content="This is the Veterans Authorization & Preferences">

<style type="text/css" media="screen,print">
    /* MAIN VA STYLE SHEET */
    @import url(vhaoi_files/styles/va-styles.css);
    @import url(vhaoi_files/styles/va-user-styles.css);
    @import url(vhaoi_files/styles/top-menu-styles.css);
    @import url(styles/side-menu-styles.css);
    /* STYLE SHEET FOR SITE SPECIFIC NAVIGATION HYPERLINKS */
    @import url(vhaoi_files/styles/user-side-menu-styles.css);
</style>

<style type="text/css" media="screen">
    #prBanner {
        display: none;
    }

    table.dataTable tbody th, table.dataTable tbody td {
        padding: 4px 10px; /* overrides the initial 8px 10px for row height for all data tables as there is no setting within DataTables to do this any other way at this point */
    }
</style>

<%-- font awesome --%>
<link rel="stylesheet" href="resources/font-awesome/css/font-awesome.min.css?<c:out value="${systemVersion}" />">

<%-- jQuery library --%>
<!--[if lt IE 9]>
    <script src="js/jquery/jquery-1.12.1.min.js?<c:out value="${systemVersion}" />"></script>
<![endif]-->
<!--[if (gte IE 9) | (!IE)]><!-->
    <script src="js/jquery/jquery-2.2.0.min.js?<c:out value="${systemVersion}" />"></script>
<!--<![endif]-->
<link rel="stylesheet" type="text/css" href="js/jquery-ui/jquery-ui.min.css?<c:out value="${systemVersion}" />"/>
<script type="text/javascript" src="js/jquery-ui/jquery-ui.min.js?<c:out value="${systemVersion}" />"></script>

<%-- moment.js library for date handling --%>
<script type="text/javascript" src="js/moment.js?<c:out value="${systemVersion}" />"></script>

<%-- qTip --%>
<link type="text/css" rel="stylesheet" href="js/qTip/jquery.qtip.min.css?<c:out value="${systemVersion}" />" />
<script type="text/javascript" src="js/qTip/jquery.qtip.min.js?<c:out value="${systemVersion}" />"></script>

<!-- NAVIGATION FLYOUTS AND DROPDOWNS -->
<script language="javascript" type="text/javascript" src="vhaoi_files/scripts/dropdown.js?<c:out value="${systemVersion}" />"></script>
<script language="javascript" type="text/javascript" src="vhaoi_files/scripts/dropdown-top.js?<c:out value="${systemVersion}" />"></script>

<%-- global JavaScript variables --%>
<script language="JavaScript">
    var scheduledExportThreshold = ${scheduledExportMin};
    
    var reportTable;
    
    var validateSSNsBeforeExport = false; //setting this to false as most exports do not require this. this variable is set on the pages that need it changed to true
</script>

<%-- VAP JavaScript files --%>
<script type="text/javascript" src="js/errors.js?<c:out value="${systemVersion}" />"></script>
<script type="text/javascript" src="js/common.js?<c:out value="${systemVersion}" />"></script>

<%-- DataTables --%>
<link rel="stylesheet" type="text/css" href="js/DataTables/datatables.min.css?<c:out value="${systemVersion}" />"/>
<script type="text/javascript" src="js/DataTables/datatables.min.js?<c:out value="${systemVersion}" />"></script>

<%-- DataTables plugins --%>
<script type="text/javascript" src="js/DataTables/plugins/sum().js?<c:out value="${systemVersion}" />"></script>

<%-- VAP specific styles (and overrides) --%>
<link rel="stylesheet" media="print" href="css/vap_print.css?<c:out value="${systemVersion}" />" />

<link rel="stylesheet" type="text/css" href="css/vap.css?<c:out value="${systemVersion}" />" />

<%-- fav icon --%>
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon" />