<%--
    Document   : Inbound Document Report
    Created By : David Vasquez / Robert Snelling
    Modified By: Asha Amritraj
--%>

<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@taglib tagdir="/WEB-INF/tags/date" prefix="date" %>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp" %>

<f:mainTemplate headerText="Received ${organizationName} Documents Report">
    <script language="JavaScript">
        $(document).ready(function () {
            $("#startDate").datepicker({
                maxDate: 0,
                dateFormat: 'mm/dd/yy',
                onClose: function (selectedDate) {
                    $("#endDate").datepicker("option", "minDate", selectedDate);
                }
            });

            $("#endDate").datepicker({
                maxDate: 0,
                dateFormat: 'mm/dd/yy',
                onClose: function (selectedDate) {
                    $("#startDate").datepicker("option", "maxDate", selectedDate);
                }
            });

            setFocus(inboundDocumentReportForm.ssn);

            setProcessingForDataTable('reportTable');

            reportTable = $('#reportTable').DataTable({
                deferLoading: 0,
                destroy: true,
                ajax: {
                    url: constructUrl("doSearch"),
                    dataSrc: function(json){
                        $('.dataTables_empty').remove();
                        return json.data;
                    },
                    error: function(o){
                        handleErrorsInDataTable('reportTable', o, 12);
                    }
                },
                info: true,
                language: {
                    emptyTable: "No records found",
                    loadingRecords: ""
                },
                paging: true,
                dom: 'liptipr',
                lengthMenu: [ 10, 25, 50, 100, 250, 500 ],
                pageLength: 25,
                processing: true,
                searching: false,
                serverSide: true,
                order: [[3, "desc"]],
                scrollX:true,
                initComplete: function(){
                    // Enable THEAD scroll bars
                    $('.dataTables_scrollHead').css('overflow', 'auto');

                    // Sync THEAD scrolling with TBODY
                    $('.dataTables_scrollHead').on('scroll', function () {
                        $('.dataTables_scrollBody').scrollLeft($(this).scrollLeft());
                    });
                },
                columnDefs: [
                    {orderable: false, targets: [10, 11]},
                    {
                        targets: 11,
                        data: null,
                        render: function(data,type,full,meta){
                            return '<a href="#/" onclick="documentView(\''+data[12]+'\', \''+data[13]+'\');">view</a>';
                        }
                    },
                    {
                        targets: 0,
                        data: null,
                        render: function(data,type,full,meta){
                            return '<a href="#/" onclick="linkToPatient(\''+data[11]+'\', \''+data[1]+'\', \''+data[2]+'\');">'+data[0]+'</a>';
                        }
                    },
                    {className: "vap-col-min-80 dt-head-center", targets: 0},
                    {className: "vap-col-min-130 dt-head-center", targets: [3,5,7]},
                    {className: "vap-col-min-200 dt-head-center", targets: 4},
                    {className: "dt-head-center", targets: [1,2,6,8,9,10,11]}
                ]
            });

            // DataTable overrides
            $.fn.dataTable.ext.errMode = 'none';

            reportTable.on('draw', function () {
                addAriaToDataTable('reportTable', reportTable);
            });

            $('#searchButton').on('click', function () {
                var startDate = $('#startDate').val();
                var endDate = $('#endDate').val();

                var errorMessage = validateStartAndEndDate(startDate, endDate);

                if (errorMessage != '')
                {
                    //we have an error so show the error, and then don't send the ajax request
                    $('#errorMessage').html(errorMessage);
                    $('#errorMessage').show();

                    return false;
                } else {
                    //no error, let's make the call to populate the report
                    $('#results').show();
                    reportTable.ajax.url(constructUrl('doSearch')).load();
                }
            });

            $('#startDate,#endDate').on('change', function () {
                //if either date changes, hide the error message if its not already hidden
                $('#errorMessage').hide();
            });

            $('#results').hide();
        });

        constructUrl = function(methodName){
            var url = 'InboundDocumentReport.do_sec' +
                    '?' + methodName + '=true' +
                    '&ssn=' + $('#ssn').val() +
                    '&firstName=' + $('#firstName').val() +
                    '&lastName=' + $('#lastName').val() +
                    '&purposeOfUse=' + $('#purposeOfUse').val() +
                    '&recordsPerPage=' + $('#recordsPerPage').val() +
                    '&currentPage=' + $('#currentPage').val() +
                    '&startDate=' + $('#startDate').val() +
                    '&endDate=' + $('#endDate').val() +
                    '&userId=' + $('#userId').val() +
                    '&organization=' + $('#organization').val() +
                    '&organizationName=' + $('#organizationName').val() +
                    '&remoteOrganization=' + $('#remoteOrganization').val() +
                    '&facility=' + $('#facility').val() +
                    '&facilityName=' + $('#facilityName').val() +
                    '&patientTypes=' + $('#patientTypes').val() +
                    '&sortBy=' + $('#reportTable').dataTable().fnSettings().aaSorting[0][0] +
                    '&sortOrder=' + $('#reportTable').dataTable().fnSettings().aaSorting[0][1];

            if (methodName === 'exportToCsv' || methodName === 'exportToExcel') {
                url = url + '&totalRows=' + reportTable.page.info().recordsTotal;
            }
            return url;
        };

        //Used by 'view' button in exchange final table column
        function documentView(patientIcn, documentUniqueID){
                $('#patient-ICN').val(patientIcn);
                $('#document-View-Unique-Id').val(documentUniqueID);
                document.getElementById('documentViewForm').submit();
        }
    </script>

    <div class="well">
        Fill in the fields below to narrow your search. All dates will be included if Start Date and End Date are left blank.
    </div>

    <cpp:errors />

    <div class="form-container">
        <form name="inboundDocumentReportForm" action="InboundDocumentReport.do_sec" method="POST" onsubmit="return doSubmit(this)">
            <fieldset>
                <input type="hidden" name="organizationName" id="organizationName">
                <input type="hidden" name="facilityName" id="facilityName">
                <legend>Search Details</legend>
                <div id="errorMessage" class="bg-warning pad-15" style="display: none;"></div>
                <div class="pad-top-10">
                    <label for="ssn">SSN <i><span style="font-weight:normal;">(#########)</span></i></label>
                    <input title="Enter SSN. Enter numbers only no hyphens" data-tooltip="<c:out value="${descriptors['ssnField']}" />" id="ssn" name="ssn" type="text" maxlength="9" size="9" /> <i><span style="font-weight:normal;"> (Enter numbers only, no hyphens.)</span></i> &nbsp;
                </div>
                <div>
                    <label for="lastName">Last Name</label>
                    <input title="Enter Last Name" data-tooltip="<c:out value="${descriptors['lastNameField']}" />" id="lastName" name="lastName" type="text" maxlength="255" size="30" />
                </div>
                <div>
                    <label for="firstName">First Name</label>
                    <input title="Enter First Name" data-tooltip="<c:out value="${descriptors['firstNameField']}" />" id="firstName" name="firstName" type="text" maxlength="255" size="30" />
                </div>
                <div>
                    <label for="userId" >User ID</label>
                    <input title="Enter User ID" data-tooltip="<c:out value="${descriptors['genericUserId']}" />" id="userId" name="userId" type="text" maxlength="255" size="30" />
                </div>
                <div class="width-450" id="dateTip" data-tooltip="<c:out value="${descriptors['startDateEndDateField']}" />">
                    <div>
                        <label for="startDate">Start Date</label>
                        <date:date id="startDate" name="startDate" value="${startDateDefault}"/> <i>mm/dd/yyyy</i>
                    </div>
                    <div>
                        <label for="endDate">End Date</label>
                        <date:date id="endDate" name="endDate" value="${endDateDefault}"/> <i>mm/dd/yyyy</i>
                    </div>
                </div>
                <c:if test="${pouFlag eq true}">
                    <div>
                        <label title="Purpose of Use" for="purposeOfUse">Purpose of Use</label>
                        <select id="purposeOfUse" name="purposeOfUse" data-tooltip="<c:out value="${descriptors['purposeOfUseField']}" />">
                            <option value="">ALL</option>
                            <c:forEach var="pou" items="${pous}">
                                <option value="<c:out value="${pou.pouValue}" />"><c:out value="${pou.pouValue}" /></option>
                            </c:forEach>
                        </select>
                    </div>
                </c:if>
                <div>
                    <label title="Query based on Patient Preferred Facility from the dropdown list" for="facility">Patient Preferred Facility</label>
                    <select id="facility" name="facility" onchange="document.getElementById('facilityName').value = this.options[this.selectedIndex].text;" data-tooltip="<c:out value="${descriptors['patientPreferredFacilityFilter']}" />">
                        <option value="" >ALL</option>
                        <c:forEach var="f" items="${facilities}">
                            <option value="<c:out value="${f.facilityStation}" />"
                                    <c:choose>
                                        <c:when test="${f.facilityStation eq defaultUserFacility.facilityStation}">
                                            selected
                                        </c:when>
                                    </c:choose>>
                                <c:choose>
                                    <c:when test="${f.facilityName != ''}">
                                        <c:out value="${f.facilityName}" />
                                    </c:when>
                                    <c:otherwise>
                                        <c:out value="${fn:split(f.facilityDns, '.')[0]}" />
                                    </c:otherwise>
                                </c:choose>
                                (<c:out value="${f.facilityStation}" />)
                            </option>
                        </c:forEach>
                    </select>
                </div>
                <div>
                    <label title="Query based on <c:out value="${organizationName}" /> Organization from the dropdown list" for="remoteOrganization">eHealth Exchange Organization</label>
                    <select id="remoteOrganization" name="remoteOrganization" onchange="document.getElementById('organizationName').value = this.options[this.selectedIndex].text;" data-tooltip="<c:out value="${descriptors['receivedEHealthExchangeDocumentsReportOrganizationField']}" />">
                        <option value="">ALL</option>
                        <c:forEach var="r" items="${activeOrgs}">
                            <option value="%<c:out value="${r.orgOid}" />"><c:out value="${r.orgName}" /></option>
                        </c:forEach>
                        <c:forEach var="r" items="${inactiveOrgs}">
                            <option value="%<c:out value="${r.orgOid}" />">[INACTIVE] <c:out value="${r.orgName}" /></option>
                        </c:forEach>
                    </select>
                </div>
                <div>
                    <label for="patientTypes">Patient Types<span style="display:none;">"Choose whether you would like to filter by real patients only, test patients only, or both."</span></label>
                    <select id="patientTypes" name="patientTypes" data-tooltip="<c:out value="${descriptors['patientTypesField']}" />">
                        <option value="3">ALL</option>
                        <option value="1" selected>Real Patients</option>
                        <option value="2">Test Patients</option>
                    </select>
                </div>
            </fieldset>
        </form>
        <div>
            <input name="search" title="Search" class="button" type="submit" value="Search" id="searchButton" />
        </div>
    </div>
    <div id="results">
    <div align="right" class="pad-top-5">
        <input id="excelButton" name="excelButton" class="button pad-right-5" type="submit" value="Export To Excel" />
        <input id="csvButton" name="csvButton" class="button" type="submit" value="Export To CSV" />
    </div>
    <%@include file="patientLinkForm.jsp"%>
    <div id="divReportContent">
        <form action="InboundDocumentReport.do_sec" method="POST" target="_blank" onsubmit="return doSubmit(this)" id="documentViewForm">
            <input type="hidden" name="view" value="true">
            <input type="hidden" name="patientICN"  value="" id="patient-ICN">
            <input type="hidden" name="documentUniqueId" value="" id="document-View-Unique-Id">
        </form>
        <table id="reportTable" class="display" width="100%" cellspacing="0" role="presentation">
            <thead>
                <tr role="row">
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['ssnColumn']}"/>" id="ssnHeader">SSN</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['lastNameColumn']}"/>" id="lastNameHeader">Patient Last Name</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['firstNameColumn']}"/>" id="firstNameHeader">Patient First Name</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['eventOccurredColumn']}"/>" id="dateReceivedHeader">Date Received (CT)</span></th>
                    <th role="columnheader"><span id="documentTitleHeader" data-tooltip="<c:out value="${descriptors['documentTitleColumn']}" />">Document Title</span></th>
                    <th role="columnheader"><span id="facilityHeader" data-tooltip="<c:out value="${descriptors['receivedEHealthExchangeDocumentsReportFacilityWithDefaultField']}" />">Patient Preferred Facility</span></th>
                    <th role="columnheader"><span id="facilityNumberHeader" data-tooltip="<c:out value="${descriptors['patientPreferredFacilityStationIdColumn']}" />">Patient Preferred Facility Station ID</span></th>
                    <th role="columnheader"><span id="organizationHeader" data-tooltip="<c:out value="${descriptors['receivedEHealthExchangeDocumentsReportOrganizationColumn']}" />"><c:out value="${organizationName}" /> Organization</span></th>
                    <th role="columnheader"><span id="userIdHeader" data-tooltip="<c:out value="${descriptors['receivedEHealthExchangeDocumentsReportUserIdColumn']}" />">User ID</span></th>
                    <th role="columnheader"><span id="pouHeader" data-tooltip="<c:out value="${descriptors['purposeOfUseColumn']}" />">Purpose of Use</span></th>
                    <th role="columnheader"><span id="userRoleHeader" data-tooltip="<c:out value="${descriptors['receivedEHealthExchangeDocumentsReportUserRoleColumn']}" />" data-tooltip-position="left">User Role</span></th>
                    <th role="columnheader"><span id="viewHeader" data-tooltip="<c:out value="${descriptors['genericViewColumn']}" />" data-tooltip-position="left">View</span></th>
                </tr>
            </thead>
        </table>
    </div>
    </div>
</f:mainTemplate>