<%--
    Document   : Expiring Consent Report
    Created By : John DeNinno
--%>

<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp"%>
<%@taglib tagdir="/WEB-INF/tags/paginator" prefix="pg" %>

<%
    session.setAttribute("optInReport", "false");
%>

<f:mainTemplate headerText="Expiring Consent Report">
    <script type="text/javascript">
        function onSubmit() {
            var message = 'Note: It may take up to a second per record to generate patient notification letters. Do you wish to continue?';
            return (confirm(message));
        }

        $(document).ready(function () {

        });
    </script>

    <%@include file="patientLinkForm.jsp"%>

    <div>
        <c:if test="${(!empty expiringConsentReportResults)}">
            <c:choose>
                <c:when test="${(consentTypeName == 'NwHIN Authorization') && (!empty stationNumbers) && (!fn:contains(stationNumbers, ','))}">
                    <form style="display: inline-block;">
                        <input type="hidden" name="totalRows" id="totalRows" value="<c:out value="${totalRows}" />">
                        <input type="hidden" name="expiredNotificationLettersMaxTime" id="expiredNotificationLettersMaxTime" value="<c:out value="${expiredNotificationLettersMaxTime}" />">
                        <input type="hidden" name="expiredNotificationPerLetterTime" id="expiredNotificationPerLetterTime" value="<c:out value="${expiredNotificationPerLetterTime}" />">
                        <input name="download" title="Download Patient Notification Letters" class="button" type="submit" onclick="return onSubmit()" value="Download Patient Notification Letters" />
                    </form>
                </c:when>
                <c:otherwise>
                    <input class="button" type="submit" disabled value="Download Patient Notification Letters"
                           <c:choose>
                               <c:when test="${consentTypeName != 'NwHIN Authorization'}">
                                   title="Please filter by only eHealth Exchange Authorizations to enable PDF generation"
                               </c:when>
                               <c:otherwise>
                                   title="Please filter by exactly one facility to enable PDF generation"
                               </c:otherwise>
                           </c:choose>
                           />
                </c:otherwise>
            </c:choose>
        </c:if>
        <form style="display: inline-block;">
            <input name="exportToExcel" title="Export to Excel" class="button" type="submit" value="Export to Excel" onclick="scheduledExportAlert();"/>
            <input name="exportToCsv" title="Export to CSV" class="button" type="submit" value="Export to CSV" onclick="exportAlert();"/>
        </form>
    </div>

    <div>
        <table class="ver-minimalist">
            <tbody>
                <tr class="dateFilters">
                    <td class="datePadding">Start Date</td>
                    <td>
                        <c:choose>
                            <c:when test="${!empty startDate}">
                                <fmt:formatDate pattern="MM/dd/yyyy" value="${startDate}" />
                            </c:when>
                            <c:otherwise>
                                N/A
                            </c:otherwise>
                        </c:choose>
                    </td>
                    <td class="datePadding">End Date</td>
                    <td>
                        <c:choose>
                            <c:when test="${!empty endDate}">
                                <fmt:formatDate pattern="MM/dd/yyyy" value="${endDate}" />
                            </c:when>
                            <c:otherwise>
                                N/A
                            </c:otherwise>
                        </c:choose>
                    </td>
                    <td class="datePadding">VA Facility</td>
                    <td>
                        <c:choose>
                            <c:when test="${!empty facilityName}">
                                <c:out value="${facilityName}" />
                            </c:when>
                            <c:otherwise>
                                N/A
                            </c:otherwise>
                        </c:choose>
                    </td>
                    <td class="datePadding">Entered By</td>
                    <td>
                        <c:choose>
                            <c:when test="${!empty userId}">
                                <c:out value="${userId}" />
                            </c:when>
                            <c:otherwise>
                                N/A
                            </c:otherwise>
                        </c:choose>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    <div>
        <c:choose>
            <c:when test="${!empty expiringConsentReportResults}">
                <br/>
                 <pg:paginator paginator="${paginator}" uri="ExpiringConsentReportResults.do_sec" results="${expiringConsentReportResults}" />
                <table width="100%">
                    <thead>
                        <tr class="hor-minimalist-c">
                            <th scope="col"><span data-tooltip="<c:out value="${descriptors['ssnColumn']}"/>" id="ssnHeader">SSN</span></th>
                            <th scope="col"><span data-tooltip="<c:out value="${descriptors['lastNameColumn']}"/>" id="lastNameHeader">Patient Last Name</span></th>
                            <th scope="col"><span data-tooltip="<c:out value="${descriptors['firstNameColumn']}"/>" id="firstNameHeader">Patient First Name</span></th>
                            <th scope="col"><span data-tooltip="<c:out value="${descriptors['middleNameColumn']}"/>" id="middleNameHeader">Patient Middle Name</span></th>
                            <th scope="col"><span data-tooltip="<c:out value="${descriptors['optInDateColumn']}"/>" id="optInDateHeader">Opt In Date</span></th>
                            <th scope="col"><span data-tooltip="<c:out value="${descriptors['expirationDateColumn']}"/>" id="expDateHeader">Expiration Date</span></th>
                            <th scope="col"><span data-tooltip="<c:out value="${descriptors['expiringConsentDetailedReportConsentTypeColumn']}"/>" id="consentTypeHeader">Consent Type</span></th>
                            <th scope="col"><span data-tooltip="<c:out value="${descriptors['enteredByManualOrSystemColumn']}"/>" id="enteredByHeader">Entered By</span></th>
                            <th scope="col"><span data-tooltip="<c:out value="${descriptors['authenticatingFacilityColumn']}"/>" data-tooltip-position="left" id="authFacilityHeader">Authenticating Facility</span></th>
                        </tr>
                        <tr class="hor-minimalist-c">
                            <td><a href="ExpiringConsentReportResults.do_sec?inboundSortValue=patientSSN&inboundSortDirection=ASC"><br><img alt="sort this column in ascending order" src="res/sort-ascending.jpg" border="0"/></a><a> - </a><a href="ExpiringConsentReportResults.do_sec?inboundSortValue=patientSSN&inboundSortDirection=DESC"><img alt="sort this column in descending order" src="res/sort-descending.jpg" border="0"/></a></td>
                            <td><a href="ExpiringConsentReportResults.do_sec?inboundSortValue=patientLastName&inboundSortDirection=ASC"><br><img alt="sort this column in ascending order" src="res/sort-ascending.jpg" border="0"/></a><a> - </a><a href="ExpiringConsentReportResults.do_sec?inboundSortValue=patientLastName&inboundSortDirection=DESC"><img alt="sort this column in descending order" src="res/sort-descending.jpg" border="0"/></a></td>
                            <td><a href="ExpiringConsentReportResults.do_sec?inboundSortValue=patientGivenName&inboundSortDirection=ASC"><br><img alt="sort this column in ascending order" src="res/sort-ascending.jpg" border="0"/></a><a> - </a><a href="ExpiringConsentReportResults.do_sec?inboundSortValue=patientGivenName&inboundSortDirection=DESC"><img alt="sort this column in descending order" src="res/sort-descending.jpg" border="0"/></a></td>
                            <td><a href="ExpiringConsentReportResults.do_sec?inboundSortValue=patientMiddleName&inboundSortDirection=ASC"><br><img alt="sort this column in ascending order" src="res/sort-ascending.jpg" border="0"/></a><a> - </a><a href="ExpiringConsentReportResults.do_sec?inboundSortValue=patientMiddleName&inboundSortDirection=DESC"><img alt="sort this column in descending order" src="res/sort-descending.jpg" border="0"/></a></td>
                            <td><a href="ExpiringConsentReportResults.do_sec?inboundSortValue=optInDate&inboundSortDirection=ASC"><br><img alt="sort this column in ascending order" src="res/sort-ascending.jpg" border="0"/></a><a> - </a><a href="ExpiringConsentReportResults.do_sec?inboundSortValue=optInDate&inboundSortDirection=DESC"><img alt="sort this column in descending order" src="res/sort-descending.jpg" border="0"/></a></td>
                            <td><a href="ExpiringConsentReportResults.do_sec?inboundSortValue=expirationDate&inboundSortDirection=ASC"><br><img alt="sort this column in ascending order" src="res/sort-ascending.jpg" border="0"/></a><a> - </a><a href="ExpiringConsentReportResults.do_sec?inboundSortValue=expirationDate&inboundSortDirection=DESC"><img alt="sort this column in descending order" src="res/sort-descending.jpg" border="0"/></a></td>
                            <td><a href="ExpiringConsentReportResults.do_sec?inboundSortValue=optInConsentTypeId&inboundSortDirection=ASC"><br><img alt="sort this column in ascending order" src="res/sort-ascending.jpg" border="0"/></a><a> - </a><a href="ExpiringConsentReportResults.do_sec?inboundSortValue=optInConsentTypeId&inboundSortDirection=DESC"><img alt="sort this column in descending order" src="res/sort-descending.jpg" border="0"/></a></td>
                            <td><a href="ExpiringConsentReportResults.do_sec?inboundSortValue=userId&inboundSortDirection=ASC"><br><img alt="sort this column in ascending order" src="res/sort-ascending.jpg" border="0"/></a><a> - </a><a href="ExpiringConsentReportResults.do_sec?inboundSortValue=userId&inboundSortDirection=DESC"><img alt="sort this column in descending order" src="res/sort-descending.jpg" border="0"/></a></td>
                            <td><a href="ExpiringConsentReportResults.do_sec?inboundSortValue=facilityName&inboundSortDirection=ASC"><br><img alt="sort this column in ascending order" src="res/sort-ascending.jpg" border="0"/></a><a> - </a><a href="ExpiringConsentReportResults.do_sec?inboundSortValue=facilityName&inboundSortDirection=DESC"><img alt="sort this column in descending order" src="res/sort-descending.jpg" border="0"/></a></td>
                        </tr>
                    </thead>
                    <tbody>
                        <pg:forEach var="r" items="${expiringConsentReportResults}" varStatus="i" paginator="${paginator}">
                            <tr class="hor-minimalist-b">
                                <td nowrap><cpp:patientLink ssn="${r.ssn}" firstName="${r.firstName}" lastName="${r.lastName}" ssnMasked="${r.ssnMasked}"/></td>
                                <td><c:out value="${r.lastName}"/></td>
                                <td><c:out value="${r.firstName}"/></td>
                                <td><c:out value="${r.middleName}"/></td>
                                <td><fmt:formatDate pattern="MM/dd/yyyy" value="${r.optInDate}"/></td>
                                <td><fmt:formatDate pattern="MM/dd/yyyy" value="${r.expirationDate}"/></td>
                                <td><c:out value="${r.consentTypeName}"/></td>
                                <td><c:out value="${r.userId}"/></td>
                                <td><c:out value="${r.facilityName}"/></td>
                            </tr>
                        </pg:forEach>
                    </tbody>
                </table>
                <pg:paginator paginator="${paginator}" uri="ExpiringConsentReportResults.do_sec" results="${expiringConsentReportResults}" />
            </c:when>
            <c:otherwise>
                No records were found.
            </c:otherwise>
        </c:choose>
    </div>
</f:mainTemplate>