<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>
<%@page import="java.util.HashMap"%>
<%@page import="gov.va.nvap.svc.facility.data.Facility"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp"%>

<%
    HashMap tips = (HashMap) session.getAttribute("descriptors");
    String facilityFilterTooltip = (String) tips.get("authenticatingFacilityField");
    Facility defaultUserFacility = (Facility) session.getAttribute("defaultUserFacility");
    String defaultUserFacilityName = defaultUserFacility == null ? "" : defaultUserFacility.getFacilityName();
    String defaultUserFacilityStation = defaultUserFacility == null ? "" : defaultUserFacility.getFacilityStation();
    pageContext.setAttribute("facilityFilterTooltip", facilityFilterTooltip);
    pageContext.setAttribute("defaultUserFacility", defaultUserFacility);
    pageContext.setAttribute("defaultUserFacilityName", defaultUserFacilityName);
    pageContext.setAttribute("defaultUserFacilityStation", defaultUserFacilityStation);
%>

<f:mainTemplate headerText="Expiring Consent Report">
    <script type="text/javascript">
        $(document).ready(function () {
            $("#startDate").datepicker({
                dateFormat: 'mm/dd/yy',
                onClose: function (selectedDate) {
                    $("#endDate").datepicker("option", "minDate", selectedDate);
                }
            });

            $("#endDate").datepicker({
                dateFormat: 'mm/dd/yy',
                onClose: function (selectedDate) {
                    $("#startDate").datepicker("option", "maxDate", selectedDate);
                }
            });

            setProcessingForDataTable('reportTable');

            reportTable = $('#reportTable').DataTable({
                deferLoading: 0,
                destroy: true,
                ajax:{
                    url: constructUrl('doSearch'),
                    dataSrc: function(json){
                        $('#totalRows').val(json.rowTotalForLetters);
                        $('#expiredNotificationLettersMaxTime').val(json.expiredNotificationLettersMaxTime);
                        $('#expiredNotificationPerLetterTime').val(json.expiredNotificationPerLetterTime);

                        //change button availability based on displayed table
                        if($('#consentTypeName').val() === 'NwHIN Authorization' && $.trim(json.oneStationRequested) === 'true' && json.rowTotalForLetters > 0){
                            $('#downloadButton').prop('disabled', false);
                            $('#downloadButton').prop('title', 'Download Patient Notification Letters');
                        } else if ($('#consentTypeName').val() !== 'NwHIN Authorization' && $.trim(json.oneStationRequested) === 'true'){
                            $('#downloadButton').prop('disabled', true);
                            $('#downloadButton').prop('title', 'Please filter by only eHealth Exchange Authorizations to enable PDF generation');
                        } else {
                            $('#downloadButton').prop('disabled', true);
                            $('#downloadButton').prop('title', 'Please filter by exactly one facility to enable PDF generation');
                        }
                        return json.data;
                    }
                },
                dom: 'liptipr',
                serverSide: true,
                processing: true,
                searching: false,
                language: {
                    emptyTable: "No records found",
                    loadingRecords: ""
                },
                lengthMenu: [ 10, 25, 50, 100, 250, 500 ],
                columnDefs: [
                    {
                        targets: 0,
                        data: null,
                        render: function(data,type,full,meta){
                            return '<a href="#/" onclick="linkToPatient(\''+data[9]+'\', \''+data[1]+'\', \''+data[2]+'\');">'+data[0]+'</a>';
                        }
                    },
                    {className: "vap-col-min-80 dt-head-center", targets: 0},
                    {className: "vap-col-min-200 dt-head-center", targets: [6,8]},
                    {className: "dt-head-center", targets: [1,2,3,4,5,7]}
                ],
                pageLength: 25,
                scrollX:true,
                initComplete: function(){
                    // Enable THEAD scroll bars
                    $('.dataTables_scrollHead').css('overflow', 'auto');

                    // Sync THEAD scrolling with TBODY
                    $('.dataTables_scrollHead').on('scroll', function () {
                        $('.dataTables_scrollBody').scrollLeft($(this).scrollLeft());
                    });
                },
                order: [[4, "desc"]]
             });

            // DataTable overrides
            $.fn.dataTable.ext.errMode = 'none';

            reportTable.on('draw', function () {
                addAriaToDataTable('reportTable', reportTable);
            });

            function downloadLetters(){
                var url = constructUrl("download");
                //add extra parameters
                url = url + '&totalRows=' + $('#totalRows').val() +
                        '&expiredNotificationLettersMaxTime=' + $('#expiredNotificationLettersMaxTime').val() +
                        '&expiredNotificationPerLetterTime=' + $('#expiredNotificationPerLetterTime').val();
                return url;
            }

            $('#downloadButton').on('click', function () {
                $('#download-patient-letters-alert').dialog({
                    resizable: false,
                    height: "auto",
                    width: 400,
                    modal: true,
                    open: function(event, ui) {
                        $('#download-patient-letters-alert').show();
                    },
                    buttons: {
                        "Download": function() {
                            window.location.replace(downloadLetters());

                            $(this).dialog("close");
                        },
                        Cancel: function() {
                            $(this).dialog("close");
                        }
                    }
                });
            });

            $('#searchButton').on('click', function () {
                var startDate = $('#startDate').val();
                var endDate = $('#endDate').val();

                var errorMessage = validateStartAndEndDate(startDate, endDate, true);

                if (errorMessage != '')
                {
                    //we have an error so show the error, and then don't send the ajax request
                    $('#errorMessage').html(errorMessage);
                    $('#errorMessage').show();

                    return false;
                } else {
                    //no error, let's make the call to populate the report
                    $('#results').show();
                    reportTable.ajax.url(constructUrl('doSearch')).load();
                }
            });

            $('#startDate,#endDate').on('change', function () {
                //if either date changes, hide the error message if its not already hidden
                $('#errorMessage').hide();
            });

            $('#results').hide();
        });

        function checkDayRange(form) {
            // Does not check for invalid month or day number
            var startDate = document.getElementsByName("startDate")[0].value;
            if (!/^\d{2}\/\d{2}\/\d{4}/.test(startDate)) {
                window.alert("Start Date must be in format: mm/dd/yyyy");
                return false;
            }

            var endDate = document.getElementsByName("endDate")[0].value;
            if (!/^\d{2}\/\d{2}\/\d{4}/.test(endDate)) {
                window.alert("End Date must be in format: mm/dd/yyyy");
                return false;
            } else {
                return doSubmit(form);
            }
        };

        constructUrl = function(methodName){
            var url = 'ExpiringConsentReport.do_sec?' + methodName +'=true' +
                '&startDate=' + $('#startDate').val() +
                '&endDate=' + $('#endDate').val() +
                '&enteredBy=' + $('#enteredBy').val() +
                '&patientTypes=' + $('#patientTypes').val() +
                '&stationNumbers=' + facilitiesDialog.getSelectedStationNumbers() +
                '&consentTypeName=' + $('#consentTypeName').val() +
                '&includeUnknownVisn=' + facilitiesDialog.getIncludeUnknownVisn() +
                '&sortBy=' + $('#reportTable').dataTable().fnSettings().aaSorting[0][0] +
                '&sortOrder=' + $('#reportTable').dataTable().fnSettings().aaSorting[0][1];

            if (methodName === 'exportToCsv' || methodName === 'exportToExcel') {
                url = url + '&totalRows=' + reportTable.page.info().recordsTotal;
            }

            return url;
        };
    </script>

    <div class="well">
        Fill in the fields below to narrow your search.
    </div>

    <cpp:errors />

    <div class="form-container">
        <form name="expiringConsentReportForm" action="ExpiringConsentReport.do_sec" method="POST" onsubmit="return checkDayRange(this)">
            <fieldset>
                <legend>Search Details</legend>
                <div id="errorMessage" class="bg-warning pad-15" style="display: none;"></div>
                <div class="width-450 pad-top-10" id="dateTip" data-tooltip="<c:out value="${descriptors['startDateEndDateField']}"/>">
                    <div>
                        <label for="startDate">Start Date</label>
                        <input title="Enter the start date for the expiring consent report." id="startDate" name="startDate" type="text" maxlength="10" value="<c:out value="${startDateString}" />" size="10"> <i>mm/dd/yyyy</i>
                    </div>
                    <div>
                        <label for="endDate">End Date</label>
                        <input title="Enter the end date for the expiring consent report." id="endDate" name="endDate" type="text" maxlength="10" value="<c:out value="${endDateString}" />" size="10"> <i>mm/dd/yyyy</i>
                    </div>
                </div>
                <jsp:include page="reporting/common/facilitiesFilter.jsp">
                    <jsp:param name="defaultUserFacility" value="${defaultUserFacility}" />
                    <jsp:param name="defaultUserFacilityName" value="${defaultUserFacilityName}" />
                    <jsp:param name="defaultUserFacilityStation" value="${defaultUserFacilityStation}" />
                    <jsp:param name="facilityFilterTooltip" value="${facilityFilterTooltip}" />
                </jsp:include>
                <div>
                    <label for="consentTypeName">Consent Type<span style="display:none;">"Query based on consent type from the dropdown list"</span></label>
                    <select id="consentTypeName" name="consentTypeName" data-tooltip="<c:out value="${descriptors['consentTypeField']}"/>">
                        <option value="" selected>ALL Authorizations</option>
                        <option value="NwHIN Authorization"><c:out value="${organizationName}" /> Authorizations</option>
                        <option value="SSA Authorization">SSA Authorizations</option>
                    </select>
                </div>
                <div>
                    <label for="enteredBy">Entered By<span style="display:none;">"Query based on whom entered information from the dropdown list"</span></label>
                    <select id="enteredBy" name="enteredBy" data-tooltip="<c:out value="${descriptors['enteredByField']}"/>">
                        <option value="" selected>ALL</option>
                        <option value="eBenefits">eBenefits</option>
                        <option value="employee">Employee</option>
                    </select>
                </div>
                <div>
                    <label for="patientTypes">Patient Types<span style="display:none;">"Choose whether you would like to filter by real patients only, test patients only, or both."</span></label>
                    <select id="patientTypes" name="patientTypes" data-tooltip="<c:out value="${descriptors['patientTypesField']}"/>">
                        <option value="3">ALL</option>
                        <option value="1" selected>Real Patients</option>
                        <option value="2">Test Patients</option>
                    </select>
                </div>
            </fieldset>
        </form>
        <div>
            <input name="search" title="Search" class="button" type="submit" value="Search" id="searchButton" />
        </div>
    </div>
    <div id="results">
    <div align="right" class="pad-top-5">
        <form style="display: inline-block;">
            <input type="hidden" name="totalRows" id="totalRows" value="">
            <input type="hidden" name="expiredNotificationLettersMaxTime" id="expiredNotificationLettersMaxTime" value="">
            <input type="hidden" name="expiredNotificationPerLetterTime" id="expiredNotificationPerLetterTime" value="">
        </form>
        <input id="downloadButton" name="download" title="Download Patient Notification Letters" class="button" type="button" value="Download Patient Notification Letters" disabled />
        <input id="excelButton" name="excelButton" class="button" type="submit" value="Export To Excel" />
        <input id="csvButton" name="csvButton" class="button" type="submit" value="Export To CSV" />
    </div>
    <div id="divReportContent">
        <%@include file="patientLinkForm.jsp"%>
        <table id="reportTable" class="display" width="100%" cellspacing="0" role="presentation">
            <thead>
                <tr role="row">
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['ssnColumn']}"/>" id="ssnHeader">SSN</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['lastNameColumn']}"/>" id="lastNameHeader">Patient Last Name</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['firstNameColumn']}"/>" id="firstNameHeader">Patient First Name</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['middleNameColumn']}"/>" id="middleNameHeader">Patient Middle Name</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['optInDateColumn']}"/>" id="optInDateHeader">Opt In Date</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['expirationDateColumn']}"/>" id="expDateHeader">Expiration Date</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['expiringConsentDetailedReportConsentTypeColumn']}"/>" id="consentTypeHeader">Consent Type</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['enteredByManualOrSystemColumn']}"/>" id="enteredByHeader">Entered By</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['authenticatingFacilityColumn']}"/>" data-tooltip-position="left" id="authFacilityHeader">Authenticating Facility</span></th>
                </tr>
            </thead>
        </table>
    </div>
    </div>
    <!-- modal div for download letter alert -->
    <div id="download-patient-letters-alert" style="display: none;" title="Download Notice">
        <p>
            It may take up to a second per record to generate patient notification letters. Do you wish to continue?
        </p>
    </div>
</f:mainTemplate>