<%--
    Document   : Expiring Consent Notification
    Created By : Nusrath Mohammed
--%>

<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp"%>
<%@taglib tagdir="/WEB-INF/tags/date" prefix="date"%>
<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>

<f:mainTemplate headerText="Expiring Consent Notification">
    <script language="JavaScript">
        $(document).ready(function () {
            setFocus(expiringConsentNotificationForm.fileName);
        });

        function checkDayRange(form) {
            var dayRange = document.getElementsByName("maxDaysToExpiration")[0].value;
            if (isNaN(dayRange) || dayRange < 1 || dayRange > 999) {
                window.alert("Day range must be a number from 1 to 999.");
                return false;
            } else {
                document.getElementsByName("maxDaysToExpiration")[0].value = parseInt(dayRange);
                return doSubmit(form);
            }
        };
    </script>

    <cpp:errors />

    <div class="form-container">
        <form name="expiringConsentNotificationForm" action="ExpiringConsentNotification.do_sec" method="POST" onsubmit="return checkDayRange(this)">
            <fieldset>
                <legend>Expiring Consent Notification Details</legend>

                <div>
                    <label for="frequency">Frequency<span style="display:none;">"Choose the frequency you want to run from the dropdown list"</span></label>
                    <select data-tooltip="<c:out value="${descriptors['expiringConsentNotificationFrequencyField']}"/>" id="frequency" name="frequency">
                        <c:choose>
                            <c:when test="${configurationValues.frequency == 'DAILY'}" >
                                <option value="DAILY" selected>Daily</option>
                            </c:when>
                            <c:otherwise>
                                <option value="DAILY">Daily</option>
                            </c:otherwise>
                        </c:choose>
                        <c:choose>
                            <c:when test="${configurationValues.frequency == 'WEEKLY'}" >
                                <option value="WEEKLY" selected>Weekly</option>
                            </c:when>
                            <c:otherwise>
                                <option value="WEEKLY">Weekly</option>
                            </c:otherwise>
                        </c:choose>
                        <c:choose>
                            <c:when test="${configurationValues.frequency == 'MONTHLY'}" >
                                <option value="MONTHLY" selected>Monthly</option>
                            </c:when>
                            <c:otherwise>
                                <option value="MONTHLY">Monthly</option>
                            </c:otherwise>
                        </c:choose>
                    </select>
                </div>
                <div>
                    <label for="maxDaysToExpiration">Days Until Expiration<span style="display:none;">"Choose the number of days you want to select from the dropdown list"</span></label>
                    <input title="Enter range in days." data-tooltip="<c:out value="${descriptors['expiringConsentNotificationDaysUntilExpirationField']}"/>"
                        id="maxDaysToExpiration" name="maxDaysToExpiration" type="text"
                        maxlength="3" value="<c:out value="${configurationValues.window}"/>" size="3"/>
                </div>
                <div>
                    <label for="distributionList">Distribution List<br />
                        <span style="font-weight: normal;">(one email address per line)</span></label>
                    <textarea data-tooltip="<c:out value="${descriptors['expiringConsentNotificationDistributionListField']}"/>" id="distributionList" name="distributionList" rows="8" cols="55" ><c:out value="${configurationValues.emailAddresses}"/></textarea>
                </div>
            </fieldset>
            <div>
                <input name="save" id="save" title="Save" class="button" type="submit" value="Save" />
            </div>
        </form>
    </div>
</f:mainTemplate>