<%--
    Document   : general error page
    Created on : 07/01/2016
    Author     : Johann Sonnenberg
--%>

<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>

<f:mainTemplate headerText="An Error Occurred">
    <%-- clipboard.js --%>
    <script type="text/javascript" src="js/clipboard.min.js"></script>

    <script language="JavaScript">
        $(document).ready(function () {
            $('#copiedAlert').hide();

            $('#copyButton').on('click', function () {
                clipboard.copy($('#stackTrace').val());
                $('#copiedAlert').show();
                $('#copiedAlert').delay(500).fadeIn('normal', function () {
                    $(this).delay(2500).fadeOut();

                });
            });
        });
    </script>

    <div class="well">
        <p>We are sorry, but an error has occurred while processing your request. <strong><c:out value="${customMessage}"/></strong></p>
        <p>Please retry your request again. If you continue to get this message, call the Austin Information Technology Center Help Desk (1-888-596-4357).</p>
        <p>The following steps can be taken to resolve this:</p>
        <ol>
            <li>Hit the Back button and try your request again.</li>
            <li>If you are searching, try to search using different parameters.</li>
            <li>If you are searching, try to search with no parameters.</li>
        </ol>
        <c:if test="${not empty fullStackTrace}">
            <div style="width: 705px;">
                <div>
                    <textarea style="width: 700px;" rows="10" id="stackTrace"><c:out value="${fullStackTrace}"/></textarea>
                </div>
                <div class="text-right pad-top-10">
                    <span id="copiedAlert" class="bg-success">Copied!</span>
                    <button id="copyButton">Copy to Clipboard</button>
                </div>
            </div>
        </c:if>
    </div>
</f:mainTemplate>