<%--
The JSP Page handles errors on the forms. Calls the form validator.
Author: Asha Amritraj
 --%>
<%@page import="gov.va.nvap.web.user.UserHelper"%>
<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@page isErrorPage="true"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
    "http://www.w3.org/TR/html4/loose.dtd">

<html lang="en">
    <head>
        <title>Veterans Authorization & Preferences Error Page</title>
        <%
            String userName = UserHelper.getUserName(request);
        %>
        <%@include file="metaCommon.jsp" %>
    </head>
<body>
    <jsp:include page="header.jsp">
        <jsp:param name="userName" value="<%=userName%>"/>
    </jsp:include>
	<table border="0" cellpadding="0" cellspacing="0" width="100%"
		summary="table is used for layout purposes" id="main-content-table">
		<tbody>
			<tr>
                <jsp:include page="leftMenu.jsp">
                    <jsp:param name="userName" value="<%=userName%>" />
                </jsp:include>
				<td id="content-va"><a name="content-area"></a> <!-- START: SITE NAME BAR -->
					<p class="title-bar">
						<!-- START: SITE NAME -->
						An Error Occured
						<!-- END: SITE NAME -->
					</p> <!-- END: SITE NAME BAR -->
					<table border="0" cellpadding="0" cellspacing="0" width="100%"
						summary="table is used for layout purposes">
						<tbody>
							<tr>
								<td id="content-main">
									<!-- START: PAGE TITLE AREA --> <!-- END: PAGE TITLE AREA --> <!-- START: PAGE CONTENT -->
									<div class="errors">
										<p>
											<em> An unexpected error occurred during the processing
												of your request.<br /> Please contact the system
												administrator for assistance.</em><br/>
										</p>
											<c:set var="newline" value="<%= \"\n\" %>" />
											<c:choose>
											<c:when test="${!empty exception.cause and !empty exception.cause.message}">
											<br/>
												<p>
													<img alt="Error/Exception" src="res/error_icon.gif" />&nbsp;${fn:replace(exception.cause.message, newline, "<br />")}
												</p>
											</c:when>
											<c:otherwise>
												<c:if test="${!empty exception.message}">
												<br/>
												<p>
													<img alt="Error/Exception" src="res/error_icon.gif" />&nbsp;${fn:replace(exception.message, newline, "<br />")}
												</p>
												</c:if>
											</c:otherwise>
											</c:choose>
											<cpp:userInRole role="VAPApplicationTester">
												<c:if test="${!empty exceptionTrace}">
													<br/>
													<p>
														<b>Detailed Trace:</b>
														<br/>
														<c:out value="${exceptionTrace}"/>
													</p>
												</c:if>
											</cpp:userInRole>
								</div> <!-- THE BODY CONTENT END --></td>
							</tr>
						</tbody>
					</table> <!-- START: PAGE FOOTER --> <%@include file="footer.jsp"%>
					<!-- END: PAGE FOOTER --> <!-- END: PAGE CONTENT --></td>
			</tr>
		</tbody>
	</table>
</body>
</html>