<%--
    Document   : editMailDatesForm
    Created on : May 17, 2016, 7:55:35 PM
    Author     : Johann Sonnenberg
--%>

<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp"%>
<%@taglib tagdir="/WEB-INF/tags/date" prefix="date"%>
<jsp:useBean id="now" class="java.util.Date" scope="page" />

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=windows-1252">
        <%@include file="metaCommon.jsp"%>
        <script>
            jQuery(document).ready(function () {

                jQuery(".useDate").datepicker({
                    dateFormat: 'mm/dd/yy'
                });

                jQuery("#updateMailNotifications").on('click', function (event) {
                    //hide the error message in case it was showing
                    jQuery('#errorMesssage').hide();

                    //loop over all the mailDates and check each one for being valid
                    jQuery('.useDate').each(function () {
                        if (jQuery(this).val().length > 0 && !isDate(jQuery(this).val())) {
                            jQuery('#errorMessage').html("You entered an invalid date: " + jQuery(this).val());
                            jQuery('#errorMessage').show();
                            event.preventDefault();
                            return false;
                        }
                    });

            <%-- Disallow duplicate dates --%>
                    var uniqueDates = {};
                    jQuery('.useDate').each(function () {
                        if (jQuery(this).val() !== "") {
                            var date = new Date(jQuery(this).val());
                            var date = (date.getMonth() + 1) + '/' + date.getDate() + '/' + date.getFullYear();
                            if (uniqueDates[date] === undefined) {
                                uniqueDates[date] = jQuery(this).val();
                            } else {
                                jQuery('#errorMessage').html('You have entered a duplicate date: ' + date);
                                jQuery('#errorMessage').show();
                                event.preventDefault();
                                return false;
                            }
                        }
                    });

                    return true;
                });

                jQuery("#mailDates").on('click', 'a.removeMailDate', function (event) {
                    //remove the div (and contents) around the date that was clicked to be removed
                    jQuery(this).closest('div').remove();

                    event.preventDefault();
                    return false;
                });

                jQuery("body").on('click', 'a.addAnotherMailDate', function (event) {
                    //get the number of inputs
                    var numDates = jQuery(".mailDateContainer").length;

                    //append
                    var rn = new Date().getTime();
                    jQuery('#mailDates').append('<div class="pad-bottom-10 mailDateContainer"> <label for="mailDate' + rn + '" class="no-width">Date</label> <input type="text" name="mailDate" id="mailDate' + rn + '" size="12" maxlength="10" class="useDate" value="" /> <a href="#" class="removeMailDate" aria-label="Remove date"><i class="fa fa-trash-o removeMailDate vap-required" aria-hidden="true" title="Remove date" alt="Remove date"></i></a></div>');

                    //give it a date picker
                    jQuery("#mailDate" + rn).datepicker({
                        dateFormat: 'mm/dd/yy'
                    });
                });

                jQuery("#showLog").on('click', function (event) {
                    if (jQuery('#showLog').text() == 'Show log') {
                        if (!jQuery('#delayedConsentId').val().length) {
                            var url = '&consentDirId=' + jQuery('#consentDirId').val();
                        } else {
                            var url = '&delayedConsentId=' + jQuery('#delayedConsentId').val();
                        }

                        jQuery.get("PatientDetails.do_sec?getLogEntries=true" + url, function (data) {
                            jQuery("#logResults").html(data);
                        });
                    }

                    jQuery('#logResults').toggle();
                    jQuery('#showLog').text(jQuery('#showLog').text() == 'Show log' ? 'Hide log' : 'Show log');
                    jQuery('#showLogArrow').toggleClass('fa-angle-up fa-angle-down');
                });

                jQuery('.cancelNoReload').on('click', function (event) {
                    shouldReload = false;
                });
            });
        </script>
        <title>Veterans Authorization & Preferences - Edit Mail Notification Dates</title>
    </head>
    <body>
        <div id="errorMessage" class="errors" style="display: none;"></div>
        <div class="form-container">
            <form name="mailDatesForm" id="mailDatesForm" action="PatientDetails.do_sec?editMailDates=true" method="POST" onsubmit="return doSubmit(this)">
                <input type="hidden" name="delayedConsentId" id="delayedConsentId" value="<c:out value="${delayedConsentId}"/>" />
                <input type="hidden" name="consentDirId" id="consentDirId" value="<c:out value="${consentDirId}"/>" />
                <div id="mailDates">
                    <c:forEach items="${mailNotifications}" var="md" varStatus="i">
                        <div class="pad-bottom-10 mailDateContainer">
                            <label for="mailDate${i.index + 1}" class="no-width">Date</label>
                            <input type="text" name="mailDate" id="mailDate${i.index + 1}" size="12" maxlength="10" class="useDate" value="<fmt:formatDate pattern="MM/dd/yyyy" value="${md.sentDate}" />" />
                            <a href="#" class="removeMailDate"><i class="fa fa-trash-o vap-required" aria-hidden="true" title="Remove date" alt="Remove date"></i></a>
                        </div>
                    </c:forEach>
                    <c:if test="${fn:length(mailNotifications) == 0}">
                        <div class="pad-bottom-10 mailDateContainer">
                            <label for="mailDate1" class="no-width">Date</label>
                            <input type="text" name="mailDate" id="mailDate1" size="12" maxlength="10" class="useDate" value="<fmt:formatDate pattern="MM/dd/yyyy" value="${now}" />" />
                            <a href="#" class="removeMailDate" aria-label="Remove date"><i class="fa fa-trash-o vap-required" aria-hidden="true" title="Remove date" alt="Remove date"></i></a>
                        </div>
                    </c:if>
                </div>
                <div id="divAddMailDate">
                    <a href="#" class="addAnotherMailDate">Add another</a>
                </div>
                <br />
                <div class="pad-bottom-10">
                    <label for="updateMailNotifications" style="display:none">Submit mail notification dates form</label>
                    <input id="updateMailNotifications" class="button" type="submit" value="OK" name="updateMailNotifications" alt="OK" />
                    <label for="cancelMailNotificationsChange" style="display:none">Cancel out of mail notification dates form</label>
                    <button id="cancelMailNotificationsChange" onclick="Modalbox.hide(); return false;" class="cancelNoReload" title="Cancel">Cancel</button>
                    <div class="pull-right">
                        <i class="fa fa-angle-down" aria-hidden="true" id="showLogArrow"></i>
                        <a href="#" id="showLog" class="vap-size-11">Show log</a>
                    </div>
                </div>
                <div id="logResults" style="display: none; overflow-y:scroll; overflow-x:hidden; height:100px; background-color: #f0f0f0; border: 1px #000 solid;"></div>
            </form>
        </div>
    </body>
</html>
