<%--
    Document   : View Document - When the user clicks on the View link from the GUI in reports
    Author     : Asha Amritraj
--%>

<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp"%>

<f:mainTemplate headerText="Document View">
    <link rel="stylesheet" type="text/css" href="css/xmlverbatim.css" />
    <link rel="stylesheet" type="text/css" href="css/cda.css" />
    <link rel="stylesheet" type="text/css" href="css/adapter.css" />
    <link rel="stylesheet" type="text/css" href="css/custom_cda.css" />

    <div>
        <cpp:userInRole role="VAPApplicationTester">
            <c:if test="${isXmlViewEnabled}">
                <c:url var="adapterStyleSheet" value="DocumentDisclosureReportResults.do_sec">
                    <c:param name="view" value="true" />
                    <c:param name="icn" value="${icn}" />
                    <c:param name="documentUniqueId" value="${documentUniqueId}" />
                </c:url>
                <c:url var="xmlToHtmlStyleSheet" value="DocumentDisclosureReportResults.do_sec">
                    <c:param name="view" value="true" />
                    <c:param name="icn" value="${icn}" />
                    <c:param name="documentUniqueId" value="${documentUniqueId}" />
                    <c:param name="styleSheetViewType" value="xml" />
                </c:url>
                <a title="View Document" href="<c:out value="${adapterStyleSheet}"/>">
                    <img alt="View Document" src="res/xsl.jpg" border="0" />
                </a>
                <a title="View XML" href="<c:out value="${xmlToHtmlStyleSheet}"/>">
                    <img alt="View XML" src="res/xmlicon.gif" border="0" />
                </a>
            </c:if>
        </cpp:userInRole>
        <a title="Print Document" href="javascript:window.print()" class="font-28">
            <i class="fa fa-print" aria-hidden="true"></i>
        </a>
    </div>
    <div>
        <!-- document content -->
        <c:out value="${updatedDocument}" escapeXml="false" />
    </div>
</f:mainTemplate>