<%--
    Document   : Document Disclosure Report
    Created By : David Vasquez / Robert Snelling
    Modified By: Asha Amritraj
--%>

<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp" %>
<%@taglib tagdir="/WEB-INF/tags/date" prefix="date" %>

<f:mainTemplate headerText="Accounting of Disclosures Report">
    <script language="JavaScript">
        $(document).ready(function () {
            $('#source').on('change', function () {
                handleSourceChange();
            });

            $("#startDate").datepicker({
                maxDate: 0,
                dateFormat: 'mm/dd/yy',
                onClose: function (selectedDate) {
                    $("#endDate").datepicker("option", "minDate", selectedDate);
                }
            });

            $("#endDate").datepicker({
                maxDate: 0,
                dateFormat: 'mm/dd/yy',
                onClose: function (selectedDate) {
                    $("#startDate").datepicker("option", "maxDate", selectedDate);
                }
            });

            //initial data table setup and call for the first recordset
            $.fn.dataTable.ext.errMode = 'none';

            setFocus(documentDisclosureReportForm.source);

            buildTable(true);

            function buildTable(loadingPage) {
                if (loadingPage) {
                    setProcessingForDataTable('exchangeDataTable');

                    reportTable = $('#exchangeDataTable').DataTable({
                        deferLoading: 0,
                        destroy: true,
                        ajax: {
                            url: constructUrl("doSearch"),
                            dataSrc: function(json){
                                $('.dataTables_empty').remove();
                                return json.data;
                            },
                            error: function(o){
                                handleErrorsInDataTable('exchangeDataTable', o, 12);
                            }
                        },
                        info: true,
                        language: {
                            emptyTable: "No records found",
                            loadingRecords: ""
                        },
                        dom: 'lipt<"pad-bottom-20">ipr',
                        lengthMenu: [ 10, 25, 50, 100, 250, 500 ],
                        pageLength: 25,
                        processing: true,
                        searching: false,
                        serverSide: true,
                        columnDefs: [
                            {orderable: false, targets: [10, 11]},
                            {
                                targets: 11,
                                data: null,
                                render: function(data,type,full,meta){
                                    return '<a href="#/" onclick="documentView(\''+data[11]+'\', \''+data[12]+'\');">view</a>';
                                }
                            },
                            {
                                targets: 0,
                                data: null,
                                render: function(data,type,full,meta){
                                    return '<a href="#/" onclick="linkToPatient(\''+data[13]+'\', \''+data[1]+'\', \''+data[2]+'\');">'+data[0]+'</a>';
                                }
                            },
                            {className: 'vap-col-min-80 dt-head-center', targets: 0},
                            {className: 'vap-col-min-130 dt-head-center', targets: [3,4]},
                            {className: 'vap-col-min-150 dt-head-center', targets: [5,7]},
                            {className: "dt-head-center", targets: [1,2,6,8,9,10,11]}
                        ],
                        scrollX:true,
                        initComplete: function(){
                            // Enable THEAD scroll bars
                            $('.dataTables_scrollHead').css('overflow', 'auto');

                            // Sync THEAD scrolling with TBODY
                            $('.dataTables_scrollHead').on('scroll', function () {
                                $('.dataTables_scrollBody').scrollLeft($(this).scrollLeft());
                            });
                        },
                        order: [[3, "desc"]]
                    });
                } else if ($('#source').val() === 'exchange') {
                    setProcessingForDataTable('exchangeDataTable');

                    reportTable = $('#exchangeDataTable').DataTable({
                        destroy: true,
                        ajax: {
                            url: constructUrl("doSearch"),
                            dataSrc: function(json){
                                $('.dataTables_empty').remove();
                                return json.data;
                            },
                            error: function(o){
                                handleErrorsInDataTable('exchangeDataTable', o, 12);
                            }
                        },
                        info: true,
                        language: {
                            emptyTable: "No records found",
                            loadingRecords: ""
                        },
                        dom: 'lipt<"pad-bottom-20">ipr',
                        lengthMenu: [ 10, 25, 50, 100, 250, 500 ],
                        pageLength: 25,
                        processing: true,
                        searching: false,
                        serverSide: true,
                        columnDefs: [
                            {orderable: false, targets: [10, 11]},
                            {
                                targets: 11,
                                data: null,
                                render: function(data,type,full,meta){
                                    return '<a href="#/" onclick="documentView(\''+data[11]+'\', \''+data[12]+'\');">view</a>';
                                }
                            },
                            {
                                targets: 0,
                                data: null,
                                render: function(data,type,full,meta){
                                    return '<a href="#/" onclick="linkToPatient(\''+data[13]+'\', \''+data[1]+'\', \''+data[2]+'\');">'+data[0]+'</a>';
                                }
                            },
                            {className: 'vap-col-min-80 dt-head-center', targets: 0},
                            {className: 'vap-col-min-130 dt-head-center', targets: [3,4]},
                            {className: 'vap-col-min-150 dt-head-center', targets: [5,7]},
                            {className: "dt-head-center", targets: [1,2,6,8,9,10,11]}
                        ],
                        scrollX:true,
                        initComplete: function(){
                            // Enable THEAD scroll bars
                            $('.dataTables_scrollHead').css('overflow', 'auto');

                            // Sync THEAD scrolling with TBODY
                            $('.dataTables_scrollHead').on('scroll', function () {
                                $('.dataTables_scrollBody').scrollLeft($(this).scrollLeft());
                            });
                        },
                        order: [[3, "desc"]]
                    });
                } else {
                    setProcessingForDataTable('directDataTable');

                    reportTable = $('#directDataTable').DataTable({
                        destroy: true,
                        ajax: {
                            url: constructUrl("doSearch"),
                            dataSrc: function(json){
                                $('.dataTables_empty').remove();
                                return json.data;
                            },
                            error: function(o){
                                handleErrorsInDataTable('directDataTable', o, 8);
                            }
                        },
                        info: false,
                        language: {
                            emptyTable: "No records found",
                            loadingRecords: ""
                        },
                        dom: 'lipt<"pad-bottom-20">lipr',
                        lengthMenu: [ 10, 25, 50, 100, 250, 500 ],
                        pageLength: 25,
                        processing: true,
                        searching: false,
                        serverSide: true,
                        columnDefs: [
                            {
                                targets: 0,
                                data: null,
                                render: function(data,type,full,meta){
                                    return '<a href="#/" onclick="linkToPatient(\''+data[8]+'\', \''+data[1]+'\', \''+data[2]+'\');">'+data[0]+'</a>';
                                }
                            },
                            {className: 'vap-col-min-80 dt-head-center', targets: 0},
                            {className: 'vap-col-min-150 dt-head-center', targets: [3,4,5]},
                            {className: "dt-head-center", targets: [1,2,6,7]}
                        ],
                        scrollX:true,
                        initComplete: function(){
                            // Enable THEAD scroll bars
                            $('.dataTables_scrollHead').css('overflow', 'auto');

                            // Sync THEAD scrolling with TBODY
                            $('.dataTables_scrollHead').on('scroll', function () {
                                $('.dataTables_scrollBody').scrollLeft($(this).scrollLeft());
                            });
                        },
                        order: [[3, "desc"]]
                    });
                }
            }

            // DataTable overrides
            reportTable.on('draw', function () {
                addAriaToDataTable('exchangeDataTable', reportTable);
                addAriaToDataTable('directDataTable', reportTable);
            });

            $('#searchButton').on('click', function () {
                var startDate = $('#startDate').val();
                var endDate = $('#endDate').val();

                var errorMessage = validateStartAndEndDate(startDate, endDate);

                if (errorMessage != '')
                {
                    //we have an error so show the error, and then don't send the ajax request
                    $('#errorMessage').html(errorMessage);
                    $('#errorMessage').show();

                    return false;
                } else {
                    //no error, let's make the call to populate the report
                    $('#results').show();
                    buildTable(false);
                }
            });

            $('#printReport').on('click', function () {
                window.print();
            });

            $('#startDate,#endDate').on('change', function () {
                //if either date changes, hide the error message if its not already hidden
                $('#errorMessage').hide();
            });

            handleSourceChange();
        });

        constructUrl = function(methodName){
            var url = 'DocumentDisclosureReport.do_sec' +
                    '?' + methodName + '=true' +
                    '&ssn=' + $('#ssn').val() +
                    '&firstName=' + $('#firstName').val() +
                    '&lastName=' + $('#lastName').val() +
                    '&purposeOfUse=' + $('#purposeOfUse').val() +
                    '&source=' + $('#source').val() +
                    '&startDate=' + $('#startDate').val() +
                    '&endDate=' + $('#endDate').val() +
                    '&organization=' + $('#organization').val() +
                    '&organizationName=' + $('#organizationName').val() +
                    '&facility=' + $('#facility').val() +
                    '&facilityName=' + $('#facilityName').val() +
                    '&patientTypes=' + $('#patientTypes').val();

            if($('#source').val() === 'exchange') {
                url = url + '&sortBy=' + $('#exchangeDataTable').dataTable().fnSettings().aaSorting[0][0] +
                '&sortOrder=' + $('#exchangeDataTable').dataTable().fnSettings().aaSorting[0][1];
            } else {
                url = url + '&sortBy=' + $('#directDataTable').dataTable().fnSettings().aaSorting[0][0] +
                '&sortOrder=' + $('#directDataTable').dataTable().fnSettings().aaSorting[0][1];
            }
            if (methodName === 'exportToCsv' || methodName === 'exportToExcel') {
                url = url + '&totalRows=' + reportTable.page.info().recordsTotal;
            }
            return url;
        };

        //Used by 'view' button in exchange final table column
        function documentView(documentICN, documentUniqueID){
            $('#document-View-ICN').val(documentICN);
            $('#document-View-Unique-Id').val(documentUniqueID);
            document.getElementById('documentViewForm').submit();
        }

        function handleSourceChange() {
            if ($('#source option:selected').val() === 'exchange') {
                $("#facilityDiv").show();
                $("#organizationDiv").show();
                $("#patientTypesDiv").show();
                $("#exchangeDataTable_wrapper").show();
                $("#exchangeDataTable").show();
                $("#directDataTable_wrapper").hide();
                $("#directDataTable").hide();
            } else {
                $("#facilityDiv").hide();
                $("#organizationDiv").hide();
                $("#patientTypesDiv").hide();
                $("#exchangeDataTable_wrapper").hide();
                $("#exchangeDataTable").hide();
                $("#directDataTable_wrapper").show();
                $("#directDataTable").show();
            }
            $('#results').hide();
        };
    </script>

    <div class="well">
        Fill in the fields below to narrow your search. All dates will be included if Start Date and End Date are left blank.
    </div>

    <cpp:errors />

    <div class="form-container">
        <form name="documentDisclosureReportForm" action="DocumentDisclosureReport.do_sec" method="POST" onsubmit="return doSubmit(this)">
            <fieldset>
                <input type="hidden" id="organizationName" name="organizationName">
                <input type="hidden" id="facilityName" name="facilityName">
                <legend>Search Details</legend>
                <div id="errorMessage" class="bg-warning pad-15" style="display: none;"></div>
                <div class="pad-top-10">
                    <label title="Select the disclosure source" for="source">Disclosure Source</label>
                    <select id="source" name="source" data-tooltip="<c:out value="${descriptors['disclosureSourceField']}"/>">
                        <option value="exchange" selected>Exchange</option>
                        <option value="direct">Direct</option>
                    </select>
                </div>
                <div>
                    <label for="ssn">SSN <i><span style="font-weight:normal;">(#########)</span></i></label>
                    <input title="Enter SSN. Enter numbers only no hyphens" id="ssn" name="ssn" type="text" maxlength="9" size="9" data-tooltip="<c:out value="${descriptors['ssnField']}"/>"/> <i><span style="font-weight:normal;"> (Enter numbers only, no hyphens.)</span></i> &nbsp;
                </div>
                <div>
                    <label for="lastName">Last Name</label>
                    <input title="Enter Last Name" id="lastName" name="lastName" type="text" maxlength="255" size="30" data-tooltip="<c:out value="${descriptors['lastNameField']}"/>" />
                </div>
                <div>
                    <label for="firstName">First Name</label>
                    <input title="Enter First Name" id="firstName" name="firstName" type="text" maxlength="255" size="30" data-tooltip="<c:out value="${descriptors['firstNameField']}"/>" />
                </div>
                <div class="width-450" id="dateTip" data-tooltip="<c:out value="${descriptors['startDateEndDateField']}"/>">
                    <div>
                        <label for="startDate">Start Date</label>
                        <date:date id="startDate" name="startDate" value="${startDateDefault}"/> <i>mm/dd/yyyy</i>
                    </div>
                    <div>
                        <label for="endDate">End Date</label>
                        <date:date id="endDate" name="endDate" value="${endDateDefault}"/> <i>mm/dd/yyyy</i>
                    </div>
                </div>
                <c:if test="${pouFlag eq true}">
                    <div>
                        <label title="Purpose of Use" for="purposeOfUse">Purpose of Use</label>
                        <select id="purposeOfUse" name="purposeOfUse" data-tooltip="<c:out value="${descriptors['purposeOfUseField']}"/>">
                            <option value="">ALL</option>
                            <c:forEach var="pou" items="${pous}">
                                <option value="<c:out value="${pou.pouValue}" />"><c:out value="${pou.pouValue}" /></option>
                            </c:forEach>
                        </select>
                    </div>
                </c:if>
                <div id="facilityDiv">
                    <label title="Query based on Patient Preferred Facility from the dropdown list" for="facility">Patient Preferred Facility</label>
                    <select id="facility" name="facility" onchange="document.getElementById('facilityName').value = this.options[this.selectedIndex].text;" data-tooltip="<c:out value="${descriptors['patientPreferredFacilityFilter']}"/>">
                        <option value="">ALL</option>
                        <c:forEach var="f" items="${facilities}">
                            <option value="<c:out value="${f.facilityStation}" />"
                                    <c:choose>
                                        <c:when test="${f.facilityStation eq defaultUserFacility.facilityStation}">
                                            selected
                                        </c:when>
                                        <c:when test="${cookie.facility.value == f.facilityStation}">
                                            selected
                                        </c:when>
                                    </c:choose>>
                                <c:choose>
                                    <c:when test="${f.facilityName != ''}">
                                        <c:out value="${f.facilityName}" />
                                    </c:when>
                                    <c:otherwise>
                                        <c:out value="${fn:split(f.facilityDns, '.')[0]}" />
                                    </c:otherwise>
                                </c:choose>
                                (<c:out value="${f.facilityStation}" />)
                            </option>
                        </c:forEach>
                    </select>
                </div>
                <div id="organizationDiv">
                    <label title="Query based on <c:out value="${organizationName}" /> Organization from the dropdown list" for="organization"><c:out value="${organizationName}" /> Organization</label>
                    <select id="organization" name="organization" onchange="document.getElementById('organizationName').value = this.options[this.selectedIndex].text;" data-tooltip="<c:out value="${descriptors['accountingOfDisclosuresReportOrganizationField']}"/>">
                        <option value="" selected>ALL</option>
                        <c:forEach var="r" items="${activeOrgs}">
                            <option value="%<c:out value="${r.orgOid}" />"><c:out value="${r.orgName}" /></option>
                        </c:forEach>
                        <c:forEach var="r" items="${inactiveOrgs}">
                            <option value="%<c:out value="${r.orgOid}" />">[INACTIVE] <c:out value="${r.orgName}" /></option>
                        </c:forEach>
                    </select>
                </div>
                <div id="patientTypesDiv">
                    <label for="patientTypes">Patient Types<span style="display:none;">"Choose whether you would like to filter by real patients only, test patients only, or both."</span></label>
                    <select id="patientTypes" name="patientTypes" data-tooltip="<c:out value="${descriptors['patientTypesField']}"/>">
                        <option value="3">ALL</option>
                        <option value="1" selected>Real Patients</option>
                        <option value="2">Test Patients</option>
                    </select>
                </div>

            </fieldset>
        </form>
        <div>
            <input id="searchButton" name="search" title="Search" class="button" type="submit" value="Search" />
        </div>
    </div>
    <div id="results">
    <div align="right" class="pad-top-5">
        <button name="exportToExcel" class="button" title="Export to Excel" id="excelButton">Export to Excel</button>
        <input name="exportToCsv" id="csvButton" title="Export to CSV" class="button" type="submit" value="Export to CSV" />
        <input name="printReport" id="printReport" title="Print" class="button" type="button" value="Print" />
    </div>
    <%@include file="patientLinkForm.jsp"%>
    <div id="divReportContent">
        <form action="DocumentDisclosureReport.do_sec" method="POST" target="_blank" onsubmit="return doSubmit(this)" id="documentViewForm">
            <input type="hidden" name="view" value="true">
            <input type="hidden" name="documentICN"  value="" id="document-View-ICN">
            <input type="hidden" name="documentUniqueId" value="" id="document-View-Unique-Id">
        </form>

        <table id="exchangeDataTable" class="display" width="100%" cellspacing="0" role="presentation">
            <thead>
                <tr role="row">
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['ssnColumn']}"/>">SSN</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['lastNameColumn']}"/>">Patient Last Name</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['firstNameColumn']}"/>">Patient First Name</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['eventOccurredColumn']}"/>">Date of Disclosures (CT)</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['disclosureColumn']}"/>">Disclosures</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['disclosureReportFacilityColumn']}"/>">Patient Preferred Facility</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['patientPreferredFacilityStationIdColumn']}"/>">Patient Preferred Facility Station ID</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['accountingOfDisclosuresReportOrganization']}"/>">eHealth Exchange Organization</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['disclosuresUserIdColumn']}"/>">User ID</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['purposeOfUseColumn']}"/>">Purpose of Use</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['disclosureDetailedReportUserRoleColumn']}"/>" data-tooltip-position="left">User Role</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['genericViewColumn']}"/>" data-tooltip-position="left">View</span></th>
                </tr>
            </thead>
        </table>
        <div aria-live="polite" role="status" id="directDataTable_info" class="dataTables_info hidden">Shows entries for Direct</div><%-- because we don't have the "Showing x of x" turned on for this table, we need this here to support aria --%>
        <table id="directDataTable" class="display" width="100%" cellspacing="0" role="presentation">
            <thead>
                <tr role="row">
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['ssnColumn']}"/>">SSN</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['lastNameColumn']}"/>">Patient Last Name</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['firstNameColumn']}"/>">Patient First Name</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['eventOccurredColumn']}"/>">Date of Disclosures (CT)</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['disclosureColumn']}"/>">Disclosures</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['disclosuresDirectAddress']}"/>">Direct Address</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['disclosuresUserIdColumn']}"/>">User ID</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['purposeOfUseColumn']}"/>">Purpose of Use</span></th>
                </tr>
            </thead>
        </table>
    </div>
    </div>
</f:mainTemplate>