<%--
    Document   : Disclosure Summary Report
--%>

<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp"%>
<%@taglib tagdir="/WEB-INF/tags/date" prefix="date"%>
<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>
<%@page import="java.util.*"%>

<f:mainTemplate headerText="Disclosures Summary Report">
    <script language="JavaScript">
        $(document).ready(function () {
            setFocus(disclosureSummaryReportForm.source);

            $('#source').on('change', function () {
                handleSourceChange();
            });

            $("#startDate").datepicker({
                maxDate: 0,
                dateFormat: 'mm/dd/yy',
                onClose: function (selectedDate) {
                    $("#endDate").datepicker("option", "minDate", selectedDate);
                }
            });

            $("#endDate").datepicker({
                maxDate: 0,
                dateFormat: 'mm/dd/yy',
                onClose: function (selectedDate) {
                    $("#startDate").datepicker("option", "maxDate", selectedDate);
                }
            });

            var reportTable;

            setFocus(disclosureSummaryReportForm.source);

            //call table with default values on arrival
            buildTable(true);

            //initial data table setup and call for the first recordset
            $.fn.dataTable.ext.errMode = 'none';

            reportTable.on('draw', function () {
                addAriaToDataTable('exchangeReportTable', reportTable);
                addAriaToDataTable('directReportTable', reportTable);
            });

            function buildTable(loadingPage) {
                if (loadingPage) {
                    setProcessingForDataTable('exchangeReportTable', -14);

                    reportTable = $('#exchangeReportTable').DataTable({
                        deferLoading: 0,
                        destroy: true,
                        ajax: {
                            url: constructUrl("doSearch"),
                            dataSrc: function(json){
                                $('.dataTables_empty').remove();
                                return json.data;
                            },
                            error: function(o){
                                handleErrorsInDataTable('exchangeReportTable', o, 3);
                            }
                        },
                        info: false,
                        language: {
                            emptyTable: "No records found",
                            loadingRecords: ""
                        },
                        paging: false,
                        processing: true,
                        searching: false,
                        serverSide: true,
                        columnDefs: [
                            {className: "dt-head-center", targets: [0,1,2]},
                            {className: "dt-head-center dt-body-right", targets: [3]}
                        ],
                        scrollX:true,
                        initComplete: function(){
                            // Enable THEAD scroll bars
                            $('.dataTables_scrollHead').css('overflow', 'auto');

                            // Sync THEAD scrolling with TBODY
                            $('.dataTables_scrollHead').on('scroll', function () {
                                $('.dataTables_scrollBody').scrollLeft($(this).scrollLeft());
                            });
                        },
                        "footerCallback": function ( row, data, start, end, display) {
                            var api = this.api(), data;

                            // Update footer
                            $( api.column( 0 ).footer() ).html(
                                '<strong>Total:</strong>'
                            );

                            $(api.column(3).footer() ).html(
                                '<strong>' + api.column(3, {page:'current'}).data().sum() + '</strong>'
                            );
                        }
                    });
                } else if ($('#source').val() === 'Exchange') {
                    setProcessingForDataTable('exchangeReportTable', -14);

                    reportTable = $('#exchangeReportTable').DataTable({
                        destroy: true,
                        ajax: {
                            url: constructUrl("doSearch"),
                            dataSrc: function(json){
                                $('.dataTables_empty').remove();
                                return json.data;
                            },
                            error: function(o){
                                handleErrorsInDataTable('exchangeReportTable', o, 3);
                            }
                        },
                        info: false,
                        language: {
                            emptyTable: "No records found",
                            loadingRecords: ""
                        },
                        paging: false,
                        processing: true,
                        searching: false,
                        serverSide: true,
                        columnDefs: [
                            {className: "dt-head-center", targets: [0,1,2]},
                            {className: "dt-head-center dt-body-right", targets: [3]}
                        ],
                        scrollX:true,
                        initComplete: function(){
                            // Enable THEAD scroll bars
                            $('.dataTables_scrollHead').css('overflow', 'auto');

                            // Sync THEAD scrolling with TBODY
                            $('.dataTables_scrollHead').on('scroll', function () {
                                $('.dataTables_scrollBody').scrollLeft($(this).scrollLeft());
                            });
                        },
                        "footerCallback": function ( row, data, start, end, display ) {
                            var api = this.api(), data;

                            // Update footer
                            $( api.column( 0 ).footer() ).html(
                                '<strong>Total:</strong>'
                            );

                            $(api.column(3).footer() ).html(
                                '<strong>' + api.column(3, {page:'current'}).data().sum() + '</strong>'
                            );
                        }
                    });
                } else {
                    setProcessingForDataTable('directReportTable');

                    reportTable = $('#directReportTable').DataTable({
                        destroy: true,
                        ajax: {
                            url: constructUrl("doSearch"),
                            dataSrc: function(json){
                                $('.dataTables_empty').remove();
                                return json.data;
                            },
                            error: function(o){
                                handleErrorsInDataTable('directReportTable', o, 2);
                            }
                        },
                        info: false,
                        language: {
                            emptyTable: "No records found",
                            loadingRecords: ""
                        },
                        paging: false,
                        processing: true,
                        searching: false,
                        serverSide: true,
                        columnDefs: [
                            {className: "dt-head-center", targets: [0]},
                            {className: "dt-head-center dt-body-right", targets: [1]}
                        ],
                        scrollX:true,
                        initComplete: function(){
                            // Enable THEAD scroll bars
                            $('.dataTables_scrollHead').css('overflow', 'auto');

                            // Sync THEAD scrolling with TBODY
                            $('.dataTables_scrollHead').on('scroll', function () {
                                $('.dataTables_scrollBody').scrollLeft($(this).scrollLeft());
                            });
                        },
                        "footerCallback": function ( row, data, start, end, display ) {
                            var api = this.api(), data;

                            // Update footer
                            $(api.column(1).footer() ).html(
                                api.column(1, {page:'current'}).data().sum()
                            );
                        }
                    });
                }
            }

            function constructUrl(methodName){
                var url= 'DisclosureSummaryReport.do_sec' +
                        '?' + methodName + '=true' +
                        '&source=' + $('#source').val() +
                        '&startDate=' + $('#startDate').val() +
                        '&endDate=' + $('#endDate').val() +
                        '&organization=' + $('#organization').val() +
                        '&organizationName=' + $('#orgName').val() +
                        '&facility=' + $('#facility').val() +
                        '&facilityName=' + $('#facilityName').val() +
                        '&patientTypes=' + $('#patientTypes').val();

                if($('#source').val() === 'Exchange') {
                    url = url + '&sortBy=' + $('#exchangeReportTable').dataTable().fnSettings().aaSorting[0][0] +
                    '&sortOrder=' + $('#exchangeReportTable').dataTable().fnSettings().aaSorting[0][1];
                } else {
                    url = url + '&sortBy=' + $('#directReportTable').dataTable().fnSettings().aaSorting[0][0] +
                    '&sortOrder=' + $('#directReportTable').dataTable().fnSettings().aaSorting[0][1];
                }

                return url;
            }

            $('#searchButton').on('click', function () {
                var startDate = $('#startDate').val();
                var endDate = $('#endDate').val();

                var errorMessage = validateStartAndEndDate(startDate, endDate);

                if (errorMessage != '') {
                    //we have an error so show the error, and then don't send the ajax request
                    $('#errorMessage').html(errorMessage);
                    $('#errorMessage').show();

                    return false;
                } else {
                    //no error, let's make the call to populate the report
                    $('#results').show();
                    buildTable(false);
                }
            });

            $('.exportButton').on('click', function() {
                window.location.href = constructUrl($(this).data('method'));
                return false;
            });

            $('#startDate,#endDate').on('change', function () {
                //if either date changes, hide the error message if its not already hidden
                $('#errorMessage').hide();
            });

            handleSourceChange();
        });

        function handleSourceChange() {
            if ($('#source').val() === 'Exchange') {
                $('#extrafilters').show();
                $("#exchangeReportTable_wrapper").show();
                $("#exchangeReportTable").show();
                $("#directReportTable_wrapper").hide();
                $("#directReportTable").hide();
            } else {
                $('#extrafilters').hide();
                $("#exchangeReportTable_wrapper").hide();
                $("#exchangeReportTable").hide();
                $("#directReportTable_wrapper").show();
                $("#directReportTable").show();
            }
            $('#results').hide();
        };
    </script>

    <div class="form-container">
        <form name="disclosureSummaryReportForm" action="DisclosureSummaryReport.do_sec" method="POST" onsubmit="return doSubmit(this)">
            <fieldset>
                <legend>Search Details</legend>
                <input type="hidden" name="orgName" id="orgName" value="<c:out value="${orgName}"/>" />
                <input type="hidden" name="facilityName" id="facilityName" value="<c:out value="${facilityName}"/>" />

                <div id="errorMessage" class="bg-warning pad-15" style="display: none;"></div>
                <div class="pad-top-10">
                    <label title="Select the disclosure source" for="source">Disclosure Source</label>
                    <select data-tooltip="<c:out value="${descriptors['disclosureSourceField']}"/>" id="source" name="source">
                        <option value="Exchange" selected>Exchange</option>
                        <option value="Direct">Direct</option>
                    </select>
                </div>
                <div class="width-450" data-tooltip="<c:out value="${descriptors['startDateEndDateField']}"/>">
                    <div>
                        <label for="startDate">Start Date</label>
                        <date:date id="startDate" name="startDate" value="${startDateDefault}"/> <i>mm/dd/yyyy</i>
                    </div>
                    <div>
                        <label for="endDate">End Date</label>
                        <date:date id="endDate" name="endDate" value="${endDateDefault}"/> <i>mm/dd/yyyy</i>
                    </div>
                </div>
                <span id="extrafilters">
                    <div>
                        <label
                            alt="Query based on Patient Preferred Facility from the dropdown list"
                            for="facility">Patient Preferred Facility</label>
                        <select data-tooltip="<c:out value="${descriptors['patientPreferredFacilityFilter']}"/>" id="facility" name="facility" onchange = "document.getElementById('facilityName').value = this.options[this.selectedIndex].text;">
                            <option value="">ALL</option>
                            <c:forEach var="f" items="${facilities}">
                                <option value="<c:out value="${f.facilityStation}"/>"
                                        <c:choose>
                                            <c:when test="${f.facilityStation eq defaultUserFacility.facilityStation}">
                                                selected
                                            </c:when>
                                        </c:choose>>
                                    <c:choose>
                                        <c:when test="${f.facilityName != ''}">
                                            <c:out value="${f.facilityName}"/>
                                        </c:when>
                                        <c:otherwise>
                                            <c:out value="${fn:split(f.facilityDns, '.')[0]}" />
                                        </c:otherwise>
                                    </c:choose>
                                    (<c:out value="${f.facilityStation}"/>)
                                </option>
                            </c:forEach>
                        </select>
                    </div>

                    <div>

                        <label
                            alt="Query based on <c:out value="${organizationName}"/> Organization from the dropdown list"
                            for="organization"><c:out value="${organizationName}"/> Organization</label>
                        <select data-tooltip="<c:out value="${descriptors['disclosuresSummaryReportOrganizationField']}"/>" id="organization" name="organization" onchange = "document.getElementById('orgName').value = this.options[this.selectedIndex].text;">
                            <option value="external" selected>ALL</option>
                            <c:forEach var="r" items="${activeOrgs}">
                                <option value="%<c:out value="${r.orgOid}"/>">
                                    <c:out value="${r.orgName}"/>
                                </option>
                            </c:forEach>
                            <c:forEach var="r" items="${inactiveOrgs}">
                                <option value="%<c:out value="${r.orgOid}"/>">[INACTIVE] <c:out value="${r.orgName}"/></option>
                            </c:forEach>
                        </select>
                    </div>
                        <div>
                        <label for="patientTypes">Patient Types<span style="display:none;">"Choose whether you would like to filter by real patients only, test patients only, or both."</span></label>
                        <select data-tooltip="<c:out value="${descriptors['patientTypesField']}"/>" id="patientTypes" name="patientTypes">
                            <option value="3">ALL</option>
                            <option value="1" selected>Real Patients</option>
                            <option value="2">Test Patients</option>
                        </select>
                        </div>
                </span>
            </fieldset>
        </form>
        <div>
            <input name="search" title="Search" class="button" type="submit" value="Search" id="searchButton"/>
        </div>
    </div>
    <div id="results">
    <div align="right" class="pad-top-5 pad-bottom-15">
        <a href="#"><button class="exportButton" data-method="exportToExcel" title="Export to Excel">Export to Excel</button></a>
    </div>
    <div id="divReportContent">
        <table id="exchangeReportTable" class="display" width="100%" cellspacing="0" role="presentation">
            <thead>
                <tr role="row">
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['disclosureSummaryReportOrganizationColumn']}"/>"><c:out value="${organizationName}"/> Organization</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['disclosureSummaryReportFacilityColumn']}"/>">Patient Preferred Facility</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['patientPreferredFacilityStationIdColumn']}"/>">Patient Preferred Facility Station ID</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['disclosureSummaryReportTotalColumn']}"/>" data-tooltip-position="left">Total</span></th>
                </tr>
            </thead>
            <tfoot>
                <tr role="row">
                    <%--Filled in by datatables--%>
                    <td role="gridcell" class="text-left footer-bold-pad-left-8"></td>
                    <td role="gridcell"></td>
                    <td role="gridcell"></td>
                    <td role="gridcell" class="text-right footer-bold-pad-right-9"></td>
                </tr>
            </tfoot>
        </table>
        <div aria-live="polite" role="status" id="exchangeReportTable_info" class="dataTables_info hidden">Shows entries for Exchange</div><%-- because we don't have the "Showing x of x" turned on for this table, we need this here to support aria --%>
        <table id="directReportTable" class="display" width="100%" cellspacing="0" role="presentation">
            <thead>
                <tr role="row">
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['disclosureSummaryReportOrganizationColumn']}"/>">Direct Endpoint</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['disclosureSummaryReportTotalColumn']}"/>" data-tooltip-position="left">Total</span></th>
                </tr>
            </thead>
            <tfoot>
                <tr role="row">
                    <%--Filled in by datatables--%>
                    <td role="gridcell" class="text-left footer-bold-pad-left-8">Total:</td>
                    <td role="gridcell" class="text-right footer-bold-pad-right-9"></td>
                </tr>
            </tfoot>
        </table>
        <div aria-live="polite" role="status" id="directReportTable_info" class="dataTables_info hidden">Shows entries for Direct</div><%-- because we don't have the "Showing x of x" turned on for this table, we need this here to support aria --%>
    </div>
    </div>
</f:mainTemplate>