<%--
    Document   : delayedConsentSummaryReport
    Created on : Apr 5, 2016, 2:13:02 PM
    Author     : Irakli Kakushadze
--%>

<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>
<%@page import="java.util.HashMap"%>
<%@page import="gov.va.nvap.svc.facility.data.Facility"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp" %>

<%
    HashMap tips = (HashMap) session.getAttribute("descriptors");
    String facilityFilterTooltip = (String) tips.get("authenticatingFacilityField");
    Facility defaultUserFacility = (Facility) session.getAttribute("defaultUserFacility");
    String defaultUserFacilityName = defaultUserFacility == null ? "" : defaultUserFacility.getFacilityName();
    String defaultUserFacilityStation = defaultUserFacility == null ? "" : defaultUserFacility.getFacilityStation();
    pageContext.setAttribute("facilityFilterTooltip", facilityFilterTooltip);
    pageContext.setAttribute("defaultUserFacility", defaultUserFacility);
    pageContext.setAttribute("defaultUserFacilityName", defaultUserFacilityName);
    pageContext.setAttribute("defaultUserFacilityStation", defaultUserFacilityStation);
%>

<f:mainTemplate headerText="Delayed Consent Summary Report">
    <script language="JavaScript">
        $(document).ready(function () {
            //check the ALL checkbox for the reasons on initial load
            $('.allableCheckbox[value=ALL]').prop("checked", true);

            // Initial data request.
            $.fn.dataTable.ext.errMode = 'none';

            setProcessingForDataTable('reportTable', -14);

            var reportTable = $('#reportTable').DataTable({
                deferLoading: 0,
                destroy:true,
                searching: false,
                processing: true,
                serverSide: true,
                order: [[0, 'asc']],
                ajax: constructUrl("doSearch"),
                language: {
                    emptyTable: "No records found",
                    loadingRecords: ""
                },
                paging: false,
                info: false,
                columnDefs: [
                    {className: "dt-head-center dt-body-left", targets: [0,1]},
                    {className: "dt-head-center dt-body-right", targets: [2]}
                ],
                scrollX:true,
                initComplete: function(){
                    // Enable THEAD scroll bars
                    $('.dataTables_scrollHead').css('overflow', 'auto');

                    // Sync THEAD scrolling with TBODY
                    $('.dataTables_scrollHead').on('scroll', function () {
                        $('.dataTables_scrollBody').scrollLeft($(this).scrollLeft());
                    });
                },
                drawCallback: function() {
                    var api = this.api();

                    $(api.column(2).footer() ).html(
                        api.column(2, {page:'current'}).data().sum()
                    );
                }
            });

            reportTable.on('draw', function () {
                addAriaToDataTable('reportTable', reportTable);
            });

            $('#searchButton').on('click', function () {
                $('#results').show();
                reportTable.ajax.url(constructUrl('doSearch')).load();
            });

            $('.exportButton').on('click', function () {
                window.location.href = constructUrl($(this).data('method'));
                return false;
            });

            function constructUrl(methodName) {
                var reasonsForDelay = [];
                $('.allableCheckbox:checkbox:checked').each(function () {
                    reasonsForDelay.push($(this).val());
                });

                var url = 'DelayedConsentSummaryReport.do_sec' +
                    '?' + methodName + '=true' +
                    '&stationNumbers=' + facilitiesDialog.getSelectedStationNumbers() +
                    '&aggregateAtFacilityLevel=' + facilitiesDialog.getAggregateAtFacilityLevel() +
                    '&includeUnknownVisn=' + facilitiesDialog.getIncludeUnknownVisn() +
                    '&reasonsForDelay=' + reasonsForDelay.toString() +
                    '&daysSinceDelayed=' + $('#daysSinceDelayed').val() +
                    '&consentType=' + $('#consentType').val() +
                    '&start=0' +
                    '&length=-1' +
                    '&sortBy=' + $('#reportTable').dataTable().fnSettings().aaSorting[0][0] +
                    '&sortOrder=' + $('#reportTable').dataTable().fnSettings().aaSorting[0][1] +
                    '&patientTypes=' + $('#patientTypes').val();

                return url;
            };

            $('#results').hide();
        });
    </script>
    <div class="form-container">
        <form name="searchForm">
            <fieldset>
                <legend>Search</legend>
                <div id="errorMessage" class="errors" style="display: none;"></div>
                <jsp:include page="reporting/common/facilitiesFilter.jsp">
                    <jsp:param name="defaultUserFacility" value="${defaultUserFacility}" />
                    <jsp:param name="defaultUserFacilityName" value="${defaultUserFacilityName}" />
                    <jsp:param name="defaultUserFacilityStation" value="${defaultUserFacilityStation}" />
                    <jsp:param name="facilityFilterTooltip" value="${facilityFilterTooltip}" />
                </jsp:include>
                <div class="width-500" data-tooltip="<c:out value="${descriptors['reasonsForDelayField']}"/>">
                    <label for="reasonsForDelay">Reason(s) for Delay</label>
                    <div style="padding-left: 238px !important;">
                        <input type="checkbox" value="ALL" class="allableCheckbox" id="all"/>
                        <label class="vap-reg-label" for="all">ALL</label><br />
                        <c:forEach var="r" items="${reasons}" varStatus="i">
                            <input type="checkbox" value="<c:out value="${r.delayReasonId}"/>" id="<c:out value="${fn:replace(r.name, ' ', '')}" />" class="allableCheckbox" />
                            <label class="vap-reg-label" for="<c:out value="${fn:replace(r.name, ' ', '')}" />"><c:out value="${r.name}"/></label><br />
                        </c:forEach>
                    </div>
                </div>
                <div>
                    <label for="daysSinceDelayed">Days Since Delayed</label>
                    <select data-tooltip="<c:out value="${descriptors['daysSinceDelayedField']}"/>" id="daysSinceDelayed" name="daysSinceDelayed">
                        <option value="ALL">ALL</option>
                        <option value="0">0-5 days</option>
                        <option value="5">&gt; 5 days</option>
                        <option value="10">&gt; 10 days</option>
                        <option value="15">&gt; 15 days</option>
                        <option value="30">&gt; 30 days</option>
                        <option value="60">&gt; 60 days</option>
                        <option value="90">&gt; 90 days</option>
                        <option value="120">&gt; 120 days</option>
                    </select>
                </div>
                <div>
                    <label for="consentType">Consent Type</label>
                    <select data-tooltip="<c:out value="${descriptors['delayedConsentSummaryReportConsentTypeField']}"/>" id="consentType" name="consentType">
                        <option value="ALL">ALL</option>
                        <option value="NwHIN Authorization"><c:out value="${organizationName}"/> Authorizations</option>
                        <option value="SSA Authorization">SSA Authorizations</option>
                    </select>
                </div>
                <div>
                    <label for="patientTypes">Patient Types</label>
                    <select data-tooltip="<c:out value="${descriptors['patientTypesField']}"/>" id="patientTypes" name="patientTypes">
                        <option value="3">ALL</option>
                        <option value="1" selected>Real Patients</option>
                        <option value="2">Test Patients</option>
                    </select>
                </div>
            </fieldset>
            <div>
                <input name="searchButton" id="searchButton" title="Search" class="button" type="button" value="Search" />
            </div>
        </form>
    </div>
    <div id="results">
    <div align="right" class="pad-top-5 pad-bottom-15">
        <a href="#"><button class="exportButton" data-method="exportToExcel" title="Export to Excel">Export to Excel</button></a>
    </div>
    <div id="divReportContent">
        <table id="reportTable" class="display" width="100%" cellspacing="0" role="presentation">
            <thead>
                <tr role="row">
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['delayedConsentSummaryReportAuthenticatingFacilityColumn']}"/>" id="authenticatingFacilityHeader">Authenticating Facility</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['delayedConsentSummaryReportConsentTypeColumn']}"/>" id="consentTypeHeader">Consent Type</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['delayedConsentSummaryReportTotalColumn']}"/>" data-tooltip-position="left" id="totalHeader">Total</span></th>
                </tr>
            </thead>
            <tfoot>
                <tr role="row">
                    <td role="gridcell" class="footer-bold-pad-left-8 text-left">Total:</td>
                    <td role="gridcell"></td>
                    <td role="gridcell" class="footer-bold-pad-right-9 text-right"></td>
                </tr>
            </tfoot>
        </table>
        <div aria-live="polite" role="status" id="reportTable_info" class="dataTables_info hidden">Shows consent directive summary data</div><%-- because we don't have the "Showing x of x" turned on for this table, we need this here to support aria --%>
    </div>
    </div>
</f:mainTemplate>