<%--
    Document   : delayedConsentReport
    Created on : Apr 5, 2016, 2:13:02 PM
    Author     : Irakli Kakushadze
--%>

<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>
<%@page import="java.util.HashMap"%>
<%@page import="gov.va.nvap.svc.facility.data.Facility"%>
<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<%
    HashMap tips = (HashMap) session.getAttribute("descriptors");
    String facilityFilterTooltip = (String) tips.get("authenticatingFacilityField");
    Facility defaultUserFacility = (Facility) session.getAttribute("defaultUserFacility");
    String defaultUserFacilityName = defaultUserFacility == null ? "" : defaultUserFacility.getFacilityName();
    String defaultUserFacilityStation = defaultUserFacility == null ? "" : defaultUserFacility.getFacilityStation();
    pageContext.setAttribute("facilityFilterTooltip", facilityFilterTooltip);
    pageContext.setAttribute("defaultUserFacility", defaultUserFacility);
    pageContext.setAttribute("defaultUserFacilityName", defaultUserFacilityName);
    pageContext.setAttribute("defaultUserFacilityStation", defaultUserFacilityStation);
%>

<f:mainTemplate headerText="Delayed Consent Detail Report">
    <script language="JavaScript">
        $(document).ready(function () {
            // Check the ALL checkbox for the reasons on initial load
            $('.allableCheckbox[value=ALL]').prop('checked', true);

            // Initial data request.
            $.fn.dataTable.ext.errMode = 'none';

            setProcessingForDataTable('reportTable');

            reportTable = $('#reportTable').DataTable({
                deferLoading: 0,
                destroy: true,
                searching: false,
                processing: true,
                serverSide: true,
                order: [[0, 'desc']],
                columnDefs: [
                    {orderable: false, targets: [7, 10]},
                    {width: '80', targets: 2},
                    {className: 'vap-report-nowrap dt-head-center', targets: 2},
                    {className: "vap-col-min-130 dt-head-center", targets: [0,9]},
                    {className: "dt-head-center", targets: [1,3,4,5,6,7,8,10]}
                ],
                ajax: 'DelayedConsentReport.do_sec?doSearch=true',
                dom: 'liptipr',
                language: {
                    emptyTable: "No records found",
                    loadingRecords: ""
                },
                lengthMenu: [ 10, 25, 50, 100, 250, 500 ],
                pageLength: 25,
                scrollX:true,
                initComplete: function(){
                    // Enable THEAD scroll bars
                    $('.dataTables_scrollHead').css('overflow', 'auto');

                    // Sync THEAD scrolling with TBODY
                    $('.dataTables_scrollHead').on('scroll', function () {
                        $('.dataTables_scrollBody').scrollLeft($(this).scrollLeft());
                    });
                },
                order: [[0, "desc"]]
            });

            reportTable.on('draw', function () {
                addAriaToDataTable('reportTable', reportTable);
            });

            $('#searchButton').on('click', function () {
                // Validate data before submitting to the server.
                $('#errorMessage').hide();
                if (validateSsns($('#ssn'))) {
                    $('#results').show();
                    reportTable.ajax.url(constructUrl('doSearch')).load();
                } else {
                    showSsnError();
                    return false;
                }
            });

            function validateSsns(field) {
                var sansWhiteSpace = field.val().replace(/ /g, '');
                if (sansWhiteSpace !== null) {
                    if (/^\d{9}(,\d{9})*$/.test(sansWhiteSpace) || sansWhiteSpace === '') {
                        field.val(sansWhiteSpace);
                        return true;
                    } else {
                        return false;
                    }
                }
            };

            function showSsnError() {
                $('#errorMessage').html('Please enter valid nine digit SSN numbers only, no hyphens. If entering multiple SSNs, separate them by commas.');
                $('#errorMessage').show();
            };

            $('#results').hide();
        });

        constructUrl = function (methodName) {
            var reasonsForDelay = [];
            $('.allableCheckbox:checkbox:checked').each(function () {
                reasonsForDelay.push($(this).val());
            });

            var url = 'DelayedConsentReport.do_sec' +
                    '?' + methodName + '=true' +
                    '&ssn=' + $('#ssn').val() +
                    '&lastName=' + $('#lastName').val() +
                    '&firstName=' + $('#firstName').val() +
                    '&stationNumbers=' + facilitiesDialog.getSelectedStationNumbers() +
                    '&includeUnknownVisn=' + facilitiesDialog.getIncludeUnknownVisn() +
                    '&reasonsForDelay=' + reasonsForDelay.toString() +
                    '&daysSinceDelayed=' + $('#daysSinceDelayed').val() +
                    '&consentType=' + $('#consentType').val() +
                    '&sortBy=' + $('#reportTable').dataTable().fnSettings().aaSorting[0][0] +
                    '&sortOrder=' + $('#reportTable').dataTable().fnSettings().aaSorting[0][1] +
                    '&patientTypes=' + $('#patientTypes').val() +
                    '&enteredBy=' + $('#enteredBy').val();

            if (methodName === 'exportToCsv' || methodName === 'exportToExcel') {
                url = url + '&totalRows=' + reportTable.page.info().recordsTotal;
            }
            return url;
        };
    </script>
    <%@include file="patientLinkForm.jsp"%>

    <div class="form-container">
        <form name="searchForm">
            <fieldset>
                <legend>Search Details</legend>
                <div id="errorMessage" class="errors" style="display: none;"></div>
                <div>
                    <label for="ssn">SSN(s)</label>
                    <input data-tooltip="<c:out value="${descriptors['delayedConsentDetailReportSSNField']}" />" title="Enter SSN. Enter numbers only no hyphens" id="ssn" name="ssn" type="text" size="30" /> <i><span style="font-weight:normal;"> (Enter one or more SSN's, with no hyphens, separated by commas)</span></i> &nbsp;
                </div>
                <div>
                    <label for="lastName">Last Name</label>
                    <input data-tooltip="<c:out value="${descriptors['lastNameField']}" />" title="Enter Last Name" id="lastName" name="lastName" type="text" maxlength="255" size="30" />
                </div>
                <div>
                    <label for="firstName">First Name</label>
                    <input data-tooltip="<c:out value="${descriptors['firstNameField']}" />" title="Enter First Name" id="firstName" name="firstName" type="text" maxlength="255" size="30" />
                </div>
                <jsp:include page="reporting/common/facilitiesFilter.jsp">
                    <jsp:param name="defaultUserFacility" value="${defaultUserFacility}" />
                    <jsp:param name="defaultUserFacilityName" value="${defaultUserFacilityName}" />
                    <jsp:param name="defaultUserFacilityStation" value="${defaultUserFacilityStation}" />
                    <jsp:param name="facilityFilterTooltip" value="${facilityFilterTooltip}" />
                </jsp:include>
                <div>
                    <label for="reasonsForDelay">Reason(s) for Delay</label>
                    <div style="padding-left: 238px !important;">
                        <span data-tooltip="<c:out value="${descriptors['reasonsForDelayField']}" />" id="reasonsForDelayTip">
                            <input type="checkbox" value="ALL" class="allableCheckbox" id="all"><label class="vap-reg-label" for="all">ALL</label><br />
                            <c:forEach var="r" items="${reasons}" varStatus="i">
                                <input type="checkbox" value="<c:out value="${r.delayReasonId}" />" id="<c:out value="${fn:replace(r.name, ' ', '')}" />" class="allableCheckbox" /><label class="vap-reg-label" for="<c:out value="${fn:replace(r.name, ' ', '')}" />"><c:out value="${r.name}" /></label><br />
                            </c:forEach>
                        </span>
                    </div>
                </div>
                <div>
                    <label for="daysSinceDelayed">Days Since Delayed</label>
                    <select data-tooltip="<c:out value="${descriptors['daysSinceDelayedField']}" />" id="daysSinceDelayed" name="daysSinceDelayed">
                        <option value="ALL">ALL</option>
                        <option value="0">0-5 days</option>
                        <option value="5">&gt; 5 days</option>
                        <option value="10">&gt; 10 days</option>
                        <option value="15">&gt; 15 days</option>
                        <option value="30">&gt; 30 days</option>
                        <option value="60">&gt; 60 days</option>
                        <option value="90">&gt; 90 days</option>
                        <option value="120">&gt; 120 days</option>
                    </select>
                </div>
                <div>
                    <label for="consentType">Consent Type</label>
                    <select data-tooltip="<c:out value="${descriptors['delayedConsentDetailReportConsentTypeField']}" />" id="consentType" name="consentType">
                        <option value="ALL">ALL</option>
                        <option value="NwHIN Authorization"><c:out value="${organizationName} Authorizations" /></option>
                        <option value="SSA Authorization">SSA Authorizations</option>
                    </select>
                </div>
                <div>
                    <label for="patientTypes">Patient Types</label>
                    <select data-tooltip="<c:out value="${descriptors['patientTypesField']}" />" id="patientTypes" name="patientTypes">
                        <option value="3">ALL</option>
                        <option value="1"selected>Real Patients</option>
                        <option value="2">Test Patients</option>
                    </select>
                </div>
                <div>
                    <label for="enteredBy">Entered By</label>
                    <input data-tooltip="<c:out value="${descriptors['delayedConsentDetailReportEnteredByField']}" />" title="Entered By" id="enteredBy" name="enteredBy" type="text" maxlength="255" size="30" />
                </div>
            </fieldset>
            <div>
                <input name="searchButton" id="searchButton" title="Search" class="button" type="button" value="Search" />
            </div>
        </form>
    </div>
    <div id="results">
    <div align="right" class="pad-top-5">
        <input id="excelButton" name="excelButton" class="button" type="submit" value="Export To Excel" />
        &nbsp;&nbsp;
        <input id="csvButton" name="csvButton" class="button" type="submit" value="Export To CSV" />
    </div>
    <div id="divReportContent">
        <table id="reportTable" class="display" width="100%" cellspacing="0" role="presentation">
            <thead>
                <tr role="row">
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['eventOccurredColumn']}" />" id="dateEnteredHeader">Date Entered (CT)</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['icnColumn']}" />" id="icnHeader">ICN</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['ssnColumn']}" />" id="ssnHeader">SSN</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['lastNameColumn']}" />" id="lastNameHeader">Last Name</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['firstNameColumn']}" />" id="firstNameHeader">First Name</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['middleNameColumn']}" />" id="middleNameHeader">Middle Name</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['delayedConsentDetailReportConsentTypeColumn']}" />" id="consentTypeHeader">Consent Type</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['reasonsForDelayColumn']}" />" id="reasonsForDelayHeader">Reason(s) for Delay</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['delayedConsentDetailReportEnteredByColumn']}" />" id="enteredByHeader">Entered By</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['delayedConsentDetailReportAuthenticatingFacilityColumn']}" />" id="authFacilityHeader">Authenticating Facility</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['delayedConsentDetailReporMailedDatesColumn']}" />" data-tooltip-position="left" id="mailedDatesHeader">Mailed Dates</span></th>
                </tr>
            </thead>
        </table>
    </div>
    </div>
</f:mainTemplate>