<%@page import="gov.va.nvap.svc.facility.data.Facility"%>
<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp" %>

<%
    Facility defaultUserFacility = (Facility) session.getAttribute("defaultUserFacility");
    String defaultUserFacilityName = defaultUserFacility == null ? "" : defaultUserFacility.getFacilityName();
    pageContext.setAttribute("defaultUserFacilityName", defaultUserFacilityName);
%>

<f:mainTemplate headerText="Dashboard">
    <script type="text/javascript" src="js/ChartJS2.3/Chart.js"></script>
    <script type="text/javascript">
        $(document).ready(function () {

            //Widgets are loaded in succession even if the previous fails, the chain continues.

            //Expiring Consent Widget, Loads first #########################################################################################
            $.getJSON('ExpiringConsentsWidget.do_sec', function(data){
                $('#expiringNwHINConsents').html("<b>eHealth Exchange Authorizations:</b> " + data.expiringNwHINConsents);
                $('#expiringSSAConsents').html("<b>SSA Authorizations:</b> " + data.expiringSSAConsents);

                $('#expiringConsentLoading').hide();
                readyMonthlyConsentWidget(true);
            }).fail(function(){
                readyMonthlyConsentWidget(true);
            });

            //Monthly Consents Widget ######################################################################################################
            $('#previousMonth').click(function(){
               $('#monthValue').val(parseInt($('#monthValue').val()) - 1);
               $('#monthlyAuthorizationsLoading').show();
               readyMonthlyConsentWidget(false);
            });

            $('#nextMonth').click(function(){
               $('#monthValue').val(parseInt($('#monthValue').val()) + 1);
               $('#monthlyAuthorizationsLoading').show();
               readyMonthlyConsentWidget(false);
            });

            //Boolean parameter to determine if chaining is required, If widget spinner changes month chaining should not occur
            //Chaining should occur for initial page load.
            function readyMonthlyConsentWidget(chain){
                $.getJSON('MonthlyConsentsWidget.do_sec'+'?monthAdjustmentValue=' + $('#monthValue').val(), function (data) {
                    $('#addedeBenefits').html("<b>eHealth Exchange via eBenefits:</b> " + data.eBenefitsAddedAuths);
                    $('#addedManually').html("<b>eHealth Exchange Manual Entries:</b> " + data.manuallyAddedAuths);
                    $('#addedReAuth').html("<b>eHealth Exchange Re-Authorizations:</b> " + data.addedReAuths);
                    $('#ssaAuthAutomated').html("<b>SSA Automated:</b> " + data.ssaAuthAutomated);
                    $('#currentMonth').text(data.month);
                    $('#currentYear').text(data.year);

                    //disable next button if at current month
                    if(parseInt($('#monthValue').val()) >= 0){
                        $('#nextMonth').prop('disabled', true);
                    } else {
                        $('#nextMonth').prop('disabled', false);
                    }

                    $('#monthlyAuthorizationButtons').show();
                    if(chain){
                        readyLoginActivityWidget();
                    }
                    $('#monthlyAuthorizationsLoading').css("margin-top", "-30px"); //move the spinner up to overlay the month and buttons
                }).fail(function(){
                    if(chain){
                        readyLoginActivityWidget();
                    }
                }).complete(function(){
                    $('#monthlyAuthorizationsLoading').hide();
                });
            }

            //Log in Activity Widget #######################################################################################################
            function readyLoginActivityWidget(){
                $.getJSON('LoginActivityWidget.do_sec', function(data){
                    var lineGraph = document.getElementById("loginChart");
                    var myChart = new Chart(lineGraph, {

                        type: 'line',
                        data: {
                            labels: data.labels,
                            datasets: [
                                {
                                    label: 'Past 24 Hours',
                                    data: data.data,
                                    fill: false,
                                    borderColor: 'rgba(75,192,192,1)'
                                }
                            ]
                        },
                        options: {
                            responsive: false,
                            maintainAspectRatio: false,
                            scales:{
                                yAxes: [{
                                    ticks: {
                                        maxTicksLimit: 5,
                                        beginAtZero: true
                                    }
                                }],
                                xAxes: [{
                                    ticks: {
                                        maxRotation: 70,
                                        minRotation: 70
                                    }
                                }]
                            }
                        }
                    });
                    $('#loginActivityLoading').hide();
                    readyTransactionHistoryWidget();
                }).fail(function(){
                    readyTransactionHistoryWidget();
                });
            }

            //Transaction History Widget ###################################################################################################
            function readyTransactionHistoryWidget(){
                $.getJSON('TransactionHistoryWidget.do_sec', function(data){
                    var lineGraph = document.getElementById("transactionChart");
                    var myChart = new Chart(lineGraph, {

                        type: 'line',
                        data: {
                            labels: data.labels,
                            datasets: [
                                {
                                    label: 'Policy Checks',
                                    data: data.exchange,
                                    fill: false,
                                    borderColor: 'rgba(255,90,132,1)'
                                },
                                {
                                    label: 'eBenefits Transactions',
                                    data: data.ebenefits,
                                    fill: false,
                                    borderColor: 'rgba(75,192,192,1)'
                                }
                            ]
                        },
                        options: {
                            responsive: false,
                            maintainAspectRatio: false,
                            scales:{
                                yAxes: [{
                                    ticks: {
                                        maxTicksLimit: 5,
                                        beginAtZero: true
                                    }
                                }],
                                xAxes: [{
                                    ticks: {
                                        maxRotation: 70,
                                        minRotation: 70
                                    }
                                }]
                            }
                        }
                    });
                }).success(function(){
                    addAriaToJSCharts();
                });
                $('#transactionLoading').hide();
            }
        });
    </script>

    <div id="widgetsContainer" class="pad-top-10">
        <div class="margin-bottom-20">
            <div class="margin-bottom-15 margin-top-10">
                The authorization information displayed below is for
                <c:choose>
                    <c:when test="${defaultUserFacility == null}">
                        all facilities.
                    </c:when>
                    <c:otherwise>
                        <c:out value="${defaultUserFacilityName}" />.
                    </c:otherwise>
                </c:choose>
                Times are in CST.
            </div>
            <div id="ExpiringConsentWidget" class="panel panel-default widget-inline margin-right-20" style="height: 200px;">
                <div class="panel-heading text-center">
                    <div class="panel-title">
                        <h4>Expiring Authorizations (within 30 days)</h4>
                    </div>
                </div>
                <div class="panel-body">
                    <p id="expiringNwHINConsents"></p>
                    <p id="expiringSSAConsents"></p>
                    <div id="expiringConsentLoading" >
                        <p class="img-center"><img src="res/ajax-loader_1.gif"/></p>
                    </div>
                </div>
            </div>
            <div id="MonthlyAuthorizationsWidget" class="panel panel-default widget-inline" style="height: 200px;">
                <div class="panel-heading">
                    <div class="panel-title text-center">
                        <h4>New Consent Authorizations (by month)</h4>
                    </div>
                </div>
                <div class="panel-body">
                    <div class="text-center" id="monthlyAuthorizationButtons" style="display:none">
                        <button id="previousMonth" class="btn">Prev</button>
                        <b><span id="currentMonth"></span> <span id="currentYear"></span></b>
                        <button id="nextMonth" class="btn">Next</button>
                        <input type="hidden" id="monthValue" value="0"/>
                    </div>
                    <div id="monthlyAuthorizationsLoading" style="float: left; width: 100%;">
                        <div class="img-center">
                            <img src="res/ajax-loader_1.gif"/>
                        </div>
                    </div>
                    <div style="position: absolute;">
                        <p id="addedeBenefits" class="pad-top-10"></p>
                        <p id="addedManually"></p>
                        <p id="addedReAuth"></p>
                    </div>
                    <div style="margin-top: 10px; position: absolute; text-align: right; width: 508px;">
                        <p id="ssaAuthAutomated"></p>
                    </div>
                </div>
            </div>
        </div>
        <div class="margin-bottom-5">
            <div id="loginActivityWidget" class="panel panel-default widget-inline margin-right-20">
                <div class="panel-heading">
                    <div class="panel-title text-center">
                        <h4>VAP Application User Logins (within 24 hours)</h4>
                    </div>
                </div>
                <div class="panel-body">
                    <div id="loginActivityLoading" >
                        <p class="img-center"><img src="res/ajax-loader_1.gif"/></p>
                    </div>
                    <canvas id="loginChart" width="500" height="300" data-title="VAP Application User Logins (within 24 hours) graph"></canvas>
                </div>
            </div>
            <div id="TransactionHistoryWidget" class="panel panel-default widget-inline">
                <div class="panel-heading text-center">
                    <div class="panel-title">
                        <h4>VAP Application Web Calls (within 24 hours)</h4>
                    </div>
                </div>
                <div class="panel-body">
                    <div id="transactionLoading" >
                        <p class="img-center"><img src="res/ajax-loader_1.gif"/></p>
                    </div>
                    <canvas id="transactionChart" width="500" height="300" data-title="VAP Application Web Calls (within 24 hours) graph"></canvas>
                </div>
            </div>
        </div>
    </div>
</f:mainTemplate>