<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp"%>
<%@taglib tagdir="/WEB-INF/tags/date" prefix="date"%>

<script>
    jQuery(document).ready(function () {
        //Help text for signature block.
        jQuery('#signature').attr("placeholder","First name Last name \nFacility Role \nContact Information");
    });
</script>

<div class="form-container">
    <fieldset>
        <legend>Options</legend>
        <form action="PatientDetails.do_sec" method="POST" enctype="multipart/form-data" onsubmit="return doSubmit(this)">
            <input type="hidden" id="delayCollection" name="delayCollection" value="<c:out value="${delayedConsent.delayReasonCollection}"/>" />
            <div>
                <label for="patientName">Patient</label>
                <input type="hidden" id="patientName">
                <strong>
                    <c:out value="${patientDemographics.firstName}"/> 
                    <c:if test="${!empty patientDemographics.middleName}"><c:out value="${fn:substring(patientDemographics.middleName,0,1)}"/>. </c:if>${patientDemographics.lastName} 
                    <c:out value="${patientDemographics.suffix}"/>
                </strong>
                <br /><br />
            </div>
            <div>
                <label for="authenticatingFacility">
                    Authenticating Facility
                    <img alt="Required field" src="res/star-icon_grey_bg.png" />
                </label>
                <select id="authenticatingFacility" name="authenticatingFacility" style="width: 585px; overflow: auto;">
                    <c:forEach var="f" items="${allowedFacilities}">
                        <option value="<c:out value="${f.facilityStation}"/>"
                            <c:if test="${f.facilityStation eq defaultUserFacility.facilityStation}">
                                selected
                            </c:if>>
                            <c:choose>
                                <c:when test="${f.facilityName != ''}">
                                    <c:out value="${f.facilityName}"/>
                                </c:when>
                                <c:otherwise>
                                    <c:out value="${fn:split(f.facilityDns, '.')[0]}"/>
                                </c:otherwise>
                            </c:choose>
                            (<c:out value="${f.facilityStation}"/>)
                        </option>
                    </c:forEach>
                </select> 
                <br /> <br />
            </div>
            <div>
                <c:if test="${delayedConsent != null}">
                    <input type="hidden" name="type" id="type" value="delayed" />
                    <label for="delayReasons">
                        Delay Reason<c:if test="${fn:length(delayedConsent.delayReasonCollection) > 1}">s</c:if>: 
                    </label>
                    <div style="display:inline-block" id="delays">
                        <c:forEach var="dr" items="${delayedConsent.delayReasonCollection}">
                            <c:out value="${dr.name}"/>&nbsp;<br />
                        </c:forEach>
                    </div>
                </c:if>
                <c:if test="${consent != null}">
                    <c:choose>
                        <c:when test="${consent.optoutDate == null}">
                            <input type="hidden" name="type" id="type" value="expiring"/>
                        </c:when>
                        <c:otherwise>
                            <input type="hidden" name="type" id="type" value="revoked" />
                        </c:otherwise>
                    </c:choose>
                </c:if>
            </div>
            <div>
                <br />
                <label for="signature">
                    Signature
                    <img alt="Required field" src="res/star-icon_grey_bg.png" />
                </label>
                <textarea id="signature" name="signature" onkeyup="enableLetterGenerate('signature');" style="width: 300px; height: 60px;"></textarea>
                <br /><br />
                <label for="markMailed">Mark as mailed</label>
                <input type="checkbox" title="Mark as mailed" name="markMailed" id="markMailed" value="true" style="padding-left: 50em;" /><br/><br/>
            </div>
            <div>
                <center>
                    <input id="Generate" class="button" type="submit" disabled="disabled" value="Generate" name="generateLetter" title="Generate" onclick='closeAndReload();'>
                </center>
            </div>
        </form>
    </fieldset>
</div>