<%--
        Document   : Show the patient correlations from the MPI.
        Author     : Asha Amritraj
--%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp"%>
<table width="100%">
    <c:choose>
        <c:when test="${!empty correlations}">
            <tr role="row">
                <td role="gridcell">
                    <table class="box-table-a">
                        <thead>
                            <tr role="row">
                                <th role="columnheader">Facility Number</th>
                                <th role="columnheader"><c:out value="${organizationName}" /> Organization Name</th>
                                <th role="columnheader"><c:out value="${organizationName}" /> Organization Assigning Authority</th>
                                <th role="columnheader">Patient ID</th>
                            </tr>
                        </thead>
                        <tbody>
                            <c:forEach var="r" items="${correlations}" varStatus="i">
                                <tr role="row">
                                    <td role="gridcell"><c:out value="${r.facilityNumber}" /></td>
                                    <td role="gridcell" title="<c:out value="${r.organizationOid}" />"><c:out value="${r.facilityName}" /></td>
                                        <c:choose>
                                            <c:when test="${empty r.assigningAuthorityName}">
                                                <td title="<c:out value="${r.assigningAuthorityOid}" />"><c:out value="${r.assigningAuthorityOid}" /></td>
                                            </c:when>
                                            <c:otherwise>
                                                <td title="<c:out value="${r.assigningAuthorityOid}" />"><c:out value="${r.assigningAuthorityName}" /></td>
                                            </c:otherwise>
                                        </c:choose>
                                    <td role="gridcell"><c:out value="${r.correlatedPatientId}" /></td>
                                </tr>
                            </c:forEach>
                        </tbody>
                    </table>
                </td>
            </tr>
            <tr role="row">
                <td role="gridcell">
                    <p class="detailText">
                        If a correlation needs to be removed,
                        please contact your local MPI Point of Contact who will work with
                        the national Healthcare Identity Management (HC IdM) Team to
                        complete that action.
                    </p>
                </td>
            </tr>
            <cpp:userInRole role="VAPApplicationTester">
                <tr role="row">
                    <td role="gridcell">
                        <p class="detailText">
                            The Remove Correlation action should only be taken with
                            Supervisory approval and is only used in rare circumstances (such
                            as when a patient has been correlated with an incorrect record at
                            a participating partner). NOTE: The Remove Correlation action
                            will remove <b>all</b> patient correlations other than DoD.
                        </p>
                    </td>
                </tr>
                <tr role="row">
                    <td role="gridcell">
                        <div class="form-container">
                            <form action="PatientDetails.do_sec" method="POST" onsubmit="return doSubmit(this)">
                                <fieldset>
                                    <legend>Remove Correlations</legend>
                                    <div>Remove correlations to <c:out value="${organizationName}" /> partners from VA's Master Patient Index.</div>
                                    <div align="center">
                                        <input title="Remove Correlations" class="button" type="submit" name="revoke" value="Remove Correlations" <c:if test="${empty correlations}">disabled="disabled"</c:if> onclick="revokeClicked = true" />
                                    </div>
                                </fieldset>
                            </form>
                        </div>
                    </td>
                </tr>
            </cpp:userInRole>
        </c:when>
        <c:otherwise>
                <tr role="row">
                    <td role="gridcell">
                        <p class="detailText">This patient has no <c:out value="${organizationName}" /> correlations.</p>
                    </td>
                </tr>
        </c:otherwise>
    </c:choose>
</table>