<%--
        Document   : Show the consent directive history
        Author     : Asha Amritraj
--%>
<%@page import="java.util.Date"%>
<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp"%>

<table class="box-table-a">
    <thead>
        <tr role="row">
            <th role="columnheader">Type of Consent Directive</th>
            <th role="columnheader">Purpose</th>
            <th role="columnheader">Authorization/Revocation</th>
            <th role="columnheader">Entry Date</th>
            <th role="columnheader">Expiration Date</th>
            <th role="columnheader">Inactivation Date</th>
            <th role="columnheader" style="width: 90px;">Mail Date(s)</th>
            <th role="columnheader">Status</th>
            <th role="columnheader">Entered By</th>
            <th role="columnheader">Comments</th>
            <th role="columnheader">
                <c:choose>
                    <c:when test="${isFormUploadAllowed}">Upload/</c:when>
                </c:choose> View Consent Form 
                <c:choose>
                    <c:when test="${isFormUploadAllowed}">
                        <br />
                        <i><span style="font-weight: normal;">(Max file size: <c:out value="${maxFileUploadSize/1000000}" /> megabytes)</span> </i>
                    </c:when>
                </c:choose>
            </th>
        </tr>
    </thead>
    <tbody>
        <c:forEach var="r" items="${consents}" varStatus="i">
            <c:choose>
                <%-- Check if this is a delayed authorization --%>
                <c:when test="${not empty r.delayedConsent}">
                    <tr role="row">
                        <td role="gridcell">
                            Delayed <c:out value="${r.consentDisplayName}" />
                        </td>
                        <td role="gridcell">
                            <c:choose>
                                <c:when test="${r.delayedConsent.consentTypeId.name eq 'SSA Authorization'}">
                                    COVERAGE
                                </c:when>
                                <c:otherwise>
                                    TREATMENT
                                </c:otherwise>
                            </c:choose>
                        </td>
                        <td role="gridcell">
                            <c:choose>
                                <c:when test="${r.delayedConsent.consentTypeId.name eq 'SSA Authorization'}">
                                    Authorized access to Social Security Administration
                                </c:when>
                                <c:when
                                    test="${r.delayedConsent.consentTypeId.name eq 'NwHIN Organization Restriction Authorization'}">
                                    Restricted select Providers and Organizations
                                </c:when>
                                <c:when test="${r.delayedConsent.consentTypeId.name eq 'NwHIN Authorization'}">
                                    Authorized access to Providers and Organizations
                                </c:when>
                            </c:choose>
                        </td>
                        <td role="gridcell"><fmt:formatDate pattern="MM/dd/yyyy" value="${r.delayedConsent.dateAdded}" /></td>
                        <td role="gridcell"></td>
                        <td role="gridcell">
                            <c:if test="${r.delayedConsent.status eq 'CANCELED'}">
                                <fmt:formatDate pattern="MM/dd/yyyy" value="${r.delayedConsent.resolutionDate}" />
                            </c:if>
                        </td>
                        <td role="gridcell">
                            <!-- mail date(s) -->
                            <c:set var="dateCount" value="1" />
                            <c:forEach var="m" items="${r.mailNotifications}" varStatus="i">
                                <fmt:formatDate pattern="MM/dd/yyyy" value="${m.sentDate}" /><br />
                            </c:forEach>
                                <a href="#" class="vap-old-modal" data-title="Edit Mail Notification Dates" 
                                   data-delayed-consent-id="<c:out value="${r.delayedConsent.delayedConsentId}" />" data-consent-type="delayed"
                                   title="Edit notification dates for this delayed authorization">
                                    <i class="fa fa-pencil-square-o fa-lg" aria-hidden="true" style="margin-top: 5px;"></i>
                                </a>
                        </td>
                        <td role="gridcell"><c:out value="${r.delayedConsent.status}" />
                            <c:if test="${r.delayedConsent.status eq 'PENDING'}">
                                -
                                <c:forEach var="v" items="${r.delayedConsent.delayReasonCollection}" varStatus="loop">
                                    <c:out value="${v.name}" /> 
                                    <c:if test="${fn:length(r.delayedConsent.delayReasonCollection) gt 1 and (loop.index lt fn:length(r.delayedConsent.delayReasonCollection) - 1)}">, </c:if>
                                </c:forEach>
                            </c:if>
                        </td>
                        <td role="gridcell">
                            <c:out value="${r.delayedConsent.userId}" />
                        </td>
                        <td role="gridcell">
                            <c:forEach var="c" items="${r.comments}">
                                <c:if test="${c.delayedConsentId == r.delayedConsent.delayedConsentId}">
                                    <p style="white-space: pre-wrap;"><fmt:formatDate pattern="MM/dd/yyyy hh:mm:ss aa" value="${c.dateAdded}"/> CT <b><c:out value="${c.userId}" /></b>: <c:out value="${c.comments}" /></p>
                                </c:if>
                            </c:forEach>
                            <p>
                                <a href="PatientDetails.do_sec?addCommentForm=true&delayedConsentId=<c:out value="${r.delayedConsent.delayedConsentId}" />&consentType=<c:out value="${r.delayedConsent.consentTypeId.name}" />" title="Add Comment"
                                   onclick="if (checkReadyState()) {
                                               Modalbox.show(this.href, {title: this.title, width: 643, height: 180, afterHide: function () {
                                                       window.location.href = window.location.href;
                                                   }});
                                               return false;
                                           } else {
                                               return false;
                                           }">Add Comment</a>
                            </p>
                        </td>
                        <td role="gridcell"></td>
                    </tr>
                </c:when>

                    <%-- Process normal consents --%>
                    <c:otherwise>
                        <c:choose>
                            <%-- Check if this was an opt-out --%>
                            <c:when test="${r.isRevoked}">
                            <tr role="row">
                                <td role="gridcell">
                                    <c:out value="${r.consentDisplayName}" />
                                </td>
                                <td role="gridcell">
                                    <c:out value="${r.normalConsent.purposeOfUse}" />
                                </td>
                                <td role="gridcell">
                                    <c:choose>
                                        <c:when test="${r.normalConsent.optoutConsentType.value eq 'SSA Revocation'}">
                                            Revoked access to Social Security Administration
                                        </c:when>
                                        <c:when test="${r.normalConsent.optoutConsentType.value eq 'NwHIN Organization Restriction Revocation'}">
                                            Revoked restriction to select Providers and Organizations
                                        </c:when>
                                        <c:when test="${r.normalConsent.optoutConsentType.value eq 'NwHIN Revocation'}">
                                            Revoked authorization to all Providers and Organizations
                                        </c:when>
                                    </c:choose>
                                </td>
                                <td role="gridcell">
                                    <fmt:formatDate pattern="MM/dd/yyyy" value="${r.normalConsent.optoutTS}" />
                                </td>
                                <td role="gridcell">&nbsp;</td>
                                <td role="gridcell">&nbsp;</td>
                                <td role="gridcell">
                                    <c:choose>
                                        <c:when test="${r.normalConsent.optoutConsentType.value eq 'NwHIN Revocation'}">
                                            <!-- mail date(s) -->
                                            <c:forEach var="m" items="${r.mailNotifications}" varStatus="i">
                                                <fmt:formatDate pattern="MM/dd/yyyy" value="${m.sentDate}" /><br />
                                            </c:forEach>
                                                <a href="#" class="vap-old-modal" data-title="Edit Mail Notification Dates" 
                                                   data-consent-dir-id="<c:out value="${r.normalConsent.consentDirId}" />" data-consent-type="eHeathExchangeRevocation"
                                                   title="Edit notification dates for this eHealth Exchange Authorization revocation">
                                                    <i class="fa fa-pencil-square-o fa-lg" aria-hidden="true" style="margin-top: 5px;"></i></a>
                                                <a href="PatientDetails.do_sec?printLetter=true&consentId=<c:out value="${r.normalConsent.consentDirId}" />"
                                                    title="Generate notification letter for this eHealth Exchange Authorization revocation"
                                                    onclick="Modalbox.show(this.href, {title: this.title, 
                                                    width:900, height:'auto'}); return false;">
                                                    <i class="fa fa-print fa-lg" aria-hidden="true" style="margin-top: 5px;"></i>
                                                </a>
                                        </c:when>
                                        <c:otherwise>
                                            &nbsp;
                                        </c:otherwise>
                                    </c:choose>
                                </td>
                                <td role="gridcell">&nbsp;</td>
                                <td role="gridcell">
                                    <c:out value="${r.user}" />
                                </td>
                                <td role="gridcell">
                                    <c:forEach var="c" items="${r.comments}">
                                        <c:if test="${c.consentType eq r.normalConsent.optoutConsentType.value}">
                                            <p style="white-space: pre-wrap;"><fmt:formatDate pattern="MM/dd/yyyy hh:mm:ss aa" value="${c.dateAdded}"/> CT <b><c:out value="${c.userId}" /></b>: <c:out value="${c.comments}" /></p>
                                        </c:if>
                                    </c:forEach>
                                    <p>
                                        <a href="PatientDetails.do_sec?addCommentForm=true&consentId=<c:out value="${r.normalConsent.consentDirId}" />&consentType=<c:out value="${r.normalConsent.optoutConsentType.value}" />" title="Add Comment"
                                        onclick="if(checkReadyState()){Modalbox.show(this.href, {title: this.title, width:643, height:180, afterHide: function() {window.location.href = window.location.href; }}); return false;} else {return false;}">Add Comment</a>
                                    </p>
                                </td>
                                <td role="gridcell">
                                    <c:choose>
                                        <c:when test="${r.normalConsent.optoutReason.value eq 'Revoked'}">
                                            <c:choose>
                                                <c:when test="${r.optOutDocumentAttachment}">
                                                    <c:url var="url" value="PatientDetails.do_sec">
                                                        <c:param name="history" value="true" />
                                                        <c:param name="documentType" value="Revoke" />
                                                        <c:param name="consentDirId" value="${r.normalConsent.consentDirId}" />
                                                    </c:url>
                                                    <a href="<c:out value="${url}" />">View/Print</a>
                                                </c:when>
                                                <c:otherwise>
                                                    <c:choose>
                                                        <c:when test="${isFormUploadAllowed}">
                                                            <form name="upload" action="PatientDetails.do_sec" method="POST" onsubmit="return doSubmit(this)" enctype="multipart/form-data">
                                                                <input type="hidden" name="consentDirId" value="<c:out value="${r.normalConsent.consentDirId}"/>" /> 
                                                                <input type="hidden" name="documentType" value="Revoke" /> 
                                                                <label for="file"></label> 
                                                                <input title="Browse and Upload Consent Form" name="uploaded" type="file" size="6" id="file" accept="application/pdf" />&nbsp; 
                                                                <input title="Upload revocation form" class="button" type="submit" value="Upload" name="upload" />
                                                            </form>
                                                        </c:when>
                                                    </c:choose>
                                                </c:otherwise>
                                            </c:choose>
                                        </c:when>
                                    </c:choose>
                                </td>
                            </tr>
                        </c:when>  
                            
                        <%-- Otherwise this was an opt-in --%>
                        <c:otherwise>
                            <tr role="row">
                                <td role="gridcell">
                                    <c:out value="${r.consentDisplayName}" />
                                </td>
                                <td role="gridcell">
                                    <c:out value="${r.normalConsent.purposeOfUse}" />
                                </td>
                                <td role="gridcell">
                                    <c:choose>
                                        <c:when test="${r.normalConsent.optinConsentType.value eq 'SSA Authorization'}">
                                            Authorized access to Social Security Administration
                                        </c:when>
                                        <c:when test="${r.normalConsent.optinConsentType.value eq 'NwHIN Organization Restriction Authorization'}">
                                            Restricted select Providers and Organizations
                                        </c:when>
                                        <c:when test="${r.normalConsent.optinConsentType.value eq 'NwHIN Authorization'}">
                                            Authorized access to Providers and Organizations
                                        </c:when>
                                    </c:choose>
                                </td>
                                <td role="gridcell">
                                    <fmt:formatDate pattern="MM/dd/yyyy" value="${r.normalConsent.optinTS}" />
                                </td>
                                <td role="gridcell">
                                    <fmt:formatDate pattern="MM/dd/yyyy" value="${r.normalConsent.expirationDate}" />
                                </td>
                                <td role="gridcell">
                                    <c:if test="${!empty r.normalConsent.optoutTS}">
                                        <fmt:formatDate pattern="MM/dd/yyyy" value="${r.normalConsent.optoutTS}" />
                                    </c:if>
                                </td>
                                <td role="gridcell">
                                    <c:choose>
                                        <c:when test="${empty r.normalConsent.optoutTS and r.normalConsent.optinConsentType.value != 'NwHIN Organization Restriction Authorization'}">
                                            <!-- mail date(s) -->
                                            <c:forEach var="m" items="${r.mailNotifications}" varStatus="i">
                                                <fmt:formatDate pattern="MM/dd/yyyy" value="${m.sentDate}" /><br />
                                            </c:forEach>
                                                <a href="#" class="vap-old-modal" data-title="Edit Mail Notification Dates" 
                                                   data-consent-dir-id="<c:out value="${r.normalConsent.consentDirId}" />" data-consent-type="<c:out value="${r.normalConsent.optinConsentType}" />"
                                                   title="Edit notification dates for this expiring authorization">
                                                    <i class="fa fa-pencil-square-o fa-lg" aria-hidden="true" style="margin-top: 5px;"></i></a>
                                                <a href="PatientDetails.do_sec?printLetter=true&consentId=<c:out value="${r.normalConsent.consentDirId}" />"
                                                    title="Generate notification letter for this expiring authorization"
                                                    onclick="Modalbox.show(this.href, {title: this.title, 
                                                    width:900, height:'auto'}); return false;">
                                                    <i class="fa fa-print fa-lg" aria-hidden="true" style="margin-top: 5px;"></i>
                                                </a>
                                        </c:when>
                                        <c:otherwise>
                                            &nbsp;
                                        </c:otherwise>
                                    </c:choose>    
                                </td>
                                <td role="gridcell">
                                    <c:choose>
                                        <c:when test="${!empty r.normalConsent.optoutTS}">
                                            INACTIVE - <c:out value="${r.normalConsent.optoutReason.value}" />
                                        </c:when>
                                        <c:otherwise>
                                            <c:choose>
                                                <c:when test="${r.normalConsent.optinConsentType.value eq 'NwHIN Organization Restriction Authorization'}">
                                                    <c:choose>									
                                                        <c:when test="${empty r.normalConsent.optoutTS}">
                                                            ACTIVE
                                                        </c:when>
                                                        <c:otherwise>
                                                            INACTIVE
                                                        </c:otherwise>
                                                    </c:choose>
                                                </c:when>
                                                <c:otherwise>
                                                    <fmt:formatDate pattern="yyyyMMdd" value="${r.normalConsent.expirationDate}" var="expireDate" />
                                                    <jsp:useBean id="dateValue" class="java.util.Date"/>
                                                    <fmt:formatDate pattern="yyyyMMdd" value="${dateValue}" var="todayDate" />
                                                    <c:choose>
                                                        <c:when test="${expireDate lt todayDate}">
                                                            INACTIVE - Authorization Expired
                                                        </c:when>
                                                        <c:otherwise>
                                                            ACTIVE
                                                        </c:otherwise>
                                                    </c:choose>
                                                </c:otherwise>
                                            </c:choose>
                                        </c:otherwise>
                                    </c:choose>
                                </td>
                                <td role="gridcell">
                                    <c:out value="${r.user}" />
                                </td>
                                <td role="gridcell">
                                    <c:forEach var="c" items="${r.comments}">
                                        <c:if test="${c.consentType eq r.normalConsent.optinConsentType.value || (c.consentType eq 'NwHIN Revocation' && fn:length(r.normalConsent.optoutConsentType.value) == 0) || (c.consentType eq 'SSA Revocation' && fn:length(r.normalConsent.optoutConsentType.value) == 0)}"><%-- added the second check because on a revoke because of new auth, the comment is tied to the new auth but set as NwHIN Revoation in the CONSENT_COMMENT table --%>
                                            <p style="white-space: pre-wrap;"><fmt:formatDate pattern="MM/dd/yyyy hh:mm:ss aa" value="${c.dateAdded}"/> CT <b><c:out value="${c.userId}" /></b>: <c:out value="${c.comments}" /></p>
                                        </c:if>
                                    </c:forEach>
                                    <p>
                                        <a href="PatientDetails.do_sec?addCommentForm=true&consentId=<c:out value="${r.normalConsent.consentDirId}" />&consentType=<c:out value="${r.normalConsent.optinConsentType.value}" />" title="Add Comment"
                                           onclick="if (checkReadyState()) {
                                                       Modalbox.show(this.href, {title: this.title, width: 643, height: 180, afterHide: function () {
                                                               window.location.href = window.location.href; }});
                                                       return false;} else {
                                                       return false;
                                                   }">Add Comment</a>
                                    </p>
                                </td>
                                <td role="gridcell">
                                    <c:choose>
                                        <c:when test="${r.optInDocumentAttachment}">
                                            <c:url var="url" value="PatientDetails.do_sec">
                                                <c:param name="history" value="true" />
                                                <c:param name="documentType" value="Authorize" />
                                                <c:param name="consentDirId" value="${r.normalConsent.consentDirId}" />
                                            </c:url>
                                            <a href="<c:out value="${url}" />">View/Print</a>
                                        </c:when>   
                                        <c:otherwise>
                                            <c:choose>
                                                <c:when test="${isFormUploadAllowed}">
                                                    <form name="upload" action="PatientDetails.do_sec" method="POST" onsubmit="return doSubmit(this)" enctype="multipart/form-data">
                                                        <input type="hidden" name="consentDirId" value="<c:out value="${r.normalConsent.consentDirId}" />" /> 
                                                        <input type="hidden" name="documentType" value="Authorize" /> 
                                                        <label for="file"></label>
                                                        <input title="Browse and Upload Consent Form" name="uploaded" type="file" size="6" id="file" accept="application/pdf" />&nbsp;
                                                        <input class="button" type="SUBMIT" value="Upload" name="upload" title="Upload Authorization form" />
                                                    </form>
                                                </c:when>
                                            </c:choose>
                                        </c:otherwise>
                                    </c:choose>
                                </td>
                            </tr>
                        </c:otherwise>
                    </c:choose>
                </c:otherwise>   
            </c:choose>
	</c:forEach>
    </tbody>
</table>