<%--
    Document   : Patient Discovery Report
    Created By : David Vasquez / Robert Snelling
    Modified By: Asha Amritraj
--%>

<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@taglib tagdir="/WEB-INF/tags/paginator" prefix="pg"%>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp"%>

<f:mainTemplate headerText="Batch Announcements Search Results">
    <script type="text/javascript">
        function checkAll()
        {
            var master = document.getElementsByName("master");
            var batchIds = document.getElementsByName("batchId");

            if (master[0].checked == true)
            {
                for (var i = 0; i < batchIds.length; i++)
                {
                    batchIds[i].checked = true;
                }
            } else
            {
                for (var i = 0; i < batchIds.length; i++)
                {
                    batchIds[i].checked = false;
                }
            }
        }
    </script>
    <cpp:errors />
    <div>
        <table class="ver-minimalist">
            <tbody>
                <tr>
                    <td>Start Date</td>
                    <td>
                        <c:choose>
                            <c:when test="${!empty batchManagerQueryStartDate}">
                                <fmt:formatDate pattern="MM/dd/yyyy" value="${batchManagerQueryStartDate}" />
                            </c:when>
                            <c:otherwise>
                                N/A
                            </c:otherwise>
                        </c:choose>
                    </td>
                    <td>End Date</td>
                    <td>
                        <c:choose>
                            <c:when test="${!empty batchManagerQueryEndDate}">
                                <fmt:formatDate pattern="MM/dd/yyyy" value="${batchManagerQueryEndDate}" />
                            </c:when>
                            <c:otherwise>
                                N/A
                            </c:otherwise>
                        </c:choose>
                    </td>
                </tr>
            </tbody>
        </table>
        <c:choose>
            <c:when test="${!empty batchManagerResults}">
                <br />
                <pg:paginator paginator="${paginator}" uri="BatchManagerResults.do_sec" results="${batchManagerResults}" />
                <form name="manageBatchSelectForm" id="manageBatchSelectForm" action="BatchManagerResults.do_sec" method="POST" onsubmit="return doSubmit(this)">
                    <table class="hor-minimalist-b">
                        <thead>
                            <tr>
                                <th scope="col"><input type="checkbox" name="master" onClick="checkAll();" title="checkbox that allows to Check all"/></th>
                                <th scope="col">Organization Name</th>
                                <th scope="col">Date Created (CT)</th>
                                <th scope="col">Scheduled</th>
                                <th scope="col">Completed</th>
                                <th scope="col">Batch Size</th>
                            </tr>
                        </thead>
                        <tbody>
                            <pg:forEach var="r" items="${batchManagerResults}" varStatus="i" paginator="${paginator}">
                                <tr>
                                    <td><input type="checkbox" name="batchId" value="<c:out value="${r.batchId}" />" title="Check to choose Organizations" /></td>
                                    <td><c:out value="${r.targetOrganizationName}" /></td>
                                    <td><fmt:formatDate pattern="MM/dd/yyyy hh:mm a" value="${r.createdDate}" /></td>
                                    <td><c:out value="${r.numberScheduled}" /></td>
                                    <td><c:out value="${r.numberCompleted}" /></td>
                                    <td><c:out value="${r.batchSize}" /></td>
                                </tr>
                            </pg:forEach>
                        </tbody>
                    </table>
                    <div align="center" class="pad-bottom-20">
                        <input title="Delete" class="button" type="submit" value="Delete" name="delete" />&nbsp;
                        <input title="Refresh" type="button" value="Refresh" onClick="window.location.reload()" />
                    </div>
                </form>

                <pg:paginator paginator="${paginator}" uri="BatchManagerResults.do_sec" results="${batchManagerResults}" />
            </c:when>
            <c:otherwise>
                No records were found.
            </c:otherwise>
        </c:choose>
    </div>
</f:mainTemplate>