<%--
    Document   : Patient Discovery Report
    Created By : David Vasquez / Robert Snelling
    Modified By: Asha Amritraj
--%>
<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib tagdir="/WEB-INF/tags/date" prefix="date"%>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp"%>

<f:mainTemplate headerText="Manage Batches">
    <script language="JavaScript">
        $(document).ready(function () {
            //initial data table setup and call for the first recordset
            $.fn.dataTable.ext.errMode = 'none';

            setProcessingForDataTable('tblReport');

            var reportTable = $('#tblReport').DataTable({
                destroy: true,
                searching: false,
                processing: true,
                serverSide: true,
                order: [[2, 'desc']],
                columnDefs: [
                    {orderable: false, targets: [0,1,2,3,4,5,6]},
                    {className: "dt-head-center", targets: [1,2]},
                    {className: "dt-body-center dt-head-center", targets: [0,6]},
                    {className: "dt-body-right dt-head-center", targets: [3,4,5]}
                ],
                ajax: "BatchManagerQuery.do_sec?doSearch=true",
                language: {
                    emptyTable: "No records found",
                    loadingRecords: ""
                },
                scrollX:true,
                initComplete: function(){
                    // Enable THEAD scroll bars
                    $('.dataTables_scrollHead').css('overflow', 'auto');

                    // Sync THEAD scrolling with TBODY
                    $('.dataTables_scrollHead').on('scroll', function () {
                        $('.dataTables_scrollBody').scrollLeft($(this).scrollLeft());
                    });
                },
                lengthMenu: [ 10, 25, 50, 100, 250, 500 ],
                pageLength: 25
            });

            reportTable.on('draw', function () {
                addAriaToDataTable('tblReport', reportTable);
            });

            $("#master").change(function(){
                var status = $(this).is(":checked") ? true : false;
                $(".chk").prop("checked",status);
            });

            $("#startDate").datepicker({
                maxDate: 0,
                dateFormat: 'mm/dd/yy',
                onClose: function (selectedDate) {
                    $("#endDate").datepicker("option", "minDate", selectedDate);
                }
            });

            $("#endDate").datepicker({
                maxDate: 0,
                dateFormat: 'mm/dd/yy',
                onClose: function (selectedDate) {
                    $("#startDate").datepicker("option", "maxDate", selectedDate);
                }
            });

            //when the search button is pressed this function is used
            $('#btnSearch').on('click', function () {
                var remoteOrganization = $('#remoteOrganization').val();
                var startDate = $('#startDate').val();
                var endDate = $('#endDate').val();

                var errorMessage = validateStartAndEndDate(startDate, endDate);

                if (errorMessage != '')
                {
                    //we have an error so show the error, and then don't send the ajax request
                    $('#errorMessage').html(errorMessage);
                    $('#errorMessage').show();

                    return false;
                } else {
                    //no error, let's make the call to populate the report
                    reportTable.ajax.url("BatchManagerQuery.do_sec?doSearch=true&remoteOrganization=" + remoteOrganization + "&startDate=" + startDate + "&endDate=" + endDate).load();
                }
            });

            $('#startDate,#endDate').on('change', function () {
                //if either date changes, hide the error message if its not already hidden
                $('#errorMessage').hide();
            });

            $(document).on('click', '.batchDetail', function (event) {
                var url = 'BatchManagerQuery.do_sec?getDetailView=true&batchId=' + $(this).data("batch-id") + '&orgId=' + $(this).data("org-id");

                var $dialog = $('<div></div>')
                    .load(url)
                    .dialog({
                        autoOpen: false,
                        title: 'Batch Announce Details',
                        width: 600,
                        height: 400,
                        modal: true,
                        buttons: [
                            {
                                text: "Close",
                                click: function() {
                                    var oTable = $('#tblBatchAnnounceDetailReport').dataTable();
                                    oTable.fnDestroy();
                                    $(this).dialog('destroy').remove();
                                }
                            }
                        ],
                        close: function(e, i) {
                            //At closing of modal destroy data table and the modal as well
                            var oTable = $('#tblBatchAnnounceDetailReport').dataTable();
                            oTable.fnDestroy();
                            $(this).dialog('destroy').remove();
                        }
                    });

                $dialog.dialog('open');

                return false;
            });
        });
    </script>
    <div class="well">
        Fill in the fields below to narrow your search. All dates will be included if Start Date and End Date are left blank.
    </div>
    <div class="form-container pad-bottom-20">
        <form name="batchAnnounceForm">
            <fieldset>
                <legend>Search Details</legend>
                <div id="errorMessage" class="bg-warning pad-15" style="display: none;"></div>
                <div class="width-450 pad-top-10">
                    <div id="startDateTip" data-tooltip="<c:out value="${descriptors['manageBatchesStartDateField']}"/>">
                        <label for="startDate">Start Date</label>
                        <date:date id="startDate" name="startDate" /> <i>mm/dd/yyyy</i>
                    </div>
                    <div id="endDateTip" data-tooltip="<c:out value="${descriptors['manageBatchesEndDateField']}"/>">
                        <label for="endDate">End Date</label>
                        <date:date id="endDate" name="endDate" /> <i>mm/dd/yyyy</i>
                    </div>
                </div>
                <div>
                    <label title="Query based on <c:out value="${organizationName}" /> Organization from the dropdown list" for="remoteOrganization"><c:out value="${organizationName}" /> Organization</label>
                    <select id="remoteOrganization" name="remoteOrganization" data-tooltip="<c:out value="${descriptors['manageBatchesEHealthOrganizationsField']}"/>">
                        <option value="">ALL</option>
                        <c:forEach var="r" items="${organizations}">
                            <option value="<c:out value="${r.orgOid}" />"><c:out value="${r.orgName}" /></option>
                        </c:forEach>
                    </select>
                </div>
            </fieldset>
            <div>
                <input name="btnSearch" id="btnSearch" title="Search" class="button" type="button" value="Search" />
            </div>
        </form>
    </div>
    <div id="divReportContent">
        <table id="tblReport" class="display" width="100%" cellspacing="0" role="presentation">
            <thead>
                <tr role="row">
                    <th role="columnheader"><input type="checkbox" name="master" id="master" title="Checkbox that allows to Check all (one or many can be checked below)"/></th>
                    <th role="columnheader" style="min-width: 140px;">Organization Name</th>
                    <th role="columnheader" style="min-width: 120px;">Date Created (CT)</th>
                    <th role="columnheader">Scheduled</th>
                    <th role="columnheader">Completed</th>
                    <th role="columnheader">Batch Size</th>
                    <th role="columnheader">Action</th>
                </tr>
            </thead>
        </table>
    </div>
    <div class="pad-top-10">
        <form name="manageBatchSelectForm" id="manageBatchSelectForm" action="BatchManagerResults.do_sec" method="POST" onsubmit="return doSubmit(this)">
            <input title="Delete" class="button" type="submit" value="Delete" name="delete" />
        </form>
    </div>
</f:mainTemplate>