<%-- 
    Document   : batchAnnounceDetail
    Created on : Nov 21, 2016, 2:59:51 PM
    Author     : Johann Sonnenberg
--%>

<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<script language="JavaScript">
    $(document).ready(function () {
        //initial data table setup and call for the first recordset
        $.fn.dataTable.ext.errMode = 'none';

        setProcessingForDataTable('tblBatchAnnounceDetailReport');
        
        var reportDetailTable = $('#tblBatchAnnounceDetailReport').DataTable({
            destroy: true,
            searching: false,
            processing: true,
            serverSide: true,
            dom: 'liptipr',
            columnDefs: [
                { 
                    "orderable": false, 
                    "targets": [ 0, 1, 2, 3 ]
                }
            ],
            ajax: "BatchManagerQuery.do_sec?getDetail=true&batchId=<c:out value="${batchId}" />&orgId=<c:out value="${orgId}" />", 
            language: {
                emptyTable: "No records found",
                loadingRecords: ""
            },
            lengthMenu: [ 10, 25, 50, 100, 250, 500 ],
            pageLength: 25
        });
        
        reportDetailTable.on('draw', function () {
            addAriaToDataTable('tblBatchAnnounceDetailReport', reportDetailTable);
        });
    });
</script>
<div class="pad-bottom-10">
    Announcement Date: <fmt:formatDate pattern="MM/dd/yyyy hh:mm:ss a" value="${announcedDate}" /> <br />
    Announced To: <c:out value="${announcedToOrg}" />
</div>
<div id="divDetailReportContent">
    <table id="tblBatchAnnounceDetailReport" class="display" width="100%" cellspacing="0" role="presentation">
        <thead>
            <tr role="row">
                <th role="columnheader">Patient IEN</th>
                <th role="columnheader">SSN</th>
                <th role="columnheader">Last Name</th>
                <th role="columnheader">First Name</th>
            </tr>
        </thead>
    </table>
</div>
