<%--
    Document   : Consent Directive Batch Announce
    Created By : Stephen Schrank
--%>

<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp"%>
<%@taglib tagdir="/WEB-INF/tags/date" prefix="date"%>

<f:mainTemplate headerText="Batch Announce Patients">
    <script type="text/javascript" src="js/OptionTransfer.js"></script>
    <script language="JavaScript">
        var opt = new OptionTransfer("list1","list2");
        opt.setAutoSort(true);
        opt.setDelimiter(",");
        opt.saveNewLeftOptions("newLeft");
        opt.saveNewRightOptions("remoteOrganization");
    </script>
    <c:choose>
        <c:when test="${flow == 'result'}">
            <script type="text/javascript">
                var bReady = false;
                window.onbeforeunload = confirmExit;
                function confirmExit(){
                    if (!bReady){
                        alert("Please press \"Continue\" or \"Cancel\" to exit this page.");
                        if(navigator.appName.indexOf('Microsoft Internet Explorer') != -1) {
                            window.setTimeout(function(){
                                document.execCommand('Stop');
                            }, 1);
                        } else {
                            window.setTimeout(function(){
                                window.stop();
                            }, 1);
                        }
                    }
                }

                function makeReady(){
                    bReady = true;
                }
            </script>
        </c:when>
    </c:choose>
    <script>
        $(document).ready(function() {
            <c:choose>
                <c:when test="${flow != 'result'}">
                    opt.init(document.batchAnnounceForm);
                    setFocus(batchAnnounceForm.list1);
                </c:when>
            </c:choose>
        });
    </script>

    <cpp:errors /> <!-- END: SITE NAME BAR -->
    <c:choose>
        <c:when test="${flow == 'result'}">
            <%-- <%@include file="batchAnnounceQueryResult.jspf"%> --%>
            <div class="message">
                <b>
                    <c:choose>
                        <c:when test="${outcome} == 'success'">
                            Batch Announce message has been enqueued.
                        </c:when>
                        <c:when test="${outcome} == 'failed'">
                            Batch Announce message enqueue failed.
                        </c:when>
                        <c:otherwise>
                            &nbsp;
                        </c:otherwise>
                    </c:choose>
                </b>
            </div>
            <div class="form-container">
                <form name="batchAnnounceForm"  action="BatchAnnounce.do_sec" method="POST" onsubmit="makeReady(); return doSubmit(this)" >
                    <fieldset>
                    <legend>Batch Announce Query Results</legend>
                    <table width="100%" class="results">
                        <thead class="results">
                            <tr role="row">
                                <th width="50%" class="results" role="columnheader">Organization Name</th>
                                <th width="50%" class="results" align="right" role="columnheader">Patient Count</th>
                            </tr>
                        </thead>
                        <tbody class="results">
                        <c:choose>
                            <c:when test="${empty errorMessage}">
                                <c:forEach var="r" items="${batchSummary}">
                                    <tr role="row">
                                        <td class="results" role="gridcell"><c:out value="${r.targetOrganizationName}" /></td>
                                        <td class="results" align="right" role="gridcell"><c:out value="${r.batchSize}" /></td>
                                    </tr>
                                </c:forEach>
                            </c:when>
                            <c:otherwise>
                                <tr role="row">
                                    <td role="gridcell" colspan="2"><c:out value="${errorMessage}" /></td>
                                </tr>
                            </c:otherwise>
                        </c:choose>
                        </tbody>
                        <tfoot class="results">
                            <tr role="row">
                                <td role="gridcell"></td>
                                <td role="gridcell"></td>
                            </tr>
                        </tfoot>
                    </table>
                    </fieldset>
                    <div>
                        <c:choose>
                            <c:when test="${!empty batchSummary}">
                                <input name="accept" title="Continue" class="button" type="submit"
                                    value="Continue" />
                            </c:when>
                            <c:otherwise>
                                <input name="accept" title="Continue "disabled="disabled" class="button" type="submit"
                                    value="Continue" />
                            </c:otherwise>
                        </c:choose>
                        <input name="cancel" title="Cancel" class="button" type="submit"
                            value="Cancel" />
                    </div>
                </form>
            </div>
        </c:when>
        <c:otherwise>
            <%-- <%@include file="batchAnnounceQuery.jspf"%> --%>
            <script language="JavaScript">
                $(document).ready(function () {
                    $("#startDate").datepicker({
                        maxDate: 0,
                        dateFormat: 'mm/dd/yy',
                        onClose: function (selectedDate) {
                            $("#endDate").datepicker("option", "minDate", selectedDate);
                        }
                    });

                    $("#endDate").datepicker({
                        maxDate: 0,
                        dateFormat: 'mm/dd/yy',
                        onClose: function (selectedDate) {
                            $("#startDate").datepicker("option", "maxDate", selectedDate);
                        }
                    });

                    $('#startDate,#endDate,#fileName').on('change', function () {
                        //if either date changes or ssn, hide the error message if its not already hidden
                        $('#errorMessage').hide();
                    });
                    $('.moveButtons').on('click', function () {
                        //if any one of the "move" buttons are clicked, that means a change has happened in the multi select boxes so hid the error message
                        $('#errorMessage').hide();
                    });
                });

                function clearSelectedFile() {
                    $("#fileCont").innerHTML = $("#fileCont").innerHTML;
                    $("#clear").style.display = "none";
                }

                function isFormValid() {
                    if (document.getElementsByName("list2")[0].children.length === 0) {
                        $('#errorMessage').html("Please select at least one organization.");
                        $('#errorMessage').show();

                        return false;
                    }
                    if ($("#bat1").is(':checked')) {
                        //validate dates
                        var startDate = $('#startDate').val();
                        var endDate = $('#endDate').val();

                        var errorMessage = validateStartAndEndDate(startDate, endDate);

                        if (errorMessage != '')
                        {
                            //we have an error so show the error, and then don't send the ajax request
                            $('#errorMessage').html(errorMessage);
                            $('#errorMessage').show();

                            return false;
                        } else {
                            return true;
                        }
                    } else {
                        // Batch announcing using an uploaded file
                        if ($("#fileName").value === "") {
                            $('#errorMessage').html("Please select a file to upload.");
                            $('#errorMessage').show();

                            return false;
                        }
                    }
                    return true;
                }

                function onBatchAnnounceTypeChange(rb) {
                    document.getElementById("startDate").disabled = rb.value === "2";
                    document.getElementById("endDate").disabled = rb.value === "2";
                    document.getElementById("reannounce").disabled = rb.value === "2";
                    document.getElementById("fileName").disabled = rb.value === "1";
                    document.getElementById("clear").disabled = rb.value === "1";
                }

                function validateFileExt(fileName) {
                    var validExts = new Array(".xlsx", ".xls", ".csv");
                    var fileExt = fileName.substring(fileName.lastIndexOf('.')).toLowerCase();
                    if (validExts.indexOf(fileExt) < 0) {
                        $('#errorMessage').html("You selected an invalid file. Please select an Excel or CSV file");
                        $('#errorMessage').show();

                        clearSelectedFile();
                    } else {
                        $("#clear").style.display = "table-cell";
                    }
                }
            </script>

            <div class="message">
                <b>
                    <c:choose>
                        <c:when test="${outcome} == 'success'">
                            Batch Announce message has been enqueued.
                        </c:when>
                        <c:when test="${outcome} == 'failed'">
                            Batch Announce message enqueue failed.
                        </c:when>
                        <c:otherwise>
                            &nbsp;
                        </c:otherwise>
                    </c:choose>
                </b>
            </div>
            <div class="well">
                <p>Select one or more organizations to send the announcements to.</p>
                <p>
                    The <i>Start Date</i> and <i>End Date</i> are based on the date that the patient opted in or out.
                    If only <i>Start Date</i> is entered, patients opting in or out on or after the date entered will be announced.
                    If only <i>End Date</i> is entered, patients opting in or out prior to and including the date entered will be announced.
                    If <i>Start Date</i> and <i>End Date</i> are left blank, all patients will be considered for announcements.
                </p>
                <p>If the <i>Re-announce</i> check box is selected, patients that have previously been announced to a selected organization will be announced again.</p>
            </div>
            <div class="form-container">
                <form name="batchAnnounceForm" id="batchAnnounceForm" action="BatchAnnounce.do_sec" method="POST" enctype="multipart/form-data" onsubmit="return isFormValid(this);">
                    <input type="hidden" name="newLeft" value="" />
                    <input type="hidden" name="remoteOrganization" value="" />
                    <fieldset>
                        <legend>Batch Announce Criteria</legend>
                        <div id="errorMessage" class="bg-warning pad-15" style="display: none;"></div>
                        <div id="multiSelectAuthorizeForm" class="pad-top-10">
                            <table>
                                <tr>
                                    <td>
                                        <label>
                                            <span style="display:none;">"This table has two list boxes:All Organizations list box and Organizations to whom you want to announce patients list box. Choose and move the Organizations from the first list box to the next."</span>
                                        </label> <br/>
                                    </td>
                                    <td>&nbsp;&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="list1">All Organizations</label><br/><br/>
                                        <select title="All Organizations list box" style="width: 310px;" class="listSelect" name="list1" id="list1" multiple="true" size="10" onDblClick="opt.transferRight()" data-tooltip="<c:out value="${descriptors['batchAnnouncePatientsAllOrganizationsField']}" />">
                                            <c:if test="${!empty organizations}">
                                                <c:forEach var="r" items="${organizations}" varStatus="i">
                                                    <option value="<c:out value="${r.orgOid}" />"><c:out value="${r.orgName}" />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>
                                                </c:forEach>
                                            </c:if>
                                        </select>
                                    </td>
                                    <td valign="middle" align="left">
                                        <input style="width: 125px; height: 30px;" type="button" data-tooltip="<c:out value="${descriptors['batchAnnounceMoveAll']}" />" class="midButton moveButtons" name="right" value="Move All &gt;&gt;" onclick="opt.transferAllRight()" /><br />
                                        <input type="button" data-tooltip="<c:out value="${descriptors['batchAnnounceMoveSelectedRight']}" />" class="midButton moveButtons" style="width: 125px; height: 30px;" name="right" value="Move Selected &gt;" onclick="opt.transferRight()" /><br /><br />
                                        <input type="button" data-tooltip="<c:out value="${descriptors['batchAnnounceMoveSelectedLeft']}" />" class="midButtonLeft moveButtons" style="width: 125px; height: 30px;" name="left" value="&lt; Move Selected" onclick="opt.transferLeft()" /><br />
                                        <input type="button" data-tooltip="<c:out value="${descriptors['batchAnnounceClear']}" />" class="midButton moveButtons" name="left" style="width: 125px; height: 30px;" value="Clear" onclick="opt.transferAllLeft()">
                                    </td>
                                    <td>
                                        <label for="list2">Organizations to whom you want to announce patients.</label><br/><br/>
                                        <select title="Organizations to whom you want to announce patients list box" name="list2" class="listSelect" multiple="true" size="10" id="list2" style="width: 310px;" onDblClick="opt.transferLeft()" data-tooltip="<c:out value="${descriptors['batchAnnouncePatientsOrganizationsToAnnounceToField']}" />"></select>
                                    </td>
                                </tr>
                            </table>
                        </div>
                        <div id="tipBatchOptedIn" class="width-350" data-tooltip="<c:out value="${descriptors['batchAnnouncePatientsOptedInField']}" />">
                            <div style="display:table-cell;">
                                <input type="radio" aria-labelledby="radioLabel" id="bat1" name="batchAnnounceType" value="1" title="Batch announce patients that are opted-in" style="margin-top: 20px;" onclick="onBatchAnnounceTypeChange(this);" checked>
                            </div>
                            <div style="display:table-cell;">
                                <label name="radioLabel" id="radioLabel"for="bat1" style="font-weight: normal; white-space: nowrap;">Batch announce patients that have opted-in</label>
                            </div>
                        </div>
                        <div class="width-350" id="dateTip" data-tooltip="<c:out value="${descriptors['startDateEndDateField']}" />">
                            <div>
                                <label for="startDate" class="width-100">Start Date</label>
                                <date:date id="startDate" name="startDate" value="${startDate}"/> <i>mm/dd/yyyy</i>
                            </div>
                            <div>
                                <label for="endDate" class="width-100">End Date</label>
                                <date:date id="endDate" name="endDate" value="${endDate}"/> <i>mm/dd/yyyy</i>
                            </div>
                        </div>
                            <div id="tipReannounce" class="width-200" data-tooltip="<c:out value="${descriptors['reAnnounceCheckbox']}" />">
                                <label for="reannounce" class="width-100">Re-announce</label>
                            <input id="reannounce" type="checkbox" name="reannounce" value="reannounce" <c:if test="${reannounce}">checked="true" </c:if> title="Check to Reannounce"/>
                        </div>
                        <div id="tipBatchCSV" class="width-350" data-tooltip="<c:out value="${descriptors['batchAnnouncePatientsInExcelOrCSVFileField']}" />">
                            <div style="display:table-cell;">
                                <input type="radio" aria-labelledby="radioLabel" id="bat2" name="batchAnnounceType" value="2" title="Batch announce patients listed in an Excel or CSV file" style="margin-top: 20px;" onclick="onBatchAnnounceTypeChange(this);">
                            </div>
                            <div style="display:table-cell;">
                                <label for="bat2" style="font-weight: normal; white-space: nowrap;">Batch announce patients listed in an Excel or CSV file</label>
                            </div>
                        </div>
                        <div>
                            <label for="fileName" class="width-100">File Name</label>
                            <div id="fileCont" style="display:table-row;">
                                <input type="file" id="fileName" name="fileName" accept=".xlsx,.xls,.csv" size="60" style="display:table-cell;" disabled="true" onchange="validateFileExt(this.value);" data-tooltip="<c:out value="${descriptors['batchAnnouncePatientsFileNameField']}" />" />
                                <input type="button" id="clear" name="clear" title="Clear" title="Clear selected file" style="display:none" onclick="clearSelectedFile();" value="Clear"/>
                            </div>
                        </div>
                    </fieldset>
                    <div>
                        <input name="query" title="Query" title="Query for the announcements" class="button" type="submit" value="Query"/>
                    </div>
                </form>
            </div>
        </c:otherwise>
    </c:choose>
</f:mainTemplate>