<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp"%>
<%@taglib tagdir="/WEB-INF/tags/date" prefix="date"%>

<div>
    <p class="detailNotice">
        By completing the 10-5345 SSA Authorization 
        form, the Veteran is authorizing VA to share his/her health information 
        for coverage purposes with the Social Security Administration (SSA) via 
        <c:out value="${organizationName}"/> for disability determination.  The authorization will 
        remain in effect for the period of two years from the date of Veteran's signature.
    </p>
</div>

<div class="form-container">
    <fieldset>
        <legend>Authorize</legend>
        <form name="multiSelectListForm" id="multiSelectListForm" action="PatientDetails.do_sec" method="POST" enctype="multipart/form-data" onsubmit="return doSubmit(this)">
            <input type="radio" name="consentGroup" id ="consentGroup" value="authorizeAll" onClick="formHide('multiSelectAuthorizeForm')" checked />
            <label for="consentGroup" style="text-align: left; width: auto; margin-right: 0px; padding-right: 0px; float: none; display: inline;">Authorized: </label>
            The Veteran authorizes the sharing of your electronic health information with 
            SSA via <c:out value="${organizationName}"/> for coverage purposes. The VA will immediately 
            share Veteran electronic health information. 
            <br /> <br /> <br />
            <input type="hidden" name="icn" value="<c:out value="${patientDemographics.icn}"/>" /> 
            <input type="hidden" name="requestId" value="<c:out value="${requestId}"/>" /> 
            <input type="hidden" name="newLeft" value="" /> 
            <input type="hidden" name="newRight" value="" /> 
            <input type="hidden" name="consentType" value="SSA Authorization" />
            <input type="hidden" name="purposeOfUse" value="COVERAGE" />
            <input type="hidden" name="expirationYears" value="2" />
            <input type="hidden" id="isDelayed" name="isDelayed" value="<c:out value="${delayedSSAAuth}"/>" />
            <div id="columndiv" style="margin:0px auto; width:100%">
                <div id="column1" style="float:left; margin:0; width:65%;">
                    <div>
                        <label for="authenticatingFacility">
                            Authenticating Facility<img alt="Required field" src="res/star-icon_grey_bg.png" />
                        </label> 
                        <select id="authenticatingFacility" name="userFacility" style="width: 250px; overflow: auto;">
                            <c:forEach var="f" items="${allowedFacilities}">
                                <option value="<c:out value="${f.facilityStation}"/>"
                                    <c:choose>
                                        <c:when test="${f.facilityStation eq defaultUserFacility.facilityStation}">
                                            selected
                                        </c:when>
                                        <c:when test="${cookie.facility.value == f.facilityStation}">
                                            selected
                                        </c:when>
                                    </c:choose>>
                                    <c:choose>
                                        <c:when test="${f.facilityName != ''}">
                                            <c:out value="${f.facilityName}"/>
                                       </c:when>
                                        <c:otherwise>
                                            ${fn:split(f.facilityDns, '.')[0]}
                                        </c:otherwise>
                                    </c:choose>
                                    (<c:out value="${f.facilityStation}"/>)
                                </option>
                            </c:forEach>
                        </select> 
                        <br /> <br />
                    </div>
                    <div>
                        <label for="option1">
                            10-5345 Form Validation
                            <img alt="Required field" src="res/star-icon_grey_bg.png" />
                        </label> 
                        <input type="checkbox" title="select Form Validation checkbox if Authorization Form 10-5345 was received and validated. required field" onclick="enableAuthorizeAfterValidation('signatureDate', 'option1', 'Authorize');" name="option1" value="Authorization Form Received and Validated" id="option1" />
                        Authorization Form Received and Validated
                        <br /> <br />
                    </div>
                    <div>
                        <label for="signatureDate">
                            Patient Signature Date
                            <img alt="Required field" src="res/star-icon_grey_bg.png" /> 
                        </label> 
                        <date:date id="signatureDate" name="signatureDate" onkeyup="enableAuthorizeAfterValidation('signatureDate', 'option1', 'Authorize');"/> <i>mm/dd/yyyy</i>
                        <br /><br />
                    </div>
                    <c:choose>
                        <c:when test="${isFormUploadAllowed}">
                            <div>
                                <label for="file">
                                    Upload Consent Form <br /> 
                                    <i><span style="font-weight: normal;">(Max file size: <c:out value="${maxFileUploadSize/1000000}"/> megabytes)</span> </i> 
                                </label>
                                <input title="Browse and Upload Consent Form" name="uploaded" type="file" id="file" accept="application/pdf" />
                            </div>
                        </c:when>
                    </c:choose>
                </div>
                <div id="delayedFields" style="display:block;">
                    <div id="column2" style="float:left; margin:0; width:10%;">
                        <b>-OR-</b>
                    </div>
                    <div id="column3" style="float:left; margin:0; width:25%;">
                        <input type="checkbox" title="Select if authorization is delayed" onclick="enableDelayedReasons();" name="delayedValue" value="Delay this authorization" id="delayedValue" />
                        <label for="delayedValue" style="float: none; display: inline;">
                            Delay this authorization
                        </label> 
                        <br /> <br />
                        <div style="visibility: hidden" id="delayReasons">
                           <label id="reasonsLabel" name="reasonsLabel" style="text-align: left">
                               Reason for delay
                               <img alt="Required field" src="res/star-icon_grey_bg.png" />
                            </label>
                           <input type="hidden" name="collectedReasons" id="collectedReasons" />
                           <input type="checkbox" title="Form not signed" aria-labelledby="reasonsLabel" name="reasonsForDelay" id="reasonsForDelay1" onclick="collectDelayedReasons(this); enableAuthorizeAfterValidation('delayedValue', 'reasonsForDelay', 'Authorize');" value="1" />
                           Form not signed<br/>
                           <input type="checkbox" title="Form content altered" aria-labelledby="reasonsLabel" name="reasonsForDelay" id="reasonsForDelay2" onclick="collectDelayedReasons(this); enableAuthorizeAfterValidation('delayedValue', 'reasonsForDelay', 'Authorize');" value="2" />
                           Form content altered<br/>
                           <input type="checkbox" title="Demographic changes" aria-labelledby="reasonsLabel" name="reasonsForDelay" id="reasonsForDelay3" onclick="collectDelayedReasons(this); enableAuthorizeAfterValidation('delayedValue', 'reasonsForDelay', 'Authorize');" value="3" />
                           Demographic changes<br/>
                           <input type="checkbox" title="Privacy Officer review" aria-labelledby="reasonsLabel" name="reasonsForDelay" id="reasonsForDelay4" onclick="collectDelayedReasons(this); enableAuthorizeAfterValidation('delayedValue', 'reasonsForDelay', 'Authorize');" value="4" />
                           Privacy Officer review<br/>
                           <input type="checkbox" title="Signature verification" aria-labelledby="reasonsLabel" name="reasonsForDelay" id="reasonsForDelay5" onclick="collectDelayedReasons(this); enableAuthorizeAfterValidation('delayedValue', 'reasonsForDelay', 'Authorize');" value="5" />
                           Signature verification<br/>
                           <input type="checkbox" title="Power of Attorney not on file" aria-labelledby="reasonsLabel" name="reasonsForDelay" id="reasonsForDelay6" onclick="collectDelayedReasons(this); enableAuthorizeAfterValidation('delayedValue', 'reasonsForDelay', 'Authorize');" value="6" />
                           Power of Attorney not on file
                       </div>
                    </div>
                </div>
            </div> 
            <br/><br/>
            <div>
                <label for="comments">Comments</label>
                <textarea id="comments" name="comments" style="width: 300px; height: 60px;"></textarea>
                <br />
            </div>     
            <br />
            <div align="center">
                <input id="Authorize" class="button" type="submit" disabled="disabled" value="Authorize" name="optIn" title="Authorize" />
            </div>
        </form>
    </fieldset>
</div>