<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp"%>
<%@taglib tagdir="/WEB-INF/tags/date" prefix="date"%>

<script type="text/javascript">
    jQuery(document).ready(function () { 
        setFocus(multiSelectListForm.authenticatingFacility);
        opt.init(document.multiSelectListForm);
    });
</script>

<div>
    <p class="detailText">
        The Veteran has a right to request the
        Department of Veterans Affairs (VA) to restrict or limit the
        sharing of his/her electronic health information through 
        <c:out value="${organizationName}"/> by designating which non-VA healthcare provider organizations 
        he/she does NOT wish to receive their information. A restriction 
        request may be filed even if the Veteran does not have an authorization 
        on file permitting the disclosure of his/her health information to 
        non-VA healthcare provider organizations. Note that until an 
        authorization is on file, the restriction request will remain in an 
        <strong>inactive</strong> status. Any restriction request submitted will apply 
        ONLY to the sharing of electronic health information through 
        <strong><c:out value="${organizationName}"/></strong>.
    </p>
    <p class="detailText">
        Indicate which non-VA health care provider 
        organization participating in <c:out value="${organizationName}"/> the Veteran does 
        NOT wish to receive their electronic health information. By 
        completing the Restriction on VA Form 10-0525a, the Veteran is 
        restricting the VA from sharing his/her health information for 
        treatment purposes with the non-VA health care provider 
        organizations participating in <c:out value="${organizationName}"/> and partnering with VA.
    </p>
    <p class="detailText">
        The VA will not share the Veteran health 
        information with the selected non-VA health care provider 
        organizations through <c:out value="${organizationName}"/> even if the Veteran later 
        signs an authorization.
    </p>
</div>
<div class="form-container">
    <fieldset>
        <legend>Restrict</legend>
        <div>
            <input checked title="Choose the radio button to select Veteran Authorizes sharing of health records with <c:out value="${organizationName}"/> providers and organizations with the following exclusions:" type="radio" name="consentGroup" id="consentGroup" value="authorizeExclusion" onClick="formShow('multiSelectAuthorizeForm')" />
            <label class="vap-reg-label" for="consentGroup">
                Veteran Restricts sharing of health records with <c:out value="${organizationName}"/> 
                providers and organizations with the following exclusions: 
            </label>
            <br /> <br />
        </div>
        <form name="multiSelectListForm" id="multiSelectListForm" action="PatientDetails.do_sec" method="POST" enctype="multipart/form-data" onsubmit="return doSubmit(this)">
            <input type="hidden" name="icn" value="<c:out value="${patientDemographics.icn}"/>" /> 
            <input type="hidden" name="requestId" value="<c:out value="${requestId}"/>" /> 
            <input type="hidden" name="newLeft" value="" /> 
            <input type="hidden" name="newRight" value="" /> 
            <input type="hidden" name="consentType" value="NwHIN Organization Restriction Authorization" /> 
            <input type="hidden" name="purposeOfUse" value="TREATMENT" />

            <div id="multiSelectAuthorizeForm">
                <table bgcolor="#eff2ff">
                    <tr>
                        <td colspan="3">
                            There must be at least one non-VA health care 
                            provider organization -- other than Department of Defense 
                            (DoD) --- in the "All Providers and Organizations <strong>(unrestricted)</strong>" 
                            selection box AND at least one non-VA health care provider 
                            organization in the "<c:out value="${organizationName}"/> Providers and Organizations 
                            who will NOT have access to the records <strong>(restricted)</strong>" box. 
                            <br /> <br />
                            <p class="detailText">
                                * NOTE: You cannot restrict DoD, VA patient information is always shared with the DoD.
                                <br /> <br />
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <label class="vap-reg-label" for="list1">
                                <strong>All Providers and Organizations (unrestricted)</strong>
                            </label>
                        </td>
                        <td>&nbsp;&nbsp;&nbsp;&nbsp;</td>
                        <td>
                            <label for="list2" class="vap-reg-label">
                                <strong><c:out value="${organizationName}"/> Providers and Organizations who will NOT have access to the records (restricted)</strong>
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <select style="width: 310px;" class="listSelect" name="list1" id="list1" multiple="multiple" size="10" onDblClick="opt.transferRight();enableRestrictAfterValidation('signatureDate', 'option1', 'list1', 'list2', 'Authorize');">
                                <c:forEach var="r" items="${allowedOrganizations}">
                                    <c:choose>
                                        <c:when test="${r.orgNumber eq  '200DOD'}">
                                            <option value="<c:out value="${r.orgNumber}"/>">* <c:out value="${r.orgName}"/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>
                                        </c:when>
                                        <c:otherwise>
                                            <option value="<c:out value="${r.orgNumber}"/>"><c:out value="${r.orgName}"/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>
                                        </c:otherwise>
                                    </c:choose>
                                </c:forEach>
                            </select>
                        </td>
                        <td valign="middle" align="left">
                            <input style="width: 125px; height: 30px;" TYPE="button" title="Move all the Organizations to the right box" class="midButton" name="right" value="Move All &gt;&gt;" onclick="opt.transferAllRight();enableRestrictAfterValidation('signatureDate', 'option1', 'list1', 'list2', 'Authorize');" />
                            <br /> 
                            <input type="button" title="Move the Selected Organizations to the right box" class="midButton" style="width: 125px; height: 30px;" name="right" value="Move Selected &gt;" onclick="opt.transferRight();enableRestrictAfterValidation('signatureDate', 'option1', 'list1', 'list2', 'Authorize');" /> 
                            <br /> <br />
                            <input type="button" title="Move the selected Organizations to the left box" class="midButtonLeft" style="width: 125px; height: 30px;" name="left" value="&lt; Move Selected" onclick="opt.transferLeft();enableRestrictAfterValidation('signatureDate', 'option1', 'list1', 'list2', 'Authorize');" /> 
                            <br /> 
                            <input type="button" title="Clear all selections" class="midButton" name="left" style="width: 125px; height: 30px;" value="Clear" onclick="opt.transferAllLeft();disableObject('Authorize');" />
                        </td>
                        <td>
                            <select name="list2" class="listSelect" multiple="multiple" size="10" id="list2" onDblClick="opt.transferLeft();enableRestrictAfterValidation('signatureDate', 'option1', 'list1', 'list2', 'Authorize');" style="width: 310px;"></select>
                        </td>
                    </tr>
                </table>
                <br /> <br />
            </div>
            <div>
                <label for="authenticatingFacility">
                    Authenticating Facility<img alt="Required field" src="res/star-icon_grey_bg.png" />
                </label> 
                <select id="authenticatingFacility" name="userFacility" style="width: 250px; overflow: auto;">
                    <c:forEach var="f" items="${allowedFacilities}">
                        <option value="<c:out value="${f.facilityStation}"/>"
                            <c:choose>
                                <c:when test="${f.facilityStation eq defaultUserFacility.facilityStation}">
                                    selected
                                </c:when>
                                <c:when test="${cookie.facility.value == f.facilityStation}">
                                    selected
                                </c:when>
                            </c:choose>>
                            <c:choose>
                                <c:when test="${f.facilityName != ''}">
                                    <c:out value="${f.facilityName}"/>
                                </c:when>
                                <c:otherwise>
                                    ${fn:split(f.facilityDns, '.')[0]}
                                </c:otherwise>
                            </c:choose>
                            (<c:out value="${f.facilityStation}"/>)
                        </option>
                    </c:forEach>
                </select> 
                <br /> <br />
            </div>
            <div>
                <label for="option1">
                    10-0525a Form Validation
                    <img alt="Required field" src="res/star-icon_grey_bg.png" />
                </label> 
                <input type="checkbox" title="select Form Validation checkbox if Restriction Form 10-0525a was received and validated. required field" onclick="enableRestrictAfterValidation('signatureDate', 'option1', 'list1', 'list2', 'Authorize');" name="option1" id="option1" value="Restriction Form Received and Validated" />
                Restriction Form Received and Validated &nbsp; <br /> <br />
            </div>
            <div>
                <label for="signatureDate">
                    Patient Signature Date
                    <img alt="Required field" src="res/star-icon_grey_bg.png" /> 
                </label> 
                <date:date id="signatureDate" name="signatureDate" onkeyup="enableRestrictAfterValidation('signatureDate', 'option1', 'list1', 'list2', 'Authorize');"/> <i>mm/dd/yyyy</i>
                <br /><br />
            </div>
            <c:choose>
                <c:when test="${isFormUploadAllowed}">
                    <div>
                        <label for="file">
                            Upload Consent Form<br /> 
                            <i><span style="font-weight: normal;">(Max file size: <c:out value="${maxFileUploadSize/1000000}"/> megabytes)</span> </i> 
                        </label>
                        <input title="Browse and Upload Consent Form" name="uploaded" type="file" id="file" accept="application/pdf" />
                    </div>
                </c:when>
            </c:choose>
            <div>
                <label for="comments">Comments</label>
                <textarea id="comments" name="comments" style="width: 300px; height: 60px;"></textarea>
                <br />
            </div>        
            <br />
            <div align="center">
                <input id="Authorize" class="button" type="submit" disabled="disabled" value="Restrict" name="optIn" title="Restrict" />
            </div>
        </form>
    </fieldset>
</div>