<%--
    Document   : organizations list
    Created on : Mar 15, 2016, 12:04:04 PM
    Author     : Johann Sonnenberg
--%>

<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>

<f:mainTemplate headerText="Partner Organizations">
    <script language="JavaScript">
        $(document).ready(function () {
            //initial data table setup and call for the first recordset
            $.fn.dataTable.ext.errMode = 'none';

            setProcessingForDataTable('tblOrganizations');

            var organizationTable = $('#tblOrganizations').DataTable({
                destroy: true,
                searching: false,
                processing: true,
                serverSide: true,
                order: [[6, 'asc']],
                ajax: "OrganizationHandler.do_sec?getAll=true",
                columnDefs: [
                    {orderable: false, targets: [10]},
                    {className: "dt-head-center", targets: [0,1,2,3,4,5,6,7,9]},
                    {className: "vap-break-word vap-col-min-130 dt-head-center", targets: [8]},
                    {className: "dt-head-center dt-body-center", targets: [10]}
                ],
                scrollX:true,
                initComplete: function(){
                    // Enable THEAD scroll bars
                    $('.dataTables_scrollHead').css('overflow', 'auto');

                    // Sync THEAD scrolling with TBODY
                    $('.dataTables_scrollHead').on('scroll', function () {
                        $('.dataTables_scrollBody').scrollLeft($(this).scrollLeft());
                    });
                },
                lengthMenu: [ 10, 25, 50, 100, 250, 500 ],
                pageLength: 25
            });

            organizationTable.on('draw', function () {
                addAriaToDataTable('tblOrganizations', organizationTable);
            });

            function constructUrl(methodName){
                var url= 'OrganizationHandler.do_sec' +
                    '?' + methodName + '=true' +
                    '&sortOrder=' + $('#tblOrganizations').dataTable().fnSettings().aaSorting[0][1] +
                    '&sortBy=' + $('#tblOrganizations').dataTable().fnSettings().aaSorting[0][0];

                return url;
            }

            $('.exportButton').on('click', function() {
                window.location.href = constructUrl($(this).data('method'));
                return false;
            });
        });
    </script>

    <c:if test="${not empty message}">
        <div class="vap-alert alert alert-success pad-bottom-10 pad-top-10 pad-left-10">
            <c:out value="${message}" />
        </div>
    </c:if>
    <div class="pad-top-5 pad-bottom-20 text-right">
        <a href="#"><button class="exportButton" data-method="exportToExcel" title="Export to Excel">Export to Excel</button></a>
    </div>
    <div id="divReportContent">
        <table id="tblOrganizations" class="display" width="100%" cellspacing="0" role="presentation">
            <thead>
                <tr role="row">
                    <th role="columnheader" style="max-width: 55px;"><span id="partnerOrganizationActiveHeader" data-tooltip="<c:out value="${descriptors['partnerOrganizationActiveColumn']}" />">Active</span></th>
                    <th role="columnheader" style="min-width: 80px;"><span id="partnerOrganizationPhoneHeader" data-tooltip="<c:out value="${descriptors['partnerOrganizationPhoneColumn']}" />">Phone</span></th>
                    <th role="columnheader"><span id="partnerOrganizationPrefixHeader" data-tooltip="<c:out value="${descriptors['partnerOrganizationPrefixColumn']}" />">Prefix</span></th>
                    <th role="columnheader" style="min-width: 75px;"><span id="partnerOrganizationConsumerOnlyHeader" data-tooltip="<c:out value="${descriptors['partnerOrganizationConsumerOnlyColumn']}" />">Consumer<br/>Only</span></th>
                    <th role="columnheader"><span id="partnerOrganizationContactHeader" data-tooltip="<c:out value="${descriptors['partnerOrganizationContactColumn']}" />">Contact</span></th>
                    <th role="columnheader"><span id="partnerOrganizationDomainHeader" data-tooltip="<c:out value="${descriptors['partnerOrganizationDomainColumn']}" />">Domain</span></th>
                    <th role="columnheader"><span id="partnerOrganizationNameHeader" data-tooltip="<c:out value="${descriptors['partnerOrganizationNameColumn']}" />">Name</span></th>
                    <th role="columnheader"><span id="partnerOrganizationNumberHeader" data-tooltip="<c:out value="${descriptors['partnerOrganizationNumberColumn']}" />">Number</span></th>
                    <th role="columnheader"><span id="partnerOrganizationIdHeader" data-tooltip="<c:out value="${descriptors['partnerOrganizationIdColumn']}" />">Organization ID</span></th>
                    <th role="columnheader" style="max-width: 95px;"><span id="partnerOrganizationTrustedClinicalSourceHeader" data-tooltip="<c:out value="${descriptors['partnerOrganizationTrustedClinicalSourceColumn']}" />">Trusted<br/>Clinical Source</span></th>
                    <th role="columnheader" style="max-width: 55px;"><span id="partnerOrganizationActionHeader" data-tooltip="<c:out value="${descriptors['partnerOrganizationActionColumn']}" />" data-tooltip-position="left">Action</span></th>
                </tr>
            </thead>
        </table>
    </div>
</f:mainTemplate>