<%--
    Document   : edit
    Created on : Mar 17, 2016, 6:25:38 AM
    Author     : Johann Sonnenberg
--%>
<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp" %>

<f:mainTemplate headerText="Partner Organizations">
    <script language="JavaScript">
        $(document).ready(function() {
            <c:if test="${organization.active == 'N'}">
                //make the fields read only because this partner organization is NOT active.
                $('#frmEditOrganization .disableWhenInactive').prop('disabled', true);
            </c:if>

            $('.orgOptions').on('change', function(event) {
                var link = $(this); // link that triggered the modal
                var key = link.data('org-option'); // extract info from data-* attributes

                if(key === 'trustedSource')
                {
                    $('#trustedSourceWarning').show();
                } else {
                    $('#trustedSourceWarning').hide();
                }

                if (key === 'active') //if it changes and it NOT checked show it
                {
                    if (!$(this).is(':checked'))
                    {
                        //show the warning message
                        $('#activeWarning').show();

                        //reset the form back to what it was
                        $(this).closest('form')[0].reset();

                        //set the active checkbox to not checked
                        $(this).prop('checked', false);

                        //pop a dialog/modal to tell the user that we are
                        $('#dialog-no-longer-active').dialog({
                            modal: true,
                            buttons: {
                                Ok: function () {
                                    $(this).dialog("close");
                                }
                            }
                        });

                        if(!$(this).is(':checked'))
                        {
                            //show the warning message
                            $('#activeWarning').show();

                            //reset the form back to what it was
                            $(this).closest('form')[0].reset();

                            //set the active checkbox to not checked
                            $(this).prop('checked', false);

                            //pop a dialog/modal to tell the user that we are
                            $( '#dialog-no-longer-active' ).dialog({
                                modal: true,
                                buttons: {
                                Ok: function() {
                                        $( this ).dialog( "close" );
                                    }
                                }
                            });

                            //disable all the fields
                            $('#frmEditOrganization .disableWhenInactive').prop('disabled', true);
                        } else {
                            //remove the warning message
                            $('#activeWarning').hide();

                            //enable all fields
                            $('#frmEditOrganization .disableWhenInactive').prop('disabled', false);
                        }
                    }
                }
            });
        });
    </script>

    <div class="form-container">
        <form name="frmEditOrganization" id="frmEditOrganization" action="OrganizationHandler.do_sec?editComplete=true" method="post">
            <input type="hidden" name="orgId" id="orgId" value="<c:out value="${organization.orgId}"/>" />
            <fieldset>
                <legend>Edit Partner Organization</legend>
                <div id="errorMessage" class="errors" style="display: none;"></div>
                <div>
                    <label for="orgName">Organization name</label>
                    <input data-tooltip="<c:out value="${descriptors['partnerOrganizationNameField']}"/>" type="text" name="orgName" id="orgName" maxlength="255" value="<c:out value="${organization.orgName}"/>" required /> <i class="fa fa-asterisk vap-required"></i>
                </div>
                <div>
                    <label for="orgNumber">Organization number</label>
                    <input data-tooltip="<c:out value="${descriptors['partnerOrganizationNumberField']}"/>" type="text" name="orgNumber" id="orgNumber" maxlength="255" value="<c:out value="${organization.orgNumber}"/>" required /> <i class="fa fa-asterisk vap-required"></i>
                </div>
                <div>
                    <label for="orgContact">Contact name</label>
                    <input data-tooltip="<c:out value="${descriptors['partnerOrganizationContactNameField']}"/>" type="text" name="orgContact" id="orgContact" maxlength="255" value="<c:out value="${organization.orgContact}"/>" />
                </div>
                <div>
                    <label for="orgPhone">Contact phone</label>
                    <input data-tooltip="<c:out value="${descriptors['partnerOrganizationContactPhoneField']}"/>" type="text" name="orgPhone" id="orgPhone" maxlength="255" value="<c:out value="${organization.oorgPhoneNumber}"/>" />
                </div>
                <div class="no-padding">
                    <label for="isTrustedClinicalSource">Is trusted clinical source</label>
                    <input data-tooltip="<c:out value="${descriptors['partnerOrganizationIsTrustedClinicalSourceField']}"/>" type="checkbox" name="isTrustedClinicalSource" id="isTrustedClinicalSource" value="Y" <c:if test="${organization.isTrustedClinicalSource == 'Y'}">checked="checked" </c:if>class="orgOptions" data-org-option="trustedSource" />
                    <div class="bg-warning" style="display: none;" id="trustedSourceWarning">
                        NOTE: Clinical data submitted from this partner will be input into VistA without a clinician's review.
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div>
                    <label for="orgActive">Active</label>
                    <c:choose>
                        <c:when test="${organization.active == 'Y'}">Yes</c:when>
                        <c:otherwise>No</c:otherwise>
                    </c:choose>
                </div>
                <div>
                    <label for="orgConsumerOnly">Consumer only</label>
                    <c:choose>
                        <c:when test="${organization.orgConsumerOnly}">Yes</c:when>
                        <c:otherwise>No</c:otherwise>
                    </c:choose>
                </div>
                <div>
                    <label for="orgOid">Organization ID</label>
                    <c:out value="${organization.orgOid}"/>
                </div>
                <div>
                    <label for="orgDomain">Domain</label>
                    <c:out value="${organization.orgDomain}"/>
                </div>
                <div>
                    <label for="orgPrefix">Prefix</label>
                    <c:out value="${organization.orgCommunityIdPrefix}"/>
                </div>
            </fieldset>
            <div>
                <input name="btnSave" id="btnSearch" title="Save" class="button" type="submit" value="Save" />&nbsp;&nbsp;
                <input type="button" value="Cancel" onclick="location.href='OrganizationHandler.do_sec?list=true';" />
            </div>
        </form>
    </div>
    <div id="dialog-no-longer-active" style="display: none;" title="Partner Organization No Longer Active">
        You have selected to inactivate this partner organization. All fields are now locked and no more changes, other than the status will be saved.
    </div>
</f:mainTemplate>