<%--
    Document   : Adapter Query Page
    Created By : Sricharan Reddy
--%>

<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
    pageEncoding="ISO-8859-1"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp" %>
<%@taglib tagdir="/WEB-INF/tags/date" prefix="date" %>

<f:mainTemplate headerText="Page to Download Query Document">
    <script language="JavaScript">
        $(document).ready(function () {
            $("#startDate").datepicker({
                maxDate: 0,
                dateFormat: 'mm/dd/yy',
                onClose: function (selectedDate) {
                    $("#endDate").datepicker("option", "minDate", selectedDate);
                }
            });

            $("#endDate").datepicker({
                maxDate: 0,
                dateFormat: 'mm/dd/yy',
                onClose: function (selectedDate) {
                    $("#startDate").datepicker("option", "maxDate", selectedDate);
                }
            });
           })
            
           $('#organization').parent().parent().css('width','auto');
       </script>
       
       
        <div class="form-container">
        <form name="adapterQueryReportForm" action="AdapterDateRangeReport.do_sec" method="POST" onsubmit="return doGet(this)">
        
            <fieldset>
             
                
                <div class="width-450" id="dateTip" data-tooltip="<c:out value="${descriptors['startDateEndDateField']}"/>">
                    <div>
                        <label for="startDate">Start Date</label>
                        <date:date id="startDate" name="startDate" value="${startDateDefault}"/> <i>mm/dd/yyyy</i>
                    </div>
                    <div>
                        <label for="endDate">End Date</label>
                        <date:date id="endDate" name="endDate" value="${endDateDefault}"/> <i>mm/dd/yyyy</i>
                    </div>
                    
                    <div id="organizationDiv" >
                    <TABLE BORDER="0">
                    <TR>
                   <TD> <label title="Query based on <c:out value="${organizationName}" /> Organization from the dropdown list" for="organization"><c:out value="${organizationName}" /> Organization</label></TD>
                    <TD>
                    <select id="organization" name="item" onchange="document.getElementById('organizationName').value = this.options[this.selectedIndex].text;" data-tooltip="<c:out value="${descriptors['accountingOfDisclosuresReportOrganizationField']}"/>">
                        <option value="" selected>ALL</option>
                        <c:forEach var="r" items="${activeOrgs}">
                            <option value="%<c:out value="${r.orgOid}" />"><c:out value="${r.orgName}" /></option>
                        </c:forEach>
                        <c:forEach var="r" items="${inactiveOrgs}">
                            <option value="%<c:out value="${r.orgOid}" />">[INACTIVE] <c:out value="${r.orgName}" /></option>
                        </c:forEach>
                    </select>
               
                    </TD>
                    </TR>
                    </TABLE>
                    </div>
                    
                    </div>
                     <div align="center">
                    <input type="submit"  value="Generate">
                    </div>
                    </fieldset>
                    </form>
                </div>
               
           
      
   
     
 </f:mainTemplate>