<%--
    Author     : Asha Amritraj
    Page results with Next and Previous buttons.
--%>

<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<%@tag description="put the tag description here" pageEncoding="UTF-8"%>

<%@attribute name="paginator" rtexprvalue="true"
	type="gov.va.nvap.web.util.Paginator"%>
<%@attribute name="uri"%>
<%@attribute name="results" rtexprvalue="true" type="java.util.List"%>

<form action="${uri}" method="GET">
	<div class="text" style="text-align: right;" align="right">
		<c:choose>
			<c:when test="${paginator.recordsPerPage > 0}">
				<input type="hidden" name="currentPage"
					value="${paginator.currentPage}" />
				<input class="button" type="submit" name="prev" value="Previous"
					<c:if test="${paginator.currentPage <= 0}">disabled</c:if> />
                Records ${paginator.currentPage * paginator.recordsPerPage + 1} to
                <c:choose>
					<c:when test="${fn:length(results) > paginator.recordsPerPage}">
                        ${paginator.currentPage * paginator.recordsPerPage + fn:length(results) - 1}
                    </c:when>
					<c:otherwise>
                        ${paginator.currentPage * paginator.recordsPerPage + fn:length(results)}
                    </c:otherwise>
				</c:choose>
				<c:choose>
					<c:when test="${paginator.nextDisabled == true}">
						<input class="button" type="submit" name="next" value="Next" disabled="disabled" />
					</c:when>
					<c:otherwise>
						<input class="button" type="submit" name="next" value="Next"
							<c:if test="${fn:length(results) <= paginator.recordsPerPage - 1}">disabled</c:if> />
					</c:otherwise>
				</c:choose>
			</c:when>
			<c:otherwise>
                Records 1 to ${fn:length(results)}
            </c:otherwise>
		</c:choose>
	</div>
</form>
