<%@tag description="creates a dropdown (select) of years" pageEncoding="UTF-8"%>

<%@attribute name="fieldId" required="true" description="id for the field on the form" %>
<%@attribute name="fieldName" required="true" description="name for the field on the form" %>
<%@attribute name="enableMultiple" required="true" description="boolean if the select box should allow multiple selections" type="Boolean" %>
<%@attribute name="cssClass" description="css class name to be applied to this field" %>
<%@attribute name="cssStyle" description="css inline style to be applied to this field" %>
<%@attribute name="yearsBeforeToday" description="number of years to display prior to this year" required="true" %>
<%@attribute name="yearsAfterToday" description="number of years to display after this year" required="true" %>

<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>

<jsp:useBean id="now" class="java.util.Date" />
<fmt:formatDate var="currentYear" value="${now}" pattern="yyyy" />

<select name="${fieldName}" id="${fieldId}" class="${cssClass}" style="${cssStyle}" <c:if test="${enableMultiple}">multiple="multiple"</c:if>>
    <c:if test="${yearsBeforeToday != 0}">
        <c:forEach begin="${currentYear - yearsBeforeToday}" end="${currentYear - 1}" var="priorYear">
            <option value="<c:out value="${priorYear}" />"><c:out value="${priorYear}" /></option>
        </c:forEach>
    </c:if>
    <option value="<c:out value="${currentYear}" />"><c:out value="${currentYear}" /></option>
    <c:if test="${yearsAfterToday != 0}">
        <c:forEach begin="${currentYear + 1}" end="${currentYear + yearsAfterToday}" var="priorYear">
            <option value="<c:out value="${priorYear}" />"><c:out value="${priorYear}" /></option>
        </c:forEach>
    </c:if>
</select>