<%@tag description="Creates a month dropdown (select)" pageEncoding="UTF-8"%>

<%@attribute name="fieldId" required="true" description="id for the field on the form" %>
<%@attribute name="fieldName" required="true" description="name for the field on the form" %>
<%@attribute name="enableMultiple" required="true" description="boolean if the select box should allow multiple selections" type="Boolean" %>
<%@attribute name="cssClass" description="css class name to be applied to this field" %>
<%@attribute name="cssStyle" description="css inline style to be applied to this field" %>
<%@attribute name="displayFormat" description="defaults to fullName, but possible values are: fullName, abbreviation, fullNameAndNumber, abbreviationAndNumber, number" %> 

<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>

<c:choose>
    <c:when test="${displayFormat == 'fullName'}">
        <c:set var="arrMonths">January,February,March,April,May,June,July,August,September,October,November,December</c:set>
    </c:when>
    <c:when test="${displayFormat == 'abbreviation'}">
        <c:set var="arrMonths">Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec</c:set>
    </c:when>
    <c:when test="${displayFormat == 'fullNameAndNumber'}">
        <c:set var="arrMonths">January (1),February (2),March (3),April (4),May (5),June (6),July (7),August (8),September (9),October (10),November (11),December (12)</c:set>
    </c:when>
    <c:when test="${displayFormat == 'abbreviationAndNumber'}">
        <c:set var="arrMonths">Jan (1),Feb (2),Mar (3),Apr (4),May (5),Jun (6),Jul (7),Aug (8),Sept (9),Oct (10),Nov (11),Dec (12)</c:set>
    </c:when>
    <c:when test="${displayFormat == 'number'}">
        <c:set var="arrMonths">1,2,3,4,5,6,7,8,9,10,11,12</c:set>
    </c:when>
    <c:otherwise>
        <c:set var="arrMonths">January,February,March,April,May,June,July,August,September,October,November,December</c:set>
    </c:otherwise>
</c:choose>

<select name="${fieldName}" id="${fieldId}" class="${cssClass}" style="${cssStyle}" <c:if test="${enableMultiple}">multiple="multiple"</c:if>>
    <c:forTokens varStatus="cnt" delims="," items="${arrMonths}" var="m">
        <option value="<c:out value="${cnt.count}" />"><c:out value="${m}" /></option>
    </c:forTokens>
</select>