<%@tag description="creates a dropdown (select) of months and years from a starting month/year. the year is specified and the month used is the current month." pageEncoding="UTF-8"%>

<%@attribute name="fieldId" required="true" description="id for the field on the form" %>
<%@attribute name="fieldName" required="true" description="name for the field on the form" %>
<%@attribute name="enableMultiple" required="true" description="boolean if the select box should allow multiple selections" type="Boolean" %>
<%@attribute name="cssClass" description="css class name to be applied to this field" %>
<%@attribute name="cssStyle" description="css inline style to be applied to this field" %>
<%@attribute name="startYear" required="true" description="the year to start with" %>
<%@attribute name="descriptor" required="false" description="the text to use for the help (descriptor) text" %>
<%@attribute name="fieldTitle" required="false" description="the text for the title used by screen readers for the select box. used in the title and the aria-label attributes for the select box." %>
<%@attribute name="startMonth" required="false" description="the month to start the dropdown with. in the form of the full month name with the first letter capitalized. defaults to the current month." %>

<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>

<c:set var="arrMonths">January,February,March,April,May,June,July,August,September,October,November,December</c:set>
<jsp:useBean id="now" class="java.util.Date" />
<fmt:formatDate var="currentYear" value="${now}" pattern="yyyy" />
<fmt:formatDate var="currentMonth" value="${now}" pattern="MMMM" />

<c:if test="${startMonth == null}">
    <fmt:formatDate var="startMonth" value="${now}" pattern="MMMM" />
</c:if>

<%-- need to find where to start in our month list based on the current month --%>
<c:forTokens var="m" varStatus="cnt" delims="," items="${arrMonths}">
    <c:if test="${m == startMonth}">
        <c:set var="startMonthIndex" value="${cnt.count}" />
    </c:if>
</c:forTokens>

<%-- need to find out where the current month is in the month list --%> 
<c:forTokens var="m" varStatus="cnt" delims="," items="${arrMonths}">
    <c:if test="${m == currentMonth}">
        <c:set var="currentMonthIndex" value="${cnt.count}" />
    </c:if>
</c:forTokens>

<%-- output the select box --%>
<select name="${fieldName}" id="${fieldId}" class="${cssClass}" style="${cssStyle}" <c:if test="${enableMultiple}">multiple="multiple"</c:if> data-tooltip="<c:out value="${descriptor}" />" title="${fieldTitle}" aria-label="${fieldTitle}">
    <%-- handle start year --%>
    <c:forTokens items="${arrMonths}" delims="," begin="${startMonthIndex-1}" varStatus="c" var="m">
        <option value="<c:out value="${startMonthIndex+c.count-1}" />|<c:out value="${startYear}" />" <c:out value="${startYear == currentYear && m == currentMonth ? 'selected' : ''}" />><c:out value="${m}" /> <c:out value="${startYear}" /></option>
    </c:forTokens>
        
    <%-- handle every other year --%> 
    <c:forEach begin="${startYear+1}" end="${currentYear}" var="yr">
        <c:choose>
            <c:when test="${yr != currentYear}">
                <c:forTokens varStatus="cnt" delims="," items="${arrMonths}" var="m">
                    <option value="<c:out value="${cnt.count}" />|<c:out value="${yr}" />" <c:out value="${yr == currentYear && m == currentMonth ? 'selected' : ''}" />><c:out value="${m}" /> <c:out value="${yr}" /></option>
                </c:forTokens>
            </c:when>
            <c:otherwise>
                <c:forTokens varStatus="cnt" delims="," items="${arrMonths}" var="m" end="${currentMonthIndex-1}">
                    <option value="<c:out value="${cnt.count}" />|<c:out value="${yr}" />" <c:out value="${yr == currentYear && m == currentMonth ? 'selected' : ''}" />><c:out value="${m}" /> <c:out value="${yr}" /></option>
                </c:forTokens>
            </c:otherwise>
        </c:choose>
    </c:forEach>
</select>