package gov.va.nvap.web.util.xls;

import gov.va.nvap.common.validation.Assert;
import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.web.dao.UserDocumentDAO;
import gov.va.nvap.web.user.UserHelper;
import gov.va.nvap.web.user.document.UserDocument;

import java.io.IOException;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONException;
import org.json.JSONObject;

/**
 *
 * @author Zachary Tubb
 */
public class ScheduledExports extends gov.va.nvap.web.app.ResponseDispatcherHttpServlet {

    private final SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd_hhmmss");

    private String encodeToJSON(HashMap results, String draw) throws ParseException {
        try {
            StringWriter json = new StringWriter();
            JSONObject obj = new JSONObject();
            List<List> data = new ArrayList<List>(); //overarching "data"
            SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss.S");
            SimpleDateFormat finalDate = new SimpleDateFormat("MM/dd/yyyy hh:mm a");
            List<UserDocument> documents = (List<UserDocument>) results.get("results");
            Long count = (Long) results.get("count");

            for (UserDocument doc : documents) {
                List<String> dataItem = new ArrayList<String>();
                dataItem.add(doc.getTitle());
                dataItem.add(doc.getFormat());
                Date date = dt.parse(doc.getCreationDate().toString());
                dataItem.add(finalDate.format(date));
                dataItem.add(doc.getStatus());
                if (doc.getStatus() != null && doc.getStatus().equals("COMPLETED")) {
                    dataItem.add("<a href='ScheduledExports.do_sec?getExport=true&docId=" + doc.getDocumentId().toString()
                        + "'><button title='Download' class='btn btn-primary btn-xs'><span class='fa fa-download pad-right-5' aria-hidden='true'></span>Download</button></a>");
                } else {
                    dataItem.add("&nbsp;"); //add in a non-breaking space if it's not completed yet so the view doesn't show "null"
                }
                data.add(dataItem);
            }
            //Add in required Datables values
            obj.put("draw", draw);
            obj.put("recordsFiltered", count);
            obj.put("recordsTotal", count);
            obj.put("data", data);

            obj.write(json);

            return json.toString();
        } catch (JSONException ex) {
            Logger.getLogger(ScheduledExports.class.getName()).log(Level.SEVERE, null, ex);
        }
        return "";
    }

    private UserDocumentDAO getUserDocumentDAO() {
        return this.getBean("UserDocumentDAO", UserDocumentDAO.class);
    }

    //Method to retreive scheduled export from the database for download.
    public void getExport(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        Long docId = Long.parseLong(request.getParameter("docId"));
        if (!NullChecker.isNullOrEmpty(docId)) {
            //Get the document from using the DAO.
            UserDocument document = this.getUserDocumentDAO().findUserDocument(docId);
            String date = df.format(new Date());

            if (!NullChecker.isNullOrEmpty(document)) {
                //Convert to bytes for output stream.
                byte[] wbBytes = (byte[]) document.getContent();

                //Set response attributes.
                switch (document.getFormat()) {
                    case "Excel":
                        response.setContentType("application/vnd.ms-excel");
                        response.setHeader("Content-Disposition",
                                "attachment; filename=\"" + document.getTitle().replaceAll(" ", "_") + "_" + date + ".xls" + "\"");
                        response.setHeader("Cache-Control", "must-revalidate");
                        break;
                    case "CSV":
                        response.setContentType("text/csv");
                        response.setHeader("Content-Disposition",
                                "attachment; filename=\"" + document.getTitle().replaceAll(" ", "_") + "_" + date + ".csv" + "\"");
                        response.setHeader("Cache-Control", "must-revalidate");
                        break;
                }

                try {
                    //Write to output stream.
                    final ServletOutputStream os = response.getOutputStream();
                    Assert.assertNotEmpty(os, "Output Stream cannot be null!");
                    os.write(wbBytes);
                    try {
                        os.close();
                    }
                    catch (final IOException ex) {
                    }
                } catch (final IOException ex) {
                    throw new ServletException(ex);
                }
            }
        }
    }

    public void getUserExports(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, ParseException {
        //Get paramaters from Datables request
        final HttpSession session = request.getSession(false);
        final String maxRows = request.getParameter("length");
        final String startRow = request.getParameter("start");
        final String draw = (String)request.getParameter("draw");
        final String sortBy = request.getParameter("order[0][column]");
        final String sortOrder = request.getParameter("order[0][dir]");

        //Get the exports with the parameters from Datables
        HashMap hm = this.getUserDocumentDAO().findByUserId(UserHelper.getUserName(request), sortBy, sortOrder, Integer.parseInt(maxRows), Integer.parseInt(startRow));

        session.setAttribute("results", encodeToJSON(hm, draw));

        this.forward(request, response, "resultsJSON");
    }

    @Override
    protected void unspecified(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.forward(request, response, "show");
    }

}

