package gov.va.nvap.web.util.letter;

import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.service.pdq.PatientDemographics;
import gov.va.nvap.svc.consentmgmt.stub.dao.DelayReasonDAO;
import gov.va.nvap.svc.consentmgmt.stub.dao.MailNotificationDAO;
import gov.va.nvap.svc.consentmgmt.stub.dao.MailTemplateDAO;
import gov.va.nvap.svc.consentmgmt.stub.data.ConsentDirective;
import gov.va.nvap.svc.consentmgmt.stub.data.DelayedConsent;
import gov.va.nvap.svc.facility.data.Facility;
import gov.va.nvap.svc.facility.intf.EntityDoesNotExistException;
import gov.va.nvap.svc.facility.intf.FacilityService;
import gov.va.nvap.web.util.file.PdfGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Scanner;
import org.apache.commons.io.IOUtils;

/**
 *
 * @author Johann Sonnenberg
 */
public class LetterGenerator {

    private FacilityService facilityService;

    private MailTemplateDAO mailTemplateDAO;

    private DelayReasonDAO delayReasonDAO;

    private MailNotificationDAO mailNotificationDAO;

    public ByteArrayOutputStream generate(String type, String facilityStation, Object ssaDelay, Object eheDelay, DelayedConsent delayedConsent, String[] delayedReasons, ConsentDirective consentDirective, PatientDemographics patientDemographics, String currentUser, String signature) throws EntityDoesNotExistException, IOException {
        final SimpleDateFormat letterFormat = new SimpleDateFormat("MM/dd/yyyy");
        InputStream inputStream = null;
        String templateString = "";
        ArrayList<HashMap<String, String>> patientDetails = new ArrayList<HashMap<String, String>>();
        Facility facility = this.facilityService.getFacilityByStationNumber(facilityStation);
        final HashMap<String, String> formFields = new HashMap();

        if (type.equals("delayed")) {
            if (ssaDelay != null) {
                inputStream = IOUtils.toInputStream(this.getMailTemplateDAO().getByLetterType(3L).getText(), "UTF-8");
            } else if (eheDelay != null) {
                inputStream = IOUtils.toInputStream(this.getMailTemplateDAO().getByLetterType(2L).getText(), "UTF-8");
            }

            templateString = new Scanner(inputStream, "UTF-8").useDelimiter("\\A").next();
            if(inputStream != null) {
                inputStream.close();
            }
            formFields.put("[entryDate]", letterFormat.format(delayedConsent.getDateAdded()));
            String delayReasonString = "";
            for (int i = 0; i < delayedReasons.length; i++) {
                delayedReasons[i] = delayedReasons[i].replaceAll("[^0-9]+", "");
                delayedReasons[i] = this.getDelayReasonDAO().findByDelayReasonId(Long.parseLong(delayedReasons[i])).getName();
                if (delayedReasons.length == (i + 1)) {
                    if (delayedReasons.length > 5) {
                        delayReasonString += "\n" + delayedReasons[i];
                    } else {
                        delayReasonString += delayedReasons[i];
                    }
                } else {
                    delayReasonString += delayedReasons[i] + ", ";
                }
            }
            templateString = templateString.replace("[reasonsForDelay]", delayReasonString);
        } else if (type.equals("revoked")) {
            inputStream = IOUtils.toInputStream(this.getMailTemplateDAO().getByLetterType(1L).getText(), "UTF-8");
            templateString = new Scanner(inputStream, "UTF-8").useDelimiter("\\A").next();
            formFields.put("[purpose]", consentDirective.getPurposeOfUse().getPouValue());
            formFields.put("[optoutDate]", letterFormat.format(consentDirective.getOptoutDate()));
            formFields.put("[expirationDate]", letterFormat.format(consentDirective.getExpirationDate()));
        } else if (type.equals("expiring")) {
            inputStream = IOUtils.toInputStream(this.getMailTemplateDAO().getByLetterType(4L).getText(), "UTF-8");
            templateString = new Scanner(inputStream, "UTF-8").useDelimiter("\\A").next();
            inputStream.close();

            if (!NullChecker.isNullOrEmpty(consentDirective)) {
                if (consentDirective.getOptinConsentType().getName().equals("SSA Authorization")) {
                    formFields.put("[consentDescription]", "Authorized access to Social Security Administration");
                    formFields.put("[consentName]", consentDirective.getOptinConsentType().getName());
                } else if (consentDirective.getOptinConsentType().getName().equals("NwHIN Authorization")) {
                    formFields.put("[consentDescription]", "Authorized access to Providers and Organizations");
                    formFields.put("[consentName]", "eHealth Exchange Authorization");
                }
                formFields.put("[purpose]", consentDirective.getPurposeOfUse().getPouValue());
                formFields.put("[entryDate]", letterFormat.format(consentDirective.getOptinTS()));
                formFields.put("[expirationDate]", letterFormat.format(consentDirective.getExpirationDate()));
            }
        }

        //get patient details
        formFields.put("[date]", new SimpleDateFormat("dd MMM, yyyy").format(new Date()));
        formFields.put("[firstName]", patientDemographics.getFirstName());
        formFields.put("[lastName]", patientDemographics.getLastName());
        formFields.put("[middleName]", patientDemographics.getMiddleName());
        formFields.put("[facilityName]", facility.getFacilityName());
        String address1 = (facility.getAddress() != null) ? facility.getAddress() : "";
        formFields.put("[facilityAddress1]", address1);
        String address2 = (facility.getCity() != null) ? facility.getCity() + ", " : "";
        address2 += (facility.getState() != null) ? facility.getState() + " " : "";
        address2 += (facility.getPostalCode() != null) ? facility.getPostalCode() : "";
        formFields.put("[facilityAddress2]", address2);
        String phone = (facility.getPhone() != null) ? facility.getPhone() : "";

        if (!NullChecker.isNullOrEmpty(phone)) {
            phone = "(" + phone.substring(0, 3) + ") " + phone.substring(3, 6) + "-" + phone.substring(6);
        }
        formFields.put("[facilityPhone]", phone);

        //Get and format patient address.
        String address = patientDemographics.getStreetAddressLine1() + "\n";
        if (!patientDemographics.getStreetAddressLine2().equals("")) {
            address += patientDemographics.getStreetAddressLine2() + "\n";
        }
        if (!patientDemographics.getStreetAddressLine3().equals("")) {
            address += patientDemographics.getStreetAddressLine3() + "\n";
        }

        address += patientDemographics.getResidenceCity() + ", " + patientDemographics.getResidenceState() + " " + patientDemographics.getResidenceZip4();

        templateString = templateString.replace("[patientAddress]", address);

        templateString = templateString.replace("[signature]", signature);

        patientDetails.add(formFields);

        PdfGenerator pdfGenerator = new PdfGenerator();
        ByteArrayOutputStream pdfStream = pdfGenerator.create(templateString, patientDetails, type);

        return pdfStream;
    }

    //mutators
    public FacilityService getFacilityService() {
        return facilityService;
    }

    public MailTemplateDAO getMailTemplateDAO() {
        return mailTemplateDAO;
    }

    public DelayReasonDAO getDelayReasonDAO() {
        return delayReasonDAO;
    }

    public MailNotificationDAO getMailNotificationDAO() {
        return mailNotificationDAO;
    }

    public void setFacilityService(FacilityService facilityService) {
        this.facilityService = facilityService;
    }

    public void setMailTemplateDAO(MailTemplateDAO mailTemplateDAO) {
        this.mailTemplateDAO = mailTemplateDAO;
    }

    public void setDelayReasonDAO(DelayReasonDAO delayReasonDAO) {
        this.delayReasonDAO = delayReasonDAO;
    }

    public void setMailNotificationDAO(MailNotificationDAO mailNotificationDAO) {
        this.mailNotificationDAO = mailNotificationDAO;
    }
}
