package gov.va.nvap.web.util.file;

import gov.va.nvap.common.validation.NullChecker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.fileupload.FileItem;

/**
 * File upload utility. Uses apache-fileuploads API.
 * 
 * @author Asha Amritraj
 */
public class FileUploadUtil {

	/**
	 * Add file item to a list of items.
	 */
	public static List<FileItem> addFileItem(final List<FileItem> fileItems,
			List<FileItem> filesUploaded) throws IOException {
		for (final FileItem fileItemTemp : fileItems) {
			if (NullChecker.isNotEmpty(fileItemTemp)
					&& !fileItemTemp.isFormField()) {
				if (NullChecker.isEmpty(filesUploaded)) {
					filesUploaded = new ArrayList<FileItem>();
				}
				if (NullChecker.isNotEmpty(fileItemTemp)) {
					filesUploaded.add(fileItemTemp);
				}
			}
		}
		return filesUploaded;
	}

	public static List<FileItem> getFilesUploaded(final List<FileItem> fileItems) {
		if (NullChecker.isEmpty(fileItems)) {
			return null;
		}
		final List<FileItem> filesUploaded = new ArrayList<FileItem>();
		for (final FileItem fileItem : fileItems) {
			if (NullChecker.isNotEmpty(fileItem)
					&& !fileItem.isFormField()) {
				if (NullChecker.isNotEmpty(fileItem)) {
					filesUploaded.add(fileItem);
				}
			}
		}
		return filesUploaded;
	}

	public static Map<String, String> getFormFields(
			final List<FileItem> fileItems) {
		if (NullChecker.isEmpty(fileItems)) {
			return null;
		}
		final Map<String, String> formFields = new HashMap<String, String>();
		for (final FileItem fileItem : fileItems) {
			if (NullChecker.isNotEmpty(fileItem)) {
				if (fileItem.isFormField()) {
					formFields.put(fileItem.getFieldName(),
							fileItem.getString());
				}
			}
		}
		return formFields;
	}

	/**
	 * Remove a file item from a list of items.
	 */
	public static List<FileItem> removeFileItem(final List<FileItem> items,
			final String fileName) {
		if (NullChecker.isNotEmpty(items)) {
			if (NullChecker.isNotEmpty(fileName)) {
				for (final FileItem item : items) {
					if (fileName.equals(item.getName())) {
						items.remove(item);
						break;
					}
				}
			}
		}
		return items;
	}
}
