package gov.va.nvap.web.util.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * Utility to parse dates.
 * 
 * @author Asha Amritraj
 * 
 */
public class DateUtil {

	public static Date addTime(final Date date, final int field,
			final int amount) {
		final Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.add(field, amount);
		final Date newDate = cal.getTime();
		return newDate;

	}

	/**
	 * Parse date MM/dd/yyyy.
	 */
	public static Date parseDateMMddyyyy(final String dateString) {
		final SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
		try {
			return formatter.parse(dateString);
		} catch (final ParseException t) {
			throw new RuntimeException(t);
		}
	}

	/**
	 * Time zero! In the beginning...
	 */
	public static Date voidTime(final Date date) {
		final Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}
}
