package gov.va.nvap.web.util;


import gov.va.nvap.web.consent.audit.AuditedConsent;

import java.util.ArrayList;
import java.util.List;


/**
 * @author Stephen T Miller
 */
public class TestData {

	public TestData() {

	}

	public List<AuditedConsent> excludeTestData(
			List<AuditedConsent> auditedConsentList) {
		//no test data allowed
		List<AuditedConsent> returnList = new ArrayList<AuditedConsent>();
		for(AuditedConsent ac:auditedConsentList){
			if(!this.isTestEntry(ac)){
				returnList.add(ac);
			}
		}
		return returnList;
	}

	public List<AuditedConsent> ensureTestData(
			List<AuditedConsent> auditedConsentList) {
		//only test data should be allowed in the return list
		List<AuditedConsent> returnList = new ArrayList<AuditedConsent>();
		for(AuditedConsent ac:auditedConsentList){
			if(this.isTestEntry(ac)){
				returnList.add(ac);
			}
		}
		return returnList;
	}

	private boolean isTestEntry	(AuditedConsent test){
		String last = test.getPatientLastName();
		String ssn = test.getPatientSsn();
		String ssnAbr3 = ssn.substring(0,2); //first three
		String ssnAbr8 = ssn.substring(0, 7);
		if((last.contains("ZZZ") || last.contains("zzz") ||	last.contains("test") || last.contains("TEST")) &&
				(ssnAbr3.equals("666") || ssnAbr8.equals("00000000"))){
			return true;
		}
		return false;
	}
	
}
