/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.web.util;

import java.io.Serializable;

import javax.servlet.http.HttpServletRequest;

/**
 * Paginator to navigate through records in the reports.
 * 
 * @author David Vazquez
 */
public class Paginator implements Serializable {
	
	private int currentPage = 0;
	private final int recordsPerPage;
	private boolean nextDisabled = false;

	public Paginator(final int recordsPerPage) {
		this.recordsPerPage = recordsPerPage;
	}

	public int getCurrentPage() {
		return this.currentPage;
	}

	public int getRecordsPerPage() {
		return this.recordsPerPage;
	}

	public void next(final HttpServletRequest request) {
		this.currentPage = Integer
				.parseInt(request.getParameter("currentPage"));
		++this.currentPage;
	}

	public void previous(final HttpServletRequest request) {
		this.currentPage = Integer
				.parseInt(request.getParameter("currentPage"));
		--this.currentPage;
	}

	public void reset() {
		this.currentPage = 0;
		this.nextDisabled = false;
	}

	/**
	 * @return the nextDisabled
	 */
	public boolean isNextDisabled() {
		return nextDisabled;
	}

	/**
	 * @param nextDisabled the nextDisabled to set
	 */
	public void setNextDisabled(boolean nextDisabled) {
		this.nextDisabled = nextDisabled;
	}
}
