package gov.va.nvap.web.util;

import gov.va.nvap.common.validation.NullChecker;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 *
 * @author Johann Sonnenberg
 * @since 07/01/2016
 */
public class ErrorHandler extends HttpServlet {

    private static final Logger LOGGER = Logger.getLogger(ErrorHandler.class.getName());

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        handleForward(request, response);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private void handleForward(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        final HttpSession session = request.getSession(false);
        String customMessage = "";
        String exType = "" + request.getAttribute("javax.servlet.error.message");
        String errorCode = "" + request.getAttribute("javax.servlet.error.status_code");
        Boolean isAjax = "XMLHttpRequest".equals(request.getHeader("X-Requested-With"));
        String nextJSP = "/WEB-INF/web/error/genericError.jsp";

        //based on the type of exception, create the custom message to show on the generalError page
        if ("gov.va.nvap.service.audit.AuditException".equals(exType)) {
            customMessage = "There was a problem connecting to the Exchange Service.";
        } else if ("gov.va.nvap.service.pdq.PdqException".equals(exType)) {
            customMessage = "There was a problem connecting to the MVI Service.";
        } else if ("java.util.concurrent.TimeoutException".equals(exType)) {
            customMessage = "The server is currently busy and a timeout has occurred.";
        } else if ("gov.va.nvap.service.adapter.audit.DirectServiceException".equals(exType)) {
            customMessage = "There was a problem connecting to the Direct Service.";
        } else if ("UserNameException".equals(exType)) {
            customMessage = "User name not present in request. User may not be authenticated.";
        } else if ("UserRoleException".equals(exType)) {
            customMessage = "The user is not in a permitted role.";
        } else if ("404".equals(errorCode)) {
            customMessage = "The page you requested does not exist.";
        }

        request.setAttribute("customMessage", customMessage); //the "nice" error message
        request.setAttribute("isLoggedIn", !NullChecker.isNullOrEmpty(session)); //used whether to show the left nav based on if a user is logged in or not
        request.setAttribute("errorCode", errorCode);

        if (!NullChecker.isNullOrEmpty(session) && !NullChecker.isNullOrEmpty(session.getAttribute("debug"))
            && "true".equals(session.getAttribute("debug").toString())) {
            if (!NullChecker.isNullOrEmpty(errorCode) && !"500".equals(errorCode)) {
                // If this is a 500 error we know something went bad on the Java/Server side
                String st = exType;
                request.setAttribute("fullStackTrace", st);
            } else {
                String st = (String) session.getAttribute("exceptionTrace");
                // FYI, the stace trace is in the session set by the ResponseDispatcherHttpServlet as "exceptionTrace"
                request.setAttribute("fullStackTrace", st);
            }
        }

        //set if this was an ajax request or not as we need to handle it differently
        request.setAttribute("isAjax", isAjax);

        //log the exception
        Object exObj = request.getAttribute("javax.servlet.error.exception");
        if(exObj instanceof Throwable) {
            LOGGER.log(Level.SEVERE, "Exception caught in ErrorHandler.", (Throwable)exObj);
        } else {
            LOGGER.log(Level.SEVERE, "Exception caught in ErrorHandler: {0}", exObj);
        }

        //if this is an ajax request, set the generic ajax error page (just returns JSON)
        if(isAjax){
            nextJSP = "/WEB-INF/web/error/genericAjaxError.jsp";
        }

        //redirect to the generic error page
        RequestDispatcher dispatcher = getServletContext().getRequestDispatcher(nextJSP);
        dispatcher.forward(request, response);
    }
}