package gov.va.nvap.web.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * Class to hold all constants.
 * @author Sridhar Varma Alluri
 * @since 12/17/2014
 */
public class Constants {
	public static final boolean PURPOSE_OF_USE_FLAG = true;
    
    private static final String APPLICATION_PROPERTIES_FILE = "gov/va/nvap/web/application.properties";
    private static final String ENDPOINTS_PROPERTIES_FILE = "gov/va/nvap/web/endpoints.properties";
    private static final String ORGANIZATION_NAME = "organizationName";
    private static final String EXPIRED_NOTIFICATION_LETTERS_MAXTIME = "expiredNotificationLettersMaxTime";
    private static final String EXPIRED_NOTIFICATION_PERLETTER_TIME = "expiredNotificationPerLetterTime";
    private static final String DAS_RETRIEVEDOCUMENT = "das.retrieveDocument";
    private static final String DAS_RETRIEVEONEDOCUMENT = "das.retrieveOneDocument";
    private static final String DAS_USEMOCKRETRIEVE = "das.useMockRetrieve";
    
    private static String organizationName;
    private static String expiredNotificationLettersMaxTime;
    private static String expiredNotificationPerLetterTime;
    
    private static String dasRetrieveDocumentEndPoint;
    private static String dasRetrieveOneDocumentEndPoint;
    private static boolean dasUseMockRetrieve = true;
    
    static{
    	 InputStream propInStream = 
    			 Constants.class.getClassLoader().getResourceAsStream(APPLICATION_PROPERTIES_FILE);
         
         Properties appProperties = new Properties();
         if (propInStream != null) {
             try {
                 appProperties.load(propInStream);
                 organizationName = appProperties.getProperty(ORGANIZATION_NAME);
                 expiredNotificationLettersMaxTime = appProperties.getProperty(EXPIRED_NOTIFICATION_LETTERS_MAXTIME);
                 expiredNotificationPerLetterTime = appProperties.getProperty(EXPIRED_NOTIFICATION_PERLETTER_TIME);
                 
             } catch (IOException ex) {
                 organizationName = "eHealth Exchange";
             }finally{
            	 try{
            		 propInStream.close();
            	 } catch (IOException ex) {
            		 organizationName = "eHealth Exchange";
                 }
             }             
         }
         else {
             organizationName = "eHealth Exchange";
         }
         
         InputStream endPointInStream = 
        		 Constants.class.getClassLoader().getResourceAsStream(ENDPOINTS_PROPERTIES_FILE);
         
         Properties endPointProperties = new Properties();
         if (endPointInStream != null) {
             try {
             	endPointProperties.load(endPointInStream);
                dasRetrieveDocumentEndPoint = endPointProperties.getProperty(DAS_RETRIEVEDOCUMENT);
                dasRetrieveOneDocumentEndPoint = endPointProperties.getProperty(DAS_RETRIEVEONEDOCUMENT);
                dasUseMockRetrieve = Boolean.parseBoolean(endPointProperties.getProperty(DAS_USEMOCKRETRIEVE));
                endPointInStream.close();
             } catch (IOException ex) {
             	dasRetrieveDocumentEndPoint = "";
                dasRetrieveOneDocumentEndPoint  = "";
             	dasUseMockRetrieve = true;
             } finally{
            	 try{
            		 endPointInStream.close();
            	 } catch (IOException ex) {
                  	dasRetrieveDocumentEndPoint = "";
                    dasRetrieveOneDocumentEndPoint  = "";
                 	dasUseMockRetrieve = true;
                 }
             }               

         }
         else {
         	dasRetrieveDocumentEndPoint = "";
                dasRetrieveOneDocumentEndPoint  = "";
         	dasUseMockRetrieve = true;
         }
         
    }
    public Constants(){       
    }
    
    public static String getOrganizationName() {
        return organizationName;
    }
    
    public static String getExpiredNotificationLettersMaxTime() {
        return expiredNotificationLettersMaxTime;
    }
    
    public static String getExpiredNotificationPerLetterTime() {
        return expiredNotificationPerLetterTime;
    }
    
    public static String getDasRetrieveDocumentEndPoint() {
        return dasRetrieveDocumentEndPoint;
    }
     public static String getDasRetrieveOneDocumentEndPoint() {
        return dasRetrieveOneDocumentEndPoint;
    }

	public static boolean isDasUseMockRetrieve() {
		return dasUseMockRetrieve;
	}      
}
