package gov.va.nvap.web.user.role;

import java.io.Serializable;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

/**
 *
 * @author Zack Peterson
 */
@Entity
@Table(name = "USER_ROLE")
@NamedQueries({
		@NamedQuery(name = "UserRole.findAll", query = "SELECT r FROM UserRole r"),
		@NamedQuery(name = "UserRole.findByUserName", query = "SELECT r FROM UserRole r WHERE lower(r.userName) = :userName"),
		@NamedQuery(name = "UserRole.findUserRoleNames", query = "SELECT r.allowedRole.roleName FROM UserRole r WHERE lower(r.userName) = :userName")})
public class UserRole implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	@Basic(optional = false)
	@Column(name = "USER_ROLE_ID")
	private Long userRoleId;
    @Basic(optional = false)
	@Column(name = "USER_NAME")
	private String userName;
    @JoinColumn(name = "USER_ROLE", referencedColumnName = "ROLE_ID")
    @ManyToOne
    private AllowedRole allowedRole;

	public UserRole() {
	}

    public UserRole(final String userName) {
		this.userName = userName;
	}

    public UserRole(final String userName, final AllowedRole allowedRole) {
		this.userName = userName;
        this.allowedRole = allowedRole;
	}

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public AllowedRole getAllowedRole() {
        return allowedRole;
    }

    public void setAllowedRole(AllowedRole allowedRole) {
        this.allowedRole = allowedRole;
    }

    public Long getUserRoleId() {
        return userRoleId;
    }

    public void setUserRoleId(Long userRoleId) {
        this.userRoleId = userRoleId;
    }
}
