package gov.va.nvap.web.user.role;

import java.io.Serializable;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

/**
 *
 * @author Zack Peterson
 */
@Entity
@Table(name = "ALLOWED_ROLE")
@NamedQueries({
		@NamedQuery(name = "AllowedRole.findAll", query = "SELECT r FROM AllowedRole r"),
		@NamedQuery(name = "AllowedRole.findRoleInCollection", query = "SELECT r FROM AllowedRole r WHERE r.roleName in (:roleNames)"),
		@NamedQuery(name = "AllowedRole.findByRoleId", query = "SELECT r FROM AllowedRole r WHERE r.roleId = :roleId"),
		@NamedQuery(name = "AllowedRole.findByRoleName", query = "SELECT r FROM AllowedRole r WHERE r.roleName = :roleName")})
public class AllowedRole implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	@Basic(optional = false)
	@Column(name = "ROLE_ID")
	private Long roleId;
    @Basic(optional = false)
	@Column(name = "ROLE_NAME")
	private String roleName;

	public AllowedRole() {
	}

    public AllowedRole(final String roleName) {
		this.roleName = roleName;
	}

    public Long getRoleId() {
        return roleId;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }
}
