/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.web.user.document;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 *
 * @author Zack Peterson
 */
@Entity
@Table(name = "USER_DOCUMENT")
@NamedQueries({
		@NamedQuery(name = "UserDocument.findAll", query = "SELECT d FROM UserDocument d"),
		@NamedQuery(name = "UserDocument.findByDocumentId", query = "SELECT d FROM UserDocument d WHERE d.documentId = :documentId"),
		@NamedQuery(name = "UserDocument.findByUserId", query = "SELECT d FROM UserDocument d WHERE d.userId = :userId"),
		@NamedQuery(name = "UserDocument.findByTitle", query = "SELECT d FROM UserDocument d WHERE d.title = :title"),
        @NamedQuery(name = "UserDocument.findByUserIdAndTitle", query = "SELECT d FROM UserDocument d WHERE d.userId = :userId AND d.title = :title"),
        @NamedQuery(name = "UserDocument.findByCreationDate", query = "SELECT d FROM UserDocument d WHERE d.creationDate = :creationDate"),
        @NamedQuery(name = "UserDocument.findByBeforeDate", query = "SELECT d FROM UserDocument d WHERE d.creationDate < :cutoffDate")})
public class UserDocument implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	@Basic(optional = false)
	@Column(name = "DOCUMENT_ID")
	private Long documentId;
    @Basic(optional = false)
	@Column(name = "USER_ID")
	private String userId;
    @Basic(optional = false)
    @Column(name = "CREATION_DATE")
    @Temporal(TemporalType.TIMESTAMP)
    private Date creationDate;
    @Basic(optional = false)
    @Column(name = "TITLE")
	private String title;
	@Lob
	@Column(name = "CONTENT")
	private Serializable content;
    @Column(name = "STATUS")
	private String status;
    @Column(name = "FORMAT")
	private String format;

	public UserDocument() {
	}

    public UserDocument(final String title, final Date creationDate, final String userId) {
		this.title = title;
        this.creationDate = creationDate;
        this.userId = userId;
	}

    public UserDocument(final String title, final Date creationDate,
            final String userId, final Serializable content) {
		this.title = title;
        this.creationDate = creationDate;
        this.userId = userId;
        this.content = content;
	}

    public UserDocument(final String title, final Date creationDate,
            final String userId, final Serializable content, final String status) {
		this.title = title;
        this.creationDate = creationDate;
        this.userId = userId;
        this.content = content;
        this.status = status;
	}

    public UserDocument(final String title, final Date creationDate, final String userId,
            final Serializable content, final String status, final String format) {
		this.title = title;
        this.creationDate = creationDate;
        this.userId = userId;
        this.content = content;
        this.status = status;
        this.format = format;
	}

	public UserDocument(final Long documentId) {
		this.documentId = documentId;
	}

	public UserDocument(final Long documentId, final Serializable content) {
		this.documentId = documentId;
		this.content = content;
	}

    public UserDocument(final Long documentId, final String title, final Date creationDate,
            final String userId, final Serializable content) {
        this.documentId = documentId;
		this.title = title;
        this.creationDate = creationDate;
        this.userId = userId;
        this.content = content;
	}

    public UserDocument(final Long documentId, final String title, final Date creationDate,
            final String userId, final Serializable content, final String status) {
        this.documentId = documentId;
		this.title = title;
        this.creationDate = creationDate;
        this.userId = userId;
        this.content = content;
        this.status = status;
	}

    public UserDocument(final Long documentId, final String title, final Date creationDate,
            final String userId, final Serializable content, final String status, final String format) {
        this.documentId = documentId;
		this.title = title;
        this.creationDate = creationDate;
        this.userId = userId;
        this.content = content;
        this.status = status;
        this.format = format;
	}

	@Override
	public boolean equals(final Object object) {
		// TODO: Warning - this method won't work in the case the id fields are
		// not set
		if (!(object instanceof UserDocument)) {
			return false;
		}
		final UserDocument other = (UserDocument) object;
		if (((this.documentId == null) && (other.documentId != null))
				|| ((this.documentId != null) && !this.documentId
						.equals(other.documentId))) {
			return false;
		}
		return true;
	}

	public Serializable getContent() {
		return this.content;
	}

	public Long getDocumentId() {
		return this.documentId;
	}

    public String getUserId() {
        return userId;
    }

    public String getTitle() {
        return title;
    }

	@Override
	public int hashCode() {
		int hash = 0;
		hash += (this.documentId != null ? this.documentId.hashCode() : 0);
		return hash;
	}

	public void setContent(final Serializable content) {
		this.content = content;
	}

	public void setDocumentId(final Long documentId) {
		this.documentId = documentId;
	}

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getFormat() {
        return format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

	@Override
	public String toString() {
		return "gov.va.nvap.web.user.document.UserDocument[documentId="
				+ this.documentId + "]";
	}
}
