/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.web.user.dashboard;

import gov.va.nvap.service.auth.ServiceAuditDAO;
import java.io.IOException;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONException;
import org.json.JSONObject;

/**
 *
 * @author Raul Alfaro
 */
public class TransactionHistoryWidget extends gov.va.nvap.web.app.ResponseDispatcherHttpServlet {

   @Override
    protected void unspecified(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        final HttpSession session = request.getSession(false);
        
        session.setAttribute("results", encodeToJSON( gatherPast24HourCounts() ));
        
        this.forward(request, response, "searchResultsJSON");
    }
    
    /**
     * gets the counts for exchange calls and ebenefits calls per hour in military time.
     * Packages into GatheredCounts object if the hours have any data
     * @return 
     */
    private Map<String,GatheredCounts> gatherPast24HourCounts(){
        
        Calendar calendarLowerBound = Calendar.getInstance();
        calendarLowerBound.set(Calendar.MINUTE, 0);
        calendarLowerBound.set(Calendar.SECOND, 0);
        calendarLowerBound.set(Calendar.MILLISECOND, 0);
        calendarLowerBound.add(Calendar.HOUR_OF_DAY, -23);
        
        Calendar calendarUpperBound = Calendar.getInstance();
        calendarUpperBound.set(Calendar.MINUTE, 59);
        calendarUpperBound.set(Calendar.SECOND, 59);
        calendarUpperBound.set(Calendar.MILLISECOND, calendarUpperBound.getActualMaximum(Calendar.MILLISECOND));
        
        ServiceAuditDAO dao = getServiceAuditDAO();
        List<Object[]> countResults = 
                dao.gatherTransactionCounts(calendarLowerBound.getTime(), calendarUpperBound.getTime());
        
        Map<String,GatheredCounts> preppedResults = new HashMap<>();
        
        //add all hours that had activity
        for(Object[] currentRow: countResults){
            GatheredCounts currentCounts = new GatheredCounts();
            
            currentCounts.militaryHour = Integer.parseInt(currentRow[0].toString());
            currentCounts.exchangeCount = Integer.parseInt(currentRow[1].toString());
            currentCounts.ebenefitsCount = Integer.parseInt(currentRow[2].toString());
            
            preppedResults.put(currentRow[0].toString(), currentCounts);
        }
        
        return preppedResults;
    }
    
    
    /**
     * converts any returned GatherCounts into json string, fills in blank hours with 0 counts.
     * The data is ordered oldest to newest
     * @param prepedResults
     * @return 
     */
    private String encodeToJSON(Map<String,GatheredCounts> prepedResults){
        String jsonString = "";
        
        try {
            StringWriter json = new StringWriter();
            JSONObject obj = new JSONObject();
            List ebenefits = new ArrayList<>();
            List exchange = new ArrayList<>();
            List labels = new ArrayList<>();
            
            Calendar calendar = Calendar.getInstance();
            int hourOfDay = calendar.get(Calendar.HOUR_OF_DAY);
            
            //Prep the calendar instances and formats that will be used for entry labels
            Calendar calendarLowerBound = getLowerBoundary();
            DateFormat dateFormatLower = new SimpleDateFormat("MM/dd hh:00 a");

            //get all information for previous day. filling in blanks with 0 counts
            //Filling in the labels for each hour
            for(int i=hourOfDay+1; i<24; i++){
                String key = String.valueOf(i);
                
                if(prepedResults.containsKey(key)){
                    ebenefits.add(prepedResults.get(key).ebenefitsCount);
                    exchange.add(prepedResults.get(key).exchangeCount);
                    labels.add(dateFormatLower.format(calendarLowerBound.getTime()));
                } else {
                    ebenefits.add(0);
                    exchange.add(0);
                    labels.add(dateFormatLower.format(calendarLowerBound.getTime()));
                }
                
                //Hour is incremented for the following loop to use retrieve the next hour
                calendarLowerBound.add(Calendar.HOUR, 1);
            }
            
            //get all information for current day. filling in blanks with 0 counts
            //Filling in the labels for each hour
            for(int i=0; i<=hourOfDay; i++){
                String key = String.valueOf(i);
                
                if(prepedResults.containsKey(key)){
                    ebenefits.add(prepedResults.get(key).ebenefitsCount);
                    exchange.add(prepedResults.get(key).exchangeCount);
                    labels.add(dateFormatLower.format(calendarLowerBound.getTime()));
                } else {
                    ebenefits.add(0);
                    exchange.add(0);
                    labels.add(dateFormatLower.format(calendarLowerBound.getTime()));
                }
                //Hour is incremented for the following loop to use retrieve the next hour
                calendarLowerBound.add(Calendar.HOUR, 1);
            }
            
            obj.put("ebenefits", ebenefits);
            obj.put("exchange",exchange);
            obj.put("labels", labels);
            obj.write(json);

            jsonString = json.toString();
        } catch (JSONException ex) {
            Logger.getLogger(TransactionHistoryWidget.class.getName()).log(Level.SEVERE, null, ex);
        }
        return jsonString;
    }
    
    /**
     * Prepares the calendar instance for the floor of the search hour
     * current hour with 0 minutes - 23 hours
     * Used for label purposes
     * @return 
     */
    private Calendar getLowerBoundary(){
        Calendar calendarLowerBound = Calendar.getInstance();
        
        calendarLowerBound.set(Calendar.MINUTE, 0);
        calendarLowerBound.set(Calendar.SECOND, 0);
        calendarLowerBound.set(Calendar.MILLISECOND, 0);
        calendarLowerBound.add(Calendar.HOUR_OF_DAY, -23);
            
        return calendarLowerBound;
    }
    
    public ServiceAuditDAO getServiceAuditDAO()
    {
        return this.getBean("ServiceAuditDAO", ServiceAuditDAO.class);
    }
    
    
    private class GatheredCounts {
        long ebenefitsCount = 0;
        long exchangeCount = 0;
        int militaryHour;
    }
    
}
