package gov.va.nvap.web.user.dashboard;

import gov.va.nvap.web.consent.audit.dao.AuditedConsentDAO;
import gov.va.nvap.web.helper.report.ReportHelper;
import java.io.IOException;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONException;
import org.json.JSONObject;

/**
 *
 * @author Raul Alfaro
 */
public class MonthlyConsentsWidget extends gov.va.nvap.web.app.ResponseDispatcherHttpServlet {

    @Override
    protected void unspecified(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        final HttpSession session = request.getSession(false);
        
        session.setAttribute("results", gatherAllConsentCounts(request));
        this.forward(request, response, "searchResultsJSON");
    }

    /**
     * prepares JSON object as String for the ConsentCount widget. Including new eBenifits consents, new manually added consents, and # of
     * reauthorizations for the given month Default month is current.
     *
     * @param request
     * @return
     */
    public String gatherAllConsentCounts(HttpServletRequest request) {
        String jsonString = "";

        try {
            StringWriter json = new StringWriter();
            JSONObject obj = new JSONObject();

            obj.put("eBenefitsAddedAuths", getAuthorizationCount(request, "NwHINAuthorizations", "eBenefits"));
            obj.put("manuallyAddedAuths", getAuthorizationCount(request, "NwHINAuthorizations", "employee"));
            obj.put("addedReAuths", getAuthorizationCount(request, "NwHINRevocations", ""));
            obj.put("ssaAuthAutomated", getAuthorizationCount(request, "SSAAuthorizations", "Automated"));

            Calendar calendar = Calendar.getInstance();
            //make sure the requested date is displayed.
            final int monthAdjustmentValue = Integer.parseInt(request.getParameter("monthAdjustmentValue"));
            if (monthAdjustmentValue < 0) {
                calendar.add(Calendar.MONTH, monthAdjustmentValue);
            }
            obj.put("month", calendar.getDisplayName(Calendar.MONTH, Calendar.LONG, Locale.US));
            obj.put("year", calendar.get(Calendar.YEAR));

            obj.write(json);

            jsonString = json.toString();
        } catch (JSONException ex) {
            Logger.getLogger(MonthlyConsentsWidget.class.getName()).log(Level.SEVERE, null, ex);
        }

        return jsonString;
    }

    /**
     * gets the count for authorizations based on parameters
     *
     * @param request
     * @param enteredBy
     * @param optInSearch
     * @param month
     * @return
     */
    private long getAuthorizationCount(HttpServletRequest request, String consentType, String enteredBy) {
        final AuditedConsentDAO auditedConsentDAO = getAuditedConsentDao();
        int monthAdjustmentValue = Integer.parseInt(request.getParameter("monthAdjustmentValue"));
        final AuditedConsentDAO.DetailRequest preparedRequested = prepareAuditRequest(request, consentType, enteredBy, monthAdjustmentValue);
        long countQueryResults = auditedConsentDAO.getEventsCount(preparedRequested);
        //the count is the only entry in the list
        return countQueryResults;
    }

    /**
     * prepares the audit request parameters based on the defaults. Retrieving new consents this month. enteredBy parameter should be either
     * 'eBenefits', 'employee", or "" for all. If default facility is not present, all is used. optInSearch boolean is true all new
     * authorizations, false for only reauthorizations
     *
     * @param session
     * @param enteredBy
     * @param optInSearch
     * @param month
     * @return
     */
    private AuditedConsentDAO.DetailRequest prepareAuditRequest(HttpServletRequest request, String consentType, String enteredBy, int monthAdjustment) {
        final AuditedConsentDAO auditedConsentDAO = getAuditedConsentDao();
        final AuditedConsentDAO.DetailRequest req = auditedConsentDAO.new DetailRequest();
        final HttpSession session = request.getSession(false);
        final gov.va.nvap.svc.facility.data.Facility facility = (gov.va.nvap.svc.facility.data.Facility) session.getAttribute("defaultUserFacility");
        DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        Calendar calendar = Calendar.getInstance();

        //a previous month was requested.
        if (monthAdjustment < 0) {
            calendar.add(Calendar.MONTH, monthAdjustment);
        }

        calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
        String startDateString = dateFormat.format(calendar.getTime());
        calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMaximum(Calendar.DAY_OF_MONTH));
        String endDateString = dateFormat.format(calendar.getTime());

        req.stationNumbers = facility != null ? facility.getFacilityStation() : "ALL";
        req.consentType = consentType;
        req.inactivationReason = enteredBy.isEmpty() ? "New Authorization" : "";
        req.startDate = ReportHelper.getStartDate(startDateString);
        req.endDate = ReportHelper.getEndDate(endDateString);
        req.patientTypes = 1;
        req.userId = enteredBy;
        req.includeUnknownVisn = (facility == null);
        //remaining parameters are not used, so may remain unintiated.

        return req;
    }

    private AuditedConsentDAO getAuditedConsentDao() {
        return this.getBean("auditedConsentDAO", AuditedConsentDAO.class);
    }

}
