/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.web.user.dashboard;

import java.io.IOException;
import java.util.Calendar;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import gov.va.nvap.web.dao.UserAuditDAO;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

/**
 *
 * @author Raul Alfaro
 */
public class LoginActivityWidget extends gov.va.nvap.web.app.ResponseDispatcherHttpServlet {

    @Override
    protected void unspecified(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        final HttpSession session = request.getSession(false);
        Stack<Coordinate> logInActivity = gatherPast24HourCounts();
        session.setAttribute("results", encodeToJSON(logInActivity));
        this.forward(request, response, "searchResultsJSON");
    }

    /**
     * puts together a stack of the coordinates needed for the line graph.
     * the order will be oldest to most recent count.
     * @return 
     */
    private Stack<Coordinate> gatherPast24HourCounts(){
        
        Calendar calendarLowerBound = Calendar.getInstance();
        calendarLowerBound.set(Calendar.MINUTE, 0);
        calendarLowerBound.set(Calendar.SECOND, 0);
        calendarLowerBound.set(Calendar.MILLISECOND, 0);
        Calendar calendarUpperBound = Calendar.getInstance();
        calendarUpperBound.set(Calendar.MINUTE, 59);
        calendarUpperBound.set(Calendar.SECOND, 59);
        calendarUpperBound.set(Calendar.MILLISECOND, calendarUpperBound.getActualMaximum(Calendar.MILLISECOND));
        
        DateFormat dateFormatLower = new SimpleDateFormat("MM/dd hh:00 a");
        
        String lowerBound;
        
        //create a stack to hold everything.
        Stack<Coordinate> coordinates = new Stack<>();
        
        for(int i=0; i<24;i++){
            lowerBound = dateFormatLower.format(calendarLowerBound.getTime());
            
            final UserAuditDAO dao = getUserAuditDAO();
            Object count = (dao.getResults(calendarLowerBound.getTime(), calendarUpperBound.getTime())).get(0);
            
            //set the cord info before adding it to stack
            Coordinate currentCoord = new Coordinate();
            currentCoord.x = i;
            currentCoord.y = Integer.parseInt(count.toString());
            currentCoord.timeOffset = lowerBound;
            coordinates.push(currentCoord);
            
            //move down the bounderies for the next loop.
            calendarLowerBound.add(Calendar.HOUR, -1);
            calendarUpperBound.add(Calendar.HOUR, -1);
            
        }
        
        return coordinates;
    }
    
    /**
     * prepares the coordinate stack to json array
     * @param coords
     * @return 
     */
    private String encodeToJSON(Stack<Coordinate> coords){
        String jsonString = "";
        
        try {
            StringWriter json = new StringWriter();
            JSONObject obj = new JSONObject();
            List data = new ArrayList<>();
            List labels = new ArrayList<>();
            
            while(!coords.empty()){
                Coordinate temp = coords.pop();
                data.add(temp.y);
                labels.add(temp.timeOffset);
            }
            
            obj.put("data", data);
            obj.put("labels", labels);
            obj.write(json);

            jsonString = json.toString();
        } catch (JSONException ex) {
            Logger.getLogger(LoginActivityWidget.class.getName()).log(Level.SEVERE, null, ex);
        }
        return jsonString;
    }
    
    private UserAuditDAO getUserAuditDAO(){
        return this.getBean("UserAuditDAO", UserAuditDAO.class);
    }

    private class Coordinate {
        int x;
        int y;
        String timeOffset;
    }
    
}
